/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.BeanMapPropertyField;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapPropertyAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

class FxMapPropertyField<M, K, V, T extends ObservableMap<K, V>, R extends Property<T>>
implements PropertyField<T, M, R> {
    private Map<K, V> defaultValue;
    private final MapPropertyAccessor<M, K, V> accessor;
    private final MapProperty<K, V> targetProperty;

    FxMapPropertyField(SideEffect updateFunction, MapPropertyAccessor<M, K, V> accessor, Supplier<MapProperty<K, V>> propertySupplier) {
        this(updateFunction, accessor, propertySupplier, Collections.emptyMap());
    }

    FxMapPropertyField(SideEffect updateFunction, MapPropertyAccessor<M, K, V> accessor, Supplier<MapProperty<K, V>> propertySupplier, Map<K, V> defaultValue) {
        this.accessor = accessor;
        this.defaultValue = defaultValue;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableMap(new HashMap()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
        BeanMapPropertyField.setAll(this.accessor.apply(wrappedObject), this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanMapPropertyField.setAll(this.targetProperty, this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public void resetToDefault() {
        try {
            ((ObservableMap)this.targetProperty.get()).clear();
            BeanMapPropertyField.setAll(this.targetProperty, this.defaultValue);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashMap(this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        MapProperty<K, V> wrapperValue;
        ObservableMap modelValue = this.accessor.apply(wrappedObject).getValue();
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

