/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.DriveStrength;
import com.cburch.logisim.fpga.data.FpgaClass;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.PullBehaviors;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BoardInformation {
    private List<FpgaIoInformationContainer> myComponents;
    private String boardName;
    private BufferedImage boardPicture;
    public FpgaClass fpga = new FpgaClass();

    public BoardInformation() {
        this.clear();
    }

    public void addComponent(FpgaIoInformationContainer comp) {
        this.myComponents.add(comp);
    }

    public void clear() {
        if (this.myComponents == null) {
            this.myComponents = new LinkedList<FpgaIoInformationContainer>();
        } else {
            this.myComponents.clear();
        }
        this.boardName = null;
        this.fpga.clear();
        this.boardPicture = null;
    }

    public void setComponents(List<FpgaIoInformationContainer> comps) {
        this.myComponents.clear();
        this.myComponents.addAll(comps);
    }

    public List<FpgaIoInformationContainer> getAllComponents() {
        return this.myComponents;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public FpgaIoInformationContainer getComponent(BoardRectangle rect) {
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getRectangle().equals(rect)) continue;
            return comp;
        }
        return null;
    }

    public Map<String, ArrayList<Integer>> getComponents() {
        HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = 0;
        for (IoComponentTypes type : IoComponentTypes.KNOWN_COMPONENT_SET) {
            count = 0;
            for (FpgaIoInformationContainer comp : this.myComponents) {
                if (!comp.getType().equals((Object)type)) continue;
                list.add(count, comp.getNrOfPins());
                ++count;
            }
            if (count > 0) {
                result.put(type.toString(), (ArrayList)list.clone());
            }
            list.clear();
        }
        return result;
    }

    public String getComponentType(BoardRectangle rect) {
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getRectangle().equals(rect)) continue;
            return comp.getType().toString();
        }
        return IoComponentTypes.Unknown.toString();
    }

    public String getDriveStrength(BoardRectangle rect) {
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getRectangle().equals(rect)) continue;
            return DriveStrength.getConstrainedDriveStrength(comp.getDrive());
        }
        return "";
    }

    public BufferedImage getImage() {
        return this.boardPicture;
    }

    public List<BoardRectangle> getIoComponentsOfType(IoComponentTypes type, int nrOfPins) {
        ArrayList<BoardRectangle> result = new ArrayList<BoardRectangle>();
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getType().equals((Object)type) || type.equals((Object)IoComponentTypes.DIPSwitch) && nrOfPins > comp.getNrOfPins() || type.equals((Object)IoComponentTypes.PortIo) && nrOfPins > comp.getNrOfPins()) continue;
            result.add(comp.getRectangle());
        }
        return result;
    }

    public String getIoStandard(BoardRectangle rect) {
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getRectangle().equals(rect)) continue;
            return IoStandards.getConstraintedIoStandard(comp.getIoStandard());
        }
        return "";
    }

    public int getNrOfDefinedComponents() {
        return this.myComponents.size();
    }

    public String getPullBehavior(BoardRectangle rect) {
        for (FpgaIoInformationContainer comp : this.myComponents) {
            if (!comp.getRectangle().equals(rect)) continue;
            return PullBehaviors.getConstrainedPullString(comp.getPullBehavior());
        }
        return "";
    }

    public void setBoardName(String name) {
        this.boardName = name;
    }

    public void setImage(BufferedImage pict) {
        this.boardPicture = pict;
    }
}

