/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.gui.main.Canvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class CanvasPaintCoordinator {
    private static final int[] REPAINT_TIMESPANS = new int[]{47, 53, 49, 51, 50, 47, 53, 50, 48, 52};
    private int repaintTimespanIdx = 0;
    private Canvas canvas;
    private volatile long tDirtied;
    private volatile long tCleaned;
    private volatile long sDirtied;
    private volatile long sCleaned;
    private volatile boolean cleaning;
    private Timer timer;
    private Object lock;

    public CanvasPaintCoordinator(final Canvas canvas) {
        this.canvas = canvas;
        this.lock = new Object();
        this.tCleaned = this.tDirtied = System.currentTimeMillis();
        this.sCleaned = 0L;
        this.sDirtied = 0L;
        this.cleaning = false;
        this.timer = new Timer(1, new ActionListener(){
            final /* synthetic */ CanvasPaintCoordinator this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = this.this$0.lock;
                synchronized (object) {
                    this.this$0.sCleaned = this.this$0.sDirtied;
                    this.this$0.tCleaned = this.this$0.tDirtied;
                }
                canvas.repaint();
            }
        });
        this.timer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRepaint() {
        long now = System.currentTimeMillis();
        boolean repaintNow = false;
        long repaintSoon = 0L;
        Object object = this.lock;
        synchronized (object) {
            ++this.sDirtied;
            this.tDirtied = now;
            long ago = now - this.tCleaned;
            int repaint_timespan = REPAINT_TIMESPANS[this.repaintTimespanIdx];
            this.repaintTimespanIdx = (this.repaintTimespanIdx + 1) % REPAINT_TIMESPANS.length;
            if (!this.cleaning && ago >= (long)repaint_timespan) {
                this.cleaning = true;
                this.sCleaned = this.sDirtied;
                this.tCleaned = this.tDirtied;
                repaintNow = true;
            } else if (!this.cleaning) {
                this.cleaning = true;
                repaintSoon = (long)repaint_timespan - ago;
            }
        }
        if (repaintNow) {
            this.canvas.repaint();
        } else if (repaintSoon > 0L) {
            this.timer.setInitialDelay((int)repaintSoon);
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintCompleted() {
        long now = System.currentTimeMillis();
        boolean repaintNow = false;
        long repaintSoon = 0L;
        Object object = this.lock;
        synchronized (object) {
            this.cleaning = false;
            long ago = now - this.tCleaned;
            int repaintTimespan = REPAINT_TIMESPANS[this.repaintTimespanIdx];
            this.repaintTimespanIdx = (this.repaintTimespanIdx + 1) % REPAINT_TIMESPANS.length;
            if (this.sCleaned < this.sDirtied && ago >= (long)repaintTimespan) {
                this.cleaning = true;
                this.sCleaned = this.sDirtied;
                this.tCleaned = this.tDirtied;
                repaintNow = true;
            } else if (this.sCleaned < this.sDirtied) {
                this.cleaning = true;
                repaintSoon = (long)repaintTimespan - ago;
            }
        }
        if (repaintNow) {
            this.canvas.repaint();
        } else if (repaintSoon > 0L) {
            this.timer.setInitialDelay((int)repaintSoon);
            this.timer.start();
        }
    }
}

