/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.generic.TikZWriter;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.CircuitJList;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.GifEncoder;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportImage {
    public static final int FORMAT_GIF = 0;
    public static final int FORMAT_PNG = 1;
    public static final int FORMAT_JPG = 2;
    public static final int FORMAT_TIKZ = 3;
    public static final int FORMAT_SVG = 4;
    static final Logger logger = LoggerFactory.getLogger(ExportImage.class);
    private static final int SLIDER_DIVISIONS = 6;
    private static final int BORDER_SIZE = 5;

    private ExportImage() {
    }

    public static ImageFileFilter getFilter(int fmt) {
        switch (fmt) {
            case 0: {
                return new ImageFileFilter(fmt, Strings.S.getter("exportGifFilter"), new String[]{"gif"});
            }
            case 1: {
                return new ImageFileFilter(fmt, Strings.S.getter("exportPngFilter"), new String[]{"png"});
            }
            case 2: {
                return new ImageFileFilter(fmt, Strings.S.getter("exportJpgFilter"), new String[]{"jpg", "jpeg", "jpe", "jfi", "jfif", "jfi"});
            }
            case 3: {
                return new ImageFileFilter(fmt, Strings.S.getter("exportTikZFilter"), new String[]{"tex"});
            }
            case 4: {
                return new ImageFileFilter(fmt, Strings.S.getter("exportSvgFilter"), new String[]{"svg"});
            }
        }
        logger.error("Unexpected image format; aborted!");
        return null;
    }

    public static void doExport(Project proj) {
        boolean created;
        Frame frame = proj.getFrame();
        CircuitJList list = new CircuitJList(proj, true);
        if (list.getModel().getSize() == 0) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("exportEmptyCircuitsMessage"), Strings.S.get("exportEmptyCircuitsTitle"), 0);
            return;
        }
        OptionsPanel options = new OptionsPanel(list);
        int action = OptionPane.showConfirmDialog(frame, options, Strings.S.get("exportImageSelect"), 2, 3);
        if (action != 0) {
            return;
        }
        List<Circuit> circuits = list.getSelectedCircuits();
        double scale = options.getScale();
        boolean printerView = options.getPrinterView();
        if (circuits.isEmpty()) {
            return;
        }
        int fmt = options.getImageFormat();
        ImageFileFilter filter = ExportImage.getFilter(fmt);
        if (filter == null) {
            return;
        }
        Loader loader = proj.getLogisimFile().getLoader();
        JFileChooser chooser = loader.createChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        if (circuits.size() > 1) {
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(Strings.S.get("exportImageDirectorySelect"));
        } else {
            chooser.setFileFilter(filter);
            chooser.setDialogTitle(Strings.S.get("exportImageFileSelect"));
        }
        int returnVal = chooser.showDialog(frame, Strings.S.get("exportImageButton"));
        if (returnVal != 0) {
            return;
        }
        File dest = chooser.getSelectedFile();
        chooser.setCurrentDirectory(dest.isDirectory() ? dest : dest.getParentFile());
        if (dest.exists()) {
            int confirm;
            if (!dest.isDirectory() && (confirm = OptionPane.showConfirmDialog(proj.getFrame(), Strings.S.get("confirmOverwriteMessage"), Strings.S.get("confirmOverwriteTitle"), 0)) != 0) {
                return;
            }
        } else if (circuits.size() > 1 && !(created = dest.mkdir())) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("exportNewDirectoryErrorMessage"), Strings.S.get("exportNewDirectoryErrorTitle"), 0);
            return;
        }
        ProgressMonitor monitor = new ProgressMonitor(frame, Strings.S.get("exportImageProgress"), null, 0, 10000);
        monitor.setMillisToDecideToPopup(100);
        monitor.setMillisToPopup(200);
        monitor.setProgress(0);
        new ExportThread(frame, frame.getCanvas(), dest, filter, circuits, scale, printerView, monitor).start();
    }

    public static class ImageFileFilter
    extends FileFilter {
        private final int type;
        private final String[] extensions;
        private final StringGetter desc;

        public ImageFileFilter(int type, StringGetter desc, String[] exts) {
            this.type = type;
            this.desc = desc;
            this.extensions = new String[exts.length];
            for (int i = 0; i < exts.length; ++i) {
                this.extensions[i] = "." + exts[i].toLowerCase();
            }
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName().toLowerCase();
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.desc.toString();
        }
    }

    private static class OptionsPanel
    extends JPanel
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        final JSlider slider;
        final JLabel curScale;
        final JCheckBox printerView;
        final JRadioButton formatPng = new JRadioButton("PNG");
        final JRadioButton formatGif = new JRadioButton("GIF");
        final JRadioButton formatJpg = new JRadioButton("JPEG");
        final JRadioButton formatTikZ = new JRadioButton("TikZ");
        final JRadioButton formatSvg = new JRadioButton("SVG");
        final GridBagLayout gridbag;
        final GridBagConstraints gbc;
        final Dimension curJim;

        OptionsPanel(JList list) {
            ButtonGroup bgroup = new ButtonGroup();
            bgroup.add(this.formatPng);
            bgroup.add(this.formatGif);
            bgroup.add(this.formatJpg);
            bgroup.add(this.formatTikZ);
            bgroup.add(this.formatSvg);
            this.formatTikZ.addChangeListener(this);
            this.formatSvg.addChangeListener(this);
            this.formatPng.setSelected(true);
            this.slider = new JSlider(0, -18, 18, 0);
            this.slider.setMajorTickSpacing(10);
            this.slider.addChangeListener(this);
            this.curScale = new JLabel("222%");
            this.curScale.setHorizontalAlignment(4);
            this.curScale.setVerticalAlignment(0);
            Dimension d = this.curScale.getPreferredSize();
            this.curJim = new Dimension(AppPreferences.getScaled(d.width + (d.width >> 1)), AppPreferences.getScaled(d.height));
            this.curJim.height = Math.max(this.curJim.height, this.slider.getPreferredSize().height);
            this.stateChanged(null);
            this.printerView = new JCheckBox();
            this.printerView.setSelected(true);
            this.gridbag = new GridBagLayout();
            this.gbc = new GridBagConstraints();
            this.setLayout(this.gridbag);
            this.gbc.gridy = 0;
            this.gbc.gridx = -1;
            this.gbc.anchor = 18;
            this.gbc.insets = new Insets(5, 0, 5, 0);
            this.gbc.fill = 0;
            this.addGb(new JLabel(Strings.S.get("labelCircuits") + " "));
            this.gbc.fill = 2;
            this.addGb(new JScrollPane(list));
            this.gbc.fill = 0;
            ++this.gbc.gridy;
            this.addGb(new JLabel(Strings.S.get("labelImageFormat") + " "));
            Box formatsPanel = new Box(1);
            formatsPanel.add(this.formatPng);
            formatsPanel.add(this.formatGif);
            formatsPanel.add(this.formatJpg);
            formatsPanel.add(this.formatTikZ);
            formatsPanel.add(this.formatSvg);
            this.addGb(formatsPanel);
            ++this.gbc.gridy;
            this.addGb(new JLabel(Strings.S.get("labelScale") + " "));
            this.addGb(this.slider);
            this.addGb(this.curScale);
            ++this.gbc.gridy;
            this.addGb(new JLabel(Strings.S.get("labelPrinterView") + " "));
            this.addGb(this.printerView);
        }

        private void addGb(JComponent comp) {
            this.gridbag.setConstraints(comp, this.gbc);
            this.add(comp);
        }

        int getImageFormat() {
            if (this.formatGif.isSelected()) {
                return 0;
            }
            if (this.formatJpg.isSelected()) {
                return 2;
            }
            if (this.formatTikZ.isSelected()) {
                return 3;
            }
            if (this.formatSvg.isSelected()) {
                return 4;
            }
            return 1;
        }

        boolean getPrinterView() {
            return this.printerView.isSelected();
        }

        double getScale() {
            return Math.pow(2.0, (double)this.slider.getValue() / 6.0);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double scale = this.getScale();
            this.curScale.setText((int)Math.round(100.0 * scale) + "%");
            if (this.curJim != null) {
                this.curScale.setPreferredSize(this.curJim);
            }
            if (e == null) {
                return;
            }
            if (e.getSource().equals(this.formatTikZ) || e.getSource().equals(this.formatSvg)) {
                if (this.formatTikZ.isSelected() || this.formatSvg.isSelected()) {
                    this.curScale.setEnabled(false);
                    this.slider.setEnabled(false);
                    this.slider.setValue(0);
                    this.curScale.setText("100%");
                    if (this.curJim != null) {
                        this.curScale.setPreferredSize(this.curJim);
                    }
                } else {
                    this.curScale.setEnabled(true);
                    this.slider.setEnabled(true);
                }
            }
        }
    }

    private static class ExportThread
    extends UniquelyNamedThread {
        final Frame frame;
        final Canvas canvas;
        final File dest;
        final ImageFileFilter filter;
        final List<Circuit> circuits;
        final double scale;
        final boolean printerView;
        final ProgressMonitor monitor;

        ExportThread(Frame frame, Canvas canvas, File dest, ImageFileFilter f, List<Circuit> circuits, double scale, boolean printerView, ProgressMonitor monitor) {
            super("ExportThread");
            this.frame = frame;
            this.canvas = canvas;
            this.dest = dest;
            this.filter = f;
            this.circuits = circuits;
            this.scale = scale;
            this.printerView = printerView;
            this.monitor = monitor;
        }

        private void export(Circuit circuit) {
            File where;
            Graphics g;
            Graphics base;
            Bounds bds = circuit.getBounds(this.canvas.getGraphics()).expand(5);
            int width = (int)Math.round((double)bds.getWidth() * this.scale);
            int height = (int)Math.round((double)bds.getHeight() * this.scale);
            BufferedImage img = new BufferedImage(width, height, 1);
            if (this.filter.type == 3 || this.filter.type == 4) {
                base = new TikZWriter();
                g = base.create();
            } else {
                base = img.getGraphics();
                g = base.create();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.black);
            }
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.scale(this.scale, this.scale);
                g.translate(-bds.getX(), -bds.getY());
            } else {
                OptionPane.showMessageDialog(this.frame, Strings.S.get("couldNotCreateImage"));
                this.monitor.close();
            }
            CircuitState circuitState = this.canvas.getProject().getCircuitState(circuit);
            ComponentDrawContext context = new ComponentDrawContext(this.canvas, circuit, circuitState, base, g, this.printerView);
            circuit.draw(context, null);
            if (this.dest.isDirectory()) {
                where = new File(this.dest, circuit.getName() + this.filter.extensions[0]);
            } else if (this.filter.accept(this.dest)) {
                where = this.dest;
            } else {
                String newName = this.dest.getName() + this.filter.extensions[0];
                where = new File(this.dest.getParentFile(), newName);
            }
            try {
                switch (this.filter.type) {
                    case 0: {
                        GifEncoder.toFile((Image)img, where, this.monitor);
                        break;
                    }
                    case 1: {
                        ImageIO.write((RenderedImage)img, "PNG", where);
                        break;
                    }
                    case 2: {
                        ImageIO.write((RenderedImage)img, "JPEG", where);
                        break;
                    }
                    case 3: {
                        ((TikZWriter)g).writeFile(where);
                        break;
                    }
                    case 4: {
                        ((TikZWriter)g).writeSvg(width, height, where);
                    }
                }
            }
            catch (Exception e) {
                OptionPane.showMessageDialog(this.frame, Strings.S.get("couldNotCreateFile"));
                e.printStackTrace();
                this.monitor.close();
                return;
            }
            g.dispose();
            this.monitor.close();
        }

        @Override
        public void run() {
            for (Circuit circ : this.circuits) {
                this.export(circ);
            }
        }
    }
}

