/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.Menu;
import com.cburch.logisim.gui.menu.MenuItemImpl;
import com.cburch.logisim.gui.menu.OpenRecent;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.util.MacCompatibility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class MenuFile
extends Menu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final LogisimMenuBar menubar;
    private final JMenuItem newi = new JMenuItem();
    private final JMenuItem merge = new JMenuItem();
    private final JMenuItem open = new JMenuItem();
    private final OpenRecent openRecent;
    private final JMenuItem close = new JMenuItem();
    private final JMenuItem save = new JMenuItem();
    private final JMenuItem saveAs = new JMenuItem();
    private final JMenuItem exportProj = new JMenuItem();
    private final JMenuItem extractRunProj = new JMenuItem();
    private final MenuItemImpl print = new MenuItemImpl(this, LogisimMenuBar.PRINT);
    private final MenuItemImpl exportImage = new MenuItemImpl(this, LogisimMenuBar.EXPORT_IMAGE);
    private final JMenuItem prefs = new JMenuItem();
    private final JMenuItem quit = new JMenuItem();

    public MenuFile(LogisimMenuBar menubar) {
        this.menubar = menubar;
        this.openRecent = new OpenRecent(menubar);
        int menuMask = this.getToolkit().getMenuShortcutKeyMaskEx();
        this.newi.setAccelerator(KeyStroke.getKeyStroke(78, menuMask));
        this.merge.setAccelerator(KeyStroke.getKeyStroke(77, menuMask));
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, menuMask));
        this.close.setAccelerator(KeyStroke.getKeyStroke(87, menuMask | 0x40));
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, menuMask));
        this.saveAs.setAccelerator(KeyStroke.getKeyStroke(83, menuMask | 0x40));
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, menuMask));
        this.exportProj.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_FILE_EXPORT).getWithMask(0));
        this.print.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_FILE_PRINT).getWithMask(0));
        AppPreferences.gui_sync_objects.add(this);
        this.add(this.newi);
        this.add(this.merge);
        this.add(this.open);
        this.add(this.openRecent);
        this.addSeparator();
        this.add(this.close);
        this.add(this.save);
        this.add(this.saveAs);
        this.addSeparator();
        this.add(this.extractRunProj);
        this.add(this.exportProj);
        this.addSeparator();
        this.add(this.exportImage);
        this.add(this.print);
        if (!MacCompatibility.isPreferencesAutomaticallyPresent()) {
            this.addSeparator();
            this.add(this.prefs);
        }
        if (!MacCompatibility.isQuitAutomaticallyPresent()) {
            this.addSeparator();
            this.add(this.quit);
        }
        Project proj = menubar.getSaveProject();
        this.newi.addActionListener(this);
        this.open.addActionListener(this);
        if (proj == null) {
            this.merge.setEnabled(false);
            this.close.setEnabled(false);
            this.save.setEnabled(false);
            this.saveAs.setEnabled(false);
            this.exportProj.setEnabled(false);
            this.extractRunProj.setEnabled(false);
        } else {
            this.merge.addActionListener(this);
            this.close.addActionListener(this);
            this.save.addActionListener(this);
            this.saveAs.addActionListener(this);
            this.exportProj.addActionListener(this);
            this.extractRunProj.addActionListener(this);
        }
        menubar.registerItem(LogisimMenuBar.EXPORT_IMAGE, this.exportImage);
        menubar.registerItem(LogisimMenuBar.PRINT, this.print);
        this.prefs.addActionListener(this);
        this.quit.addActionListener(this);
    }

    @Override
    public void hotkeyUpdate() {
        this.exportProj.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_FILE_EXPORT).getWithMask(0));
        this.print.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_FILE_PRINT).getWithMask(0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        Project proj = this.menubar.getSaveProject();
        Project baseProj = this.menubar.getBaseProject();
        if (src == this.newi) {
            ProjectActions.doNew(baseProj);
        } else if (src == this.merge) {
            ProjectActions.doMerge(baseProj == null ? null : baseProj.getFrame().getCanvas(), baseProj);
        } else if (src == this.open) {
            Project newProj = ProjectActions.doOpen(baseProj == null ? null : baseProj.getFrame().getCanvas(), baseProj);
            if (newProj != null && proj != null && !proj.isFileDirty() && proj.getLogisimFile().getLoader().getMainFile() == null) {
                proj.getFrame().dispose();
            }
        } else if (src == this.close && proj != null) {
            int result = 0;
            Frame frame = proj.getFrame();
            if (proj.isFileDirty()) {
                String message = "What should happen to your unsaved changes to " + proj.getLogisimFile().getName();
                Object[] options = new String[]{"Save", "Discard", "Cancel"};
                result = OptionPane.showOptionDialog(OptionPane.getFrameForComponent(this), message, "Confirm Close", 0, 3, null, options, options[0]);
                if (result == 0) {
                    ProjectActions.doSave(proj);
                }
            }
            if (result != 2) {
                List<Project> projectList = Projects.getOpenProjects();
                if (projectList.size() == 1) {
                    ProjectActions.doNew(proj);
                }
                frame.dispose();
            }
        } else if (src == this.prefs) {
            PreferencesFrame.showPreferences();
        } else if (src == this.quit) {
            ProjectActions.doQuit();
        } else if (proj != null) {
            if (src == this.save) {
                ProjectActions.doSave(proj);
            } else if (src == this.saveAs) {
                ProjectActions.doSaveAs(proj);
            } else if (src == this.exportProj) {
                ProjectActions.doExportProject(proj);
            } else if (src == this.extractRunProj) {
                ProjectActions.doExtractAndRunProject(proj);
            }
        }
    }

    @Override
    protected void computeEnabled() {
        this.setEnabled(true);
        this.menubar.fireEnableChanged();
    }

    public void localeChanged() {
        this.setText(Strings.S.get("fileMenu"));
        this.newi.setText(Strings.S.get("fileNewItem"));
        this.merge.setText(Strings.S.get("fileMergeItem"));
        this.open.setText(Strings.S.get("fileOpenItem"));
        this.openRecent.localeChanged();
        this.close.setText(Strings.S.get("fileCloseItem"));
        this.save.setText(Strings.S.get("fileSaveItem"));
        this.saveAs.setText(Strings.S.get("fileSaveAsItem"));
        this.exportProj.setText(Strings.S.get("fileExportProject"));
        this.extractRunProj.setText(Strings.S.get("fileExtractRunProject"));
        this.exportImage.setText(Strings.S.get("fileExportImageItem"));
        this.print.setText(Strings.S.get("filePrintItem"));
        this.prefs.setText(Strings.S.get("filePreferencesItem"));
        this.quit.setText(Strings.S.get("fileQuitItem"));
    }
}

