/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.LineBuffer;

public class AdderHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String EXTENDED_BITS_STRING = "extendedBits";
    private static final int EXTENDED_BITS_ID = -2;

    public AdderHdlGeneratorFactory() {
        this.myParametersList.add(EXTENDED_BITS_STRING, -2, 2, 1).addBusOnly(NR_OF_BITS_STRING, -1);
        this.myWires.addWire("s_extendedDataA", -2).addWire("s_extendedDataB", -2).addWire("s_sumResult", -2);
        this.myPorts.add("input", "dataA", -1, 0, StdAttr.WIDTH).add("input", "dataB", -1, 1, StdAttr.WIDTH).add("input", "carryIn", 1, 3).add("output", "result", -1, 2, StdAttr.WIDTH).add("output", "carryOut", 1, 4);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        if (Hdl.isVhdl()) {
            contents.empty().add("s_extendedDataA <= \"0\"&dataA;\ns_extendedDataB <= \"0\"&dataB;\ns_sumResult     <= std_logic_vector(unsigned(s_extendedDataA) +\n                                     unsigned(s_extendedDataB) +\n                                     (\"\"&carryIn));\n");
            if (nrOfBits == 1) {
                contents.add("result   <= s_sumResult(0);");
            } else {
                contents.add("result   <= s_sumResult( ({{1}}-1) DOWNTO 0 );", NR_OF_BITS_STRING);
            }
            contents.add("carryOut <= s_sumResult({{1}}-1);", EXTENDED_BITS_STRING);
        } else {
            contents.add("assign   {carryOut, result} = dataA + dataB + carryIn;");
        }
        return contents.empty();
    }
}

