/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitException;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.gui.main.ToolAttributeAction;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Dependencies;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.gates.GateKeyboardModifier;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import com.cburch.logisim.tools.FactoryAttributes;
import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.MatrixPlacerDialog;
import com.cburch.logisim.tools.MatrixPlacerInfo;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.key.KeyConfigurationEvent;
import com.cburch.logisim.tools.key.KeyConfigurationResult;
import com.cburch.logisim.tools.key.KeyConfigurator;
import com.cburch.logisim.util.AutoLabel;
import com.cburch.logisim.util.SyntaxChecker;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;

public class AddTool
extends Tool
implements Transferable,
PropertyChangeListener {
    private static final int INVALID_COORD = Integer.MIN_VALUE;
    private static final int SHOW_NONE = 0;
    private static final int SHOW_GHOST = 1;
    private static final int SHOW_ADD = 2;
    private static final int SHOW_ADD_NO = 3;
    private static final Cursor cursor = Cursor.getPredefinedCursor(1);
    private Class<? extends Library> descriptionBase;
    private final FactoryDescription description;
    private boolean sourceLoadAttempted;
    private ComponentFactory factory;
    private final AttributeSet attrs;
    private Bounds bounds;
    private boolean shouldSnap;
    private int lastX = Integer.MIN_VALUE;
    private int lastY = Integer.MIN_VALUE;
    private int state = 1;
    private Action lastAddition;
    private boolean keyHandlerTried;
    private boolean matrixPlace = false;
    private KeyConfigurator keyHandler;
    private final AutoLabel autoLabeler = new AutoLabel();
    public static final DataFlavor dataFlavor;
    public static final DataFlavor[] dataFlavors;

    private AddTool(AddTool base) {
        this.descriptionBase = base.descriptionBase;
        this.description = base.description;
        this.sourceLoadAttempted = base.sourceLoadAttempted;
        this.factory = base.factory;
        this.bounds = base.bounds;
        this.shouldSnap = base.shouldSnap;
        this.attrs = (AttributeSet)base.attrs.clone();
        this.attrs.addAttributeListener(new MyAttributeListener());
        if (this.attrs.containsAttribute(StdAttr.APPEARANCE)) {
            AppPreferences.DefaultAppearance.addPropertyChangeListener(this);
        }
        if (this.attrs.containsAttribute(ProbeAttributes.PROBEAPPEARANCE)) {
            AppPreferences.NEW_INPUT_OUTPUT_SHAPES.addPropertyChangeListener(this);
        }
    }

    public AddTool(Class<? extends Library> base, FactoryDescription description) {
        this.descriptionBase = base;
        this.description = description;
        this.sourceLoadAttempted = false;
        this.shouldSnap = true;
        this.attrs = new FactoryAttributes(base, description);
        this.attrs.addAttributeListener(new MyAttributeListener());
        this.keyHandlerTried = false;
        if (this.attrs.containsAttribute(StdAttr.APPEARANCE)) {
            AppPreferences.DefaultAppearance.addPropertyChangeListener(this);
        }
        if (this.attrs.containsAttribute(ProbeAttributes.PROBEAPPEARANCE)) {
            AppPreferences.NEW_INPUT_OUTPUT_SHAPES.addPropertyChangeListener(this);
        }
    }

    public AddTool(ComponentFactory source) {
        this.description = null;
        this.sourceLoadAttempted = true;
        this.factory = source;
        this.bounds = null;
        this.attrs = new FactoryAttributes(source);
        this.attrs.addAttributeListener(new MyAttributeListener());
        Boolean value = (Boolean)source.getFeature(ComponentFactory.SHOULD_SNAP, this.attrs);
        boolean bl = this.shouldSnap = value == null || value != false;
        if (this.attrs.containsAttribute(StdAttr.APPEARANCE)) {
            AppPreferences.DefaultAppearance.addPropertyChangeListener(this);
        }
        if (this.attrs.containsAttribute(ProbeAttributes.PROBEAPPEARANCE)) {
            AppPreferences.NEW_INPUT_OUTPUT_SHAPES.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (AppPreferences.DefaultAppearance.isSource(evt)) {
            this.attrs.setValue(StdAttr.APPEARANCE, AppPreferences.getDefaultAppearance());
        } else if (AppPreferences.NEW_INPUT_OUTPUT_SHAPES.isSource(evt)) {
            this.attrs.setValue(ProbeAttributes.PROBEAPPEARANCE, ProbeAttributes.getDefaultProbeAppearance());
        }
    }

    @Override
    public Tool cloneTool() {
        return new AddTool(this);
    }

    @Override
    public void deselect(Canvas canvas) {
        this.setState(canvas, 1);
        this.moveTo(canvas, canvas.getGraphics(), Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.bounds = null;
        this.lastAddition = null;
        this.matrixPlace = false;
    }

    private Tool determineNext(Project proj) {
        String afterAdd = AppPreferences.ADD_AFTER.get();
        if (afterAdd.equals("unchanged")) {
            return null;
        }
        Library base = proj.getLogisimFile().getLibrary("Base");
        if (base == null) {
            return null;
        }
        return base.getTool("Edit Tool");
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        int x = this.lastX;
        int y = this.lastY;
        if (x == Integer.MIN_VALUE || y == Integer.MIN_VALUE) {
            return;
        }
        ComponentFactory source = this.getFactory();
        if (source == null) {
            return;
        }
        AttributeSet base = this.getBaseAttributes();
        Bounds bds = source.getOffsetBounds(base);
        if (this.state == 1) {
            Color drawColor = this.autoLabeler.isActive(canvas.getCircuit()) ? Color.MAGENTA : new Color(AppPreferences.COMPONENT_GHOST_COLOR.get());
            source.drawGhost(context, drawColor, x, y, this.getBaseAttributes());
            if (this.matrixPlace) {
                source.drawGhost(context, drawColor, x + bds.getWidth() + 3, y, this.getBaseAttributes());
                source.drawGhost(context, drawColor, x, y + bds.getHeight() + 3, this.getBaseAttributes());
                source.drawGhost(context, drawColor, x + bds.getWidth() + 3, y + bds.getHeight() + 3, this.getBaseAttributes());
            }
        } else if (this.state == 2) {
            Color drawColor = this.autoLabeler.isActive(canvas.getCircuit()) ? Color.BLUE : Color.BLACK;
            source.drawGhost(context, drawColor, x, y, this.getBaseAttributes());
            if (this.matrixPlace) {
                source.drawGhost(context, drawColor, x + bds.getWidth() + 3, y, this.getBaseAttributes());
                source.drawGhost(context, drawColor, x, y + bds.getHeight() + 3, this.getBaseAttributes());
                source.drawGhost(context, drawColor, x + bds.getWidth() + 3, y + bds.getHeight() + 3, this.getBaseAttributes());
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof AddTool)) {
            return false;
        }
        AddTool o = (AddTool)other;
        if (this.description != null) {
            return this.descriptionBase == o.descriptionBase && this.description.equals(o.description);
        }
        return this.factory.equals(o.factory);
    }

    private void expose(java.awt.Component c, int x, int y) {
        Bounds bds = this.getBounds();
        c.repaint(x + bds.getX(), y + bds.getY(), bds.getWidth(), bds.getHeight());
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    private AttributeSet getBaseAttributes() {
        AttributeSet ret = this.attrs;
        if (ret instanceof FactoryAttributes) {
            ret = ((FactoryAttributes)ret).getBase();
        }
        return ret;
    }

    private Bounds getBounds() {
        Bounds ret = this.bounds;
        if (ret == null) {
            ComponentFactory source = this.getFactory();
            if (source == null) {
                ret = Bounds.EMPTY_BOUNDS;
            } else {
                AttributeSet base = this.getBaseAttributes();
                Bounds bds = source.getOffsetBounds(base);
                Bounds mbds = Bounds.create(bds.getX(), bds.getY(), bds.getWidth() * 2, bds.getHeight() * 2);
                ret = mbds.expand(5);
            }
            this.bounds = ret;
        }
        return ret;
    }

    @Override
    public Cursor getCursor() {
        return cursor;
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        return this.getFactory().getDefaultAttributeValue(attr, ver);
    }

    @Override
    public String getDescription() {
        ComponentFactory source;
        FactoryDescription desc = this.description;
        String ret = desc != null ? desc.getToolTip() : ((source = this.getFactory()) != null ? (String)source.getFeature(ComponentFactory.TOOL_TIP, this.getAttributeSet()) : null);
        if (ret == null) {
            ret = Strings.S.get("addToolText", this.getDisplayName());
        }
        return ret;
    }

    @Override
    public String getDisplayName() {
        FactoryDescription desc = this.description;
        return desc == null ? this.factory.getDisplayName() : desc.getDisplayName();
    }

    public ComponentFactory getFactory() {
        ComponentFactory ret = this.factory;
        if (ret == null && !this.sourceLoadAttempted) {
            ret = this.description.getFactory(this.descriptionBase);
            if (ret != null) {
                AttributeSet base = this.getBaseAttributes();
                Boolean value = (Boolean)ret.getFeature(ComponentFactory.SHOULD_SNAP, base);
                this.shouldSnap = value == null || value != false;
            }
            this.factory = ret;
            this.sourceLoadAttempted = true;
        }
        return ret;
    }

    public ComponentFactory getFactory(boolean forceLoad) {
        return forceLoad ? this.getFactory() : this.factory;
    }

    @Override
    public String getName() {
        FactoryDescription desc = this.description;
        return desc == null ? this.factory.getName() : desc.getName();
    }

    public int hashCode() {
        FactoryDescription desc = this.description;
        return desc != null ? desc.hashCode() : this.factory.hashCode();
    }

    @Override
    public boolean isAllDefaultValues(AttributeSet attributeSet, LogisimVersion ver) {
        FactoryAttributes factAttrs;
        return this.attrs == attributeSet && attributeSet instanceof FactoryAttributes && !(factAttrs = (FactoryAttributes)attributeSet).isFactoryInstantiated();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent event) {
        this.processKeyEvent(canvas, event, 0);
        if (!event.isConsumed()) {
            int keyEventB = event.getKeyCode();
            String component = this.getFactory().getDisplayName();
            if (!GateKeyboardModifier.tookKeyboardStrokes(keyEventB, event.getModifiersEx(), null, this.attrs, canvas, null, false)) {
                if (this.autoLabeler.labelKeyboardHandler(keyEventB, event.getModifiersEx(), this.getAttributeSet(), component, null, this.getFactory(), canvas.getCircuit(), null, false)) {
                    canvas.repaint();
                } else {
                    int code = event.getKeyCode();
                    int modifier = event.getModifiersEx();
                    if (code == 88) {
                        this.matrixPlace = !this.matrixPlace;
                        canvas.repaint();
                    } else if (((PrefMonitorKeyStroke)AppPreferences.HOTKEY_DIR_NORTH).compare(code, modifier)) {
                        this.setFacing(canvas, Direction.NORTH);
                    } else if (((PrefMonitorKeyStroke)AppPreferences.HOTKEY_DIR_SOUTH).compare(code, modifier)) {
                        this.setFacing(canvas, Direction.SOUTH);
                    } else if (((PrefMonitorKeyStroke)AppPreferences.HOTKEY_DIR_WEST).compare(code, modifier)) {
                        this.setFacing(canvas, Direction.WEST);
                    } else if (((PrefMonitorKeyStroke)AppPreferences.HOTKEY_DIR_EAST).compare(code, modifier)) {
                        this.setFacing(canvas, Direction.EAST);
                    } else if (((PrefMonitorKeyStroke)AppPreferences.HOTKEY_ADD_TOOL_ROTATE).compare(code, modifier)) {
                        Direction current = this.getFacing();
                        if (current == Direction.NORTH) {
                            this.setFacing(canvas, Direction.EAST);
                        } else if (current == Direction.EAST) {
                            this.setFacing(canvas, Direction.SOUTH);
                        } else if (current == Direction.SOUTH) {
                            this.setFacing(canvas, Direction.WEST);
                        } else {
                            this.setFacing(canvas, Direction.NORTH);
                        }
                    } else if (code == 27) {
                        Tool next;
                        Project proj = canvas.getProject();
                        Library base = proj.getLogisimFile().getLibrary("Base");
                        Tool tool = next = base == null ? null : base.getTool("Edit Tool");
                        if (next != null) {
                            proj.setTool(next);
                            Action act = SelectionActions.dropAll(canvas.getSelection());
                            if (act != null) {
                                proj.doAction(act);
                            }
                        }
                    } else if (code == 8 && this.lastAddition != null && canvas.getProject().getLastAction() == this.lastAddition) {
                        canvas.getProject().undoAction();
                        this.lastAddition = null;
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent event) {
        this.processKeyEvent(canvas, event, 1);
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent event) {
        this.processKeyEvent(canvas, event, 2);
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics gfx, MouseEvent event) {
        if (this.state != 0) {
            if (this.shouldSnap) {
                Canvas.snapToGrid(event);
            }
            this.moveTo(canvas, gfx, event.getX(), event.getY());
        }
    }

    @Override
    public void mouseEntered(Canvas canvas, Graphics gfx, MouseEvent event) {
        if (this.state == 1 || this.state == 0) {
            this.setState(canvas, 1);
            canvas.requestFocusInWindow();
        } else if (this.state == 3) {
            this.setState(canvas, 2);
            canvas.requestFocusInWindow();
        }
    }

    @Override
    public void mouseExited(Canvas canvas, Graphics gfx, MouseEvent event) {
        if (this.state == 1) {
            this.moveTo(canvas, canvas.getGraphics(), Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.setState(canvas, 0);
        } else if (this.state == 2) {
            this.moveTo(canvas, canvas.getGraphics(), Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.setState(canvas, 3);
        }
    }

    @Override
    public void mouseMoved(Canvas canvas, Graphics gfx, MouseEvent event) {
        if (this.state != 0) {
            if (this.shouldSnap) {
                Canvas.snapToGrid(event);
            }
            this.moveTo(canvas, gfx, event.getX(), event.getY());
        }
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        Circuit circ = canvas.getCircuit();
        if (!canvas.getProject().getLogisimFile().contains(circ)) {
            canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
            return;
        }
        ComponentFactory componentFactory = this.factory;
        if (componentFactory instanceof SubcircuitFactory) {
            SubcircuitFactory circFact = (SubcircuitFactory)componentFactory;
            Dependencies depends = canvas.getProject().getDependencies();
            if (!depends.canAdd(circ, circFact.getSubcircuit())) {
                canvas.setErrorMessage(Strings.S.getter("circularError"));
                return;
            }
        }
        if (this.shouldSnap) {
            Canvas.snapToGrid(e);
        }
        this.moveTo(canvas, g, e.getX(), e.getY());
        this.setState(canvas, 2);
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics gfx, MouseEvent event) {
        ArrayList<Component> added = new ArrayList<Component>();
        if (this.state == 2) {
            Circuit circ = canvas.getCircuit();
            if (!canvas.getProject().getLogisimFile().contains(circ)) {
                return;
            }
            if (this.shouldSnap) {
                Canvas.snapToGrid(event);
            }
            this.moveTo(canvas, gfx, event.getX(), event.getY());
            ComponentFactory source = this.getFactory();
            if (source == null) {
                return;
            }
            String label = null;
            if (this.attrs.containsAttribute(StdAttr.LABEL)) {
                label = this.attrs.getValue(StdAttr.LABEL);
                if (this.autoLabeler.isActive(canvas.getCircuit()) && (label == null || label.isEmpty())) {
                    label = this.autoLabeler.getCurrent(canvas.getCircuit(), source);
                    if (this.autoLabeler.hasNext(canvas.getCircuit())) {
                        this.autoLabeler.getNext(canvas.getCircuit(), source);
                    } else {
                        this.autoLabeler.stop(canvas.getCircuit());
                    }
                }
                if (!this.autoLabeler.isActive(canvas.getCircuit())) {
                    this.autoLabeler.setLabel("", canvas.getCircuit(), source);
                }
            }
            MatrixPlacerInfo matrix = new MatrixPlacerInfo(label);
            if (this.matrixPlace) {
                AttributeSet base = this.getBaseAttributes();
                Bounds bds = source.getOffsetBounds(base).expand(5);
                matrix.setBounds(bds);
                MatrixPlacerDialog dialog = new MatrixPlacerDialog(matrix, source.getName(), this.autoLabeler.isActive(canvas.getCircuit()));
                boolean okay = false;
                while (!okay) {
                    if (!dialog.execute()) {
                        return;
                    }
                    if (SyntaxChecker.isVariableNameAcceptable(matrix.getLabel(), true)) {
                        this.autoLabeler.setLabel(matrix.getLabel(), canvas.getCircuit(), source);
                        okay = this.autoLabeler.correctMatrixBaseLabel(canvas.getCircuit(), source, matrix.getLabel(), matrix.getCopiesCountX(), matrix.getCopiesCountY());
                        this.autoLabeler.setLabel(label, canvas.getCircuit(), source);
                        if (okay) continue;
                        OptionPane.showMessageDialog(null, Strings.S.get("MatrixPlacerException"), "Matrixplacer", 0);
                        matrix.undoLabel();
                        continue;
                    }
                    matrix.undoLabel();
                }
            }
            try {
                CircuitMutation mutation = new CircuitMutation(circ);
                for (int x = 0; x < matrix.getCopiesCountX(); ++x) {
                    for (int y = 0; y < matrix.getCopiesCountY(); ++y) {
                        Component comp;
                        Location loc = Location.create(event.getX() + matrix.getDeltaX() * x, event.getY() + matrix.getDeltaY() * y, true);
                        AttributeSet attrsCopy = (AttributeSet)this.attrs.clone();
                        if (matrix.getLabel() != null) {
                            if (this.matrixPlace) {
                                attrsCopy.setValue(StdAttr.LABEL, this.autoLabeler.getMatrixLabel(canvas.getCircuit(), source, matrix.getLabel(), x, y));
                            } else {
                                attrsCopy.setValue(StdAttr.LABEL, matrix.getLabel());
                            }
                        }
                        if (circ.hasConflict(comp = source.createComponent(loc, attrsCopy))) {
                            canvas.setErrorMessage(Strings.S.getter("exclusiveError"));
                            return;
                        }
                        Bounds bds = comp.getBounds(gfx);
                        if (bds.getX() < 0 || bds.getY() < 0) {
                            canvas.setErrorMessage(Strings.S.getter("negativeCoordError"));
                            return;
                        }
                        mutation.add(comp);
                        added.add(comp);
                    }
                }
                Action action = mutation.toAction(Strings.S.getter("addComponentAction", this.factory.getDisplayGetter()));
                canvas.getProject().doAction(action);
                this.lastAddition = action;
                canvas.repaint();
            }
            catch (CircuitException ex) {
                OptionPane.showMessageDialog(canvas.getProject().getFrame(), ex.getMessage());
                added.clear();
            }
            this.setState(canvas, 1);
            this.matrixPlace = false;
        } else if (this.state == 3) {
            this.setState(canvas, 0);
        }
        Project proj = canvas.getProject();
        Tool next = this.determineNext(proj);
        if (next != null) {
            proj.setTool(next);
            Action act = SelectionActions.dropAll(canvas.getSelection());
            if (act != null) {
                proj.doAction(act);
            }
            if (!added.isEmpty()) {
                canvas.getSelection().addAll(added);
            }
        }
    }

    private synchronized void moveTo(Canvas canvas, Graphics g, int x, int y) {
        if (this.state != 0) {
            this.expose(canvas, this.lastX, this.lastY);
        }
        this.lastX = x;
        this.lastY = y;
        if (this.state != 0) {
            this.expose(canvas, this.lastX, this.lastY);
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        Icon icon;
        FactoryDescription desc = this.description;
        if (desc != null && !desc.isFactoryLoaded() && (icon = desc.getIcon()) != null) {
            icon.paintIcon(c.getDestination(), c.getGraphics(), x + 2, y + 2);
            return;
        }
        ComponentFactory source = this.getFactory();
        if (source != null) {
            AttributeSet base = this.getBaseAttributes();
            source.paintIcon(c, x, y, base);
        }
    }

    private void processKeyEvent(Canvas canvas, KeyEvent event, int type) {
        AttributeSet baseAttrs;
        KeyConfigurationEvent e;
        KeyConfigurationResult r;
        KeyConfigurator handler = this.keyHandler;
        if (!this.keyHandlerTried) {
            ComponentFactory source = this.getFactory();
            AttributeSet baseAttrs2 = this.getBaseAttributes();
            this.keyHandler = handler = (KeyConfigurator)source.getFeature(KeyConfigurator.class, baseAttrs2);
            this.keyHandlerTried = true;
        }
        if (handler != null && (r = handler.keyEventReceived(e = new KeyConfigurationEvent(type, baseAttrs = this.getBaseAttributes(), event, this))) != null) {
            Action act = ToolAttributeAction.create(r);
            canvas.getProject().doAction(act);
        }
    }

    @Override
    public void select(Canvas canvas) {
        this.setState(canvas, 1);
        this.bounds = null;
    }

    private void setFacing(Canvas canvas, Direction facing) {
        ComponentFactory source = this.getFactory();
        if (source == null) {
            return;
        }
        AttributeSet base = this.getBaseAttributes();
        Object feature = source.getFeature(ComponentFactory.FACING_ATTRIBUTE_KEY, base);
        Attribute attr = (Attribute)feature;
        if (attr != null) {
            Action act = ToolAttributeAction.create(this, attr, facing);
            canvas.getProject().doAction(act);
        }
    }

    private Direction getFacing() {
        ComponentFactory source = this.getFactory();
        if (source == null) {
            return Direction.NORTH;
        }
        AttributeSet base = this.getBaseAttributes();
        Object feature = source.getFeature(ComponentFactory.FACING_ATTRIBUTE_KEY, base);
        Attribute attr = (Attribute)feature;
        if (attr != null) {
            return (Direction)base.getValue(attr);
        }
        return Direction.NORTH;
    }

    private void setState(Canvas canvas, int value) {
        this.state = value == 1 ? (canvas.getProject().getLogisimFile().contains(canvas.getCircuit()) && AppPreferences.ADD_SHOW_GHOSTS.getBoolean() ? 1 : 0) : value;
    }

    @Override
    public boolean sharesSource(Tool other) {
        if (!(other instanceof AddTool)) {
            return false;
        }
        AddTool o = (AddTool)other;
        if (this.sourceLoadAttempted && o.sourceLoadAttempted) {
            return this.factory.equals(o.factory);
        }
        if (this.description == null) {
            return o.description == null;
        }
        return this.description.equals(o.description);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return dataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return dataFlavor.equals(flavor);
    }

    static {
        DataFlavor f = null;
        try {
            f = new DataFlavor(String.format("%s;class=\"%s\"", "application/x-java-jvm-local-objectref", AddTool.class.getName()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        dataFlavor = f;
        dataFlavors = new DataFlavor[]{dataFlavor};
    }

    private class MyAttributeListener
    implements AttributeListener {
        private MyAttributeListener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
            AddTool.this.bounds = null;
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            AddTool.this.bounds = null;
        }
    }
}

