/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.gui;

import com.cburch.logisim.proj.Project;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VhdlSimState
extends JPanel
implements VhdlSimulatorListener {
    private static final long serialVersionUID = 1L;
    final Ellipse2D.Double circle;
    Color color;
    private final int margin = 5;
    private final Project proj;

    public VhdlSimState(Project proj) {
        this.proj = proj;
        int radius = 15;
        this.circle = new Ellipse2D.Double(5.0, 5.0, radius, radius);
        this.setOpaque(false);
        this.color = Color.GRAY;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle bounds = this.circle.getBounds();
        return new Dimension(bounds.width + 10, bounds.height + 10);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        g2.fill(this.circle);
    }

    @Override
    public void stateChanged() {
        switch (this.proj.getVhdlSimulator().getState()) {
            case DISABLED: {
                this.color = Color.GRAY;
                break;
            }
            case ENABLED: {
                this.color = Color.RED;
                break;
            }
            case STARTING: {
                this.color = Color.ORANGE;
                break;
            }
            case RUNNING: {
                this.color = new Color(40, 180, 40);
            }
        }
        this.repaint();
    }
}

