/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.gui;

import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.canvas.CanvasTool;
import com.cburch.draw.gui.AttrTableSelectionModel;
import com.cburch.draw.gui.AttrTableToolModel;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.draw.tools.SelectTool;
import com.cburch.logisim.gui.generic.AttrTable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class AttrTableDrawManager
implements PropertyChangeListener {
    private final Canvas canvas;
    private final AttrTable table;
    private final AttrTableSelectionModel selectionModel;
    private final AttrTableToolModel toolModel;

    public AttrTableDrawManager(Canvas canvas, AttrTable table, DrawingAttributeSet attrs) {
        this.canvas = canvas;
        this.table = table;
        this.selectionModel = new AttrTableSelectionModel(canvas);
        this.toolModel = new AttrTableToolModel(attrs, null);
        canvas.addPropertyChangeListener("tool", this);
        this.updateToolAttributes();
    }

    public void attributesSelected() {
        this.updateToolAttributes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("tool")) {
            this.updateToolAttributes();
        }
    }

    private void updateToolAttributes() {
        CanvasTool tool = this.canvas.getTool();
        if (tool instanceof SelectTool) {
            this.table.setAttrTableModel(this.selectionModel);
        } else if (tool instanceof AbstractTool) {
            AbstractTool absTool = (AbstractTool)tool;
            this.toolModel.setTool(absTool);
            this.table.setAttrTableModel(this.toolModel);
        } else {
            this.table.setAttrTableModel(null);
        }
    }
}

