/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class DrawShapeIcon
extends BaseIcon {
    public static final int RECTANGLE = 0;
    public static final int ROUNDED_RECTANGLE = 1;
    public static final int ELIPSE = 2;
    private static final int[] points = new int[]{3, 2, 8, 4, 14, 8};
    private final int shapeType;

    public DrawShapeIcon(int type) {
        this.shapeType = type;
    }

    @Override
    protected void paintIcon(Graphics2D gfx) {
        int state = 3;
        gfx.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        int x = this.scale(1);
        int y = this.scale(3);
        int width = this.scale(points[4]);
        int height = this.scale(points[5]);
        switch (this.shapeType) {
            case 0: {
                gfx.setColor(Color.BLUE.darker());
                gfx.drawRect(x, y, width, height);
                break;
            }
            case 1: {
                gfx.setColor(Color.RED.darker());
                gfx.drawRoundRect(x, y, width, height, y, y);
                break;
            }
            default: {
                gfx.setColor(Color.BLUE);
                gfx.drawOval(x, y, width, height);
            }
        }
        gfx.setColor(Color.GRAY);
        gfx.setStroke(new BasicStroke(AppPreferences.getScaled(1)));
        gfx.drawRect(0, y - x, y, y);
        gfx.drawRect(width - x, y + height - x, y, y);
    }
}

