/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangular;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.awt.Graphics;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Oval
extends Rectangular {
    public Oval(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    protected boolean contains(int x, int y, int w, int h, Location q) {
        int qy;
        double dy;
        int qx = q.getX();
        double dx = (double)qx - ((double)x + 0.5 * (double)w);
        double sum = dx * dx / (double)(w * w) + (dy = (double)(qy = q.getY()) - ((double)y + 0.5 * (double)h)) * dy / (double)(h * h);
        return sum <= 0.25;
    }

    @Override
    public void draw(Graphics g, int x, int y, int w, int h) {
        if (this.setForFill(g)) {
            g.fillOval(x, y, w, h);
        }
        if (this.setForStroke(g)) {
            g.drawOval(x, y, w, h);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.getPaintType());
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeOval");
    }

    @Override
    protected Location getRandomPoint(Bounds bds, Random rand) {
        if (this.getPaintType() != DrawAttr.PAINT_STROKE) {
            return super.getRandomPoint(bds, rand);
        }
        double rx = (double)this.getWidth() / 2.0;
        double ry = (double)this.getHeight() / 2.0;
        double u = Math.PI * 2 * rand.nextDouble();
        int x = (int)Math.round((double)this.getX() + rx + rx * Math.cos(u));
        int y = (int)Math.round((double)this.getY() + ry + ry * Math.sin(u));
        int d = this.getStrokeWidth();
        if (d > 1) {
            x += rand.nextInt(d) - d / 2;
            y += rand.nextInt(d) - d / 2;
        }
        return Location.create(x, y, false);
    }

    @Override
    public boolean matches(CanvasObject other) {
        return other instanceof Oval ? super.matches(other) : false;
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createOval(doc, this);
    }
}

