/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.shapes.Curve;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Line;
import com.cburch.draw.shapes.Oval;
import com.cburch.draw.shapes.Poly;
import com.cburch.draw.shapes.Rectangle;
import com.cburch.draw.shapes.RoundRectangle;
import com.cburch.draw.shapes.Text;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public final class SvgReader {
    private static final Pattern PATH_REGEX = Pattern.compile("[a-zA-Z]|[-\\d.]+");

    private SvgReader() {
    }

    private static AbstractCanvasObject createLine(Element elt) {
        int x0 = Integer.parseInt(elt.getAttribute("x1"));
        int y0 = Integer.parseInt(elt.getAttribute("y1"));
        int x1 = Integer.parseInt(elt.getAttribute("x2"));
        int y1 = Integer.parseInt(elt.getAttribute("y2"));
        return new Line(x0, y0, x1, y1);
    }

    private static AbstractCanvasObject createOval(Element elt) {
        double cx = Double.parseDouble(elt.getAttribute("cx"));
        double cy = Double.parseDouble(elt.getAttribute("cy"));
        double rx = Double.parseDouble(elt.getAttribute("rx"));
        double ry = Double.parseDouble(elt.getAttribute("ry"));
        int x = (int)Math.round(cx - rx);
        int y = (int)Math.round(cy - ry);
        int w = (int)Math.round(rx * 2.0);
        int h = (int)Math.round(ry * 2.0);
        return new Oval(x, y, w, h);
    }

    private static AbstractCanvasObject createPath(Element elt) {
        int typeError = -1;
        Matcher patt = PATH_REGEX.matcher(elt.getAttribute("d"));
        ArrayList<String> tokens = new ArrayList<String>();
        int type = -1;
        while (patt.find()) {
            String token = patt.group();
            tokens.add(token);
            if (!Character.isLetter(token.charAt(0))) continue;
            if ((type = (switch (token.charAt(0)) {
                case 'M' -> {
                    if (type == -1) {
                        yield 0;
                    }
                    yield -1;
                }
                case 'Q', 'q' -> {
                    if (type == 0) {
                        yield 1;
                    }
                    yield -1;
                }
                default -> -1;
            })) != -1) continue;
            String tokenStr = String.valueOf(token.charAt(0));
            String msg = String.format("Unrecognized path command '%s'", tokenStr);
            throw new NumberFormatException(msg);
        }
        if (type == 1) {
            if (tokens.size() == 8 && "M".equals(tokens.get(0)) && "Q".equalsIgnoreCase((String)tokens.get(3))) {
                int x0 = Integer.parseInt((String)tokens.get(1));
                int y0 = Integer.parseInt((String)tokens.get(2));
                int x1 = Integer.parseInt((String)tokens.get(4));
                int y1 = Integer.parseInt((String)tokens.get(5));
                int x2 = Integer.parseInt((String)tokens.get(6));
                int y2 = Integer.parseInt((String)tokens.get(7));
                if ("q".equals(tokens.get(3))) {
                    x1 += x0;
                    y1 += y0;
                    x2 += x0;
                    y2 += y0;
                }
                Location e0 = Location.create(x0, y0, false);
                Location e1 = Location.create(x2, y2, false);
                Location ct = Location.create(x1, y1, false);
                return new Curve(e0, e1, ct);
            }
            throw new NumberFormatException("Unexpected format for curve");
        }
        throw new NumberFormatException("Unrecognized path");
    }

    private static AbstractCanvasObject createPolygon(Element elt) {
        return new Poly(true, SvgReader.parsePoints(elt.getAttribute("points")));
    }

    private static AbstractCanvasObject createPolyline(Element elt) {
        return new Poly(false, SvgReader.parsePoints(elt.getAttribute("points")));
    }

    private static AbstractCanvasObject createRectangle(Element elt) {
        int x = Integer.parseInt(elt.getAttribute("x"));
        int y = Integer.parseInt(elt.getAttribute("y"));
        int w = Integer.parseInt(elt.getAttribute("width"));
        int h = Integer.parseInt(elt.getAttribute("height"));
        if (elt.hasAttribute("rx")) {
            RoundRectangle ret = new RoundRectangle(x, y, w, h);
            int rx = Integer.parseInt(elt.getAttribute("rx"));
            ret.setValue(DrawAttr.CORNER_RADIUS, rx);
            return ret;
        }
        return new Rectangle(x, y, w, h);
    }

    public static AbstractCanvasObject createShape(Element elt) {
        String opacity;
        String color;
        String name = elt.getTagName();
        AbstractCanvasObject ret = SvgReader.createShapeObject(elt, name);
        if (ret == null) {
            return null;
        }
        List<Attribute<?>> attrs = ret.getAttributes();
        if (attrs.contains(DrawAttr.PAINT_TYPE)) {
            String stroke = elt.getAttribute("stroke");
            String fill = elt.getAttribute("fill");
            if ("".equals(stroke) || "none".equals(stroke)) {
                ret.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_FILL);
            } else if ("none".equals(fill)) {
                ret.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_STROKE);
            } else {
                ret.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_STROKE_FILL);
            }
        }
        if ((attrs = ret.getAttributes()).contains(DrawAttr.STROKE_WIDTH) && elt.hasAttribute("stroke-width")) {
            Integer width = Integer.valueOf(elt.getAttribute("stroke-width"));
            ret.setValue(DrawAttr.STROKE_WIDTH, width);
        }
        if (attrs.contains(DrawAttr.STROKE_COLOR)) {
            color = elt.getAttribute("stroke");
            opacity = elt.getAttribute("stroke-opacity");
            if (!"none".equals(color)) {
                ret.setValue(DrawAttr.STROKE_COLOR, SvgReader.getColor(color, opacity));
            }
        }
        if (attrs.contains(DrawAttr.FILL_COLOR)) {
            color = elt.getAttribute("fill");
            if ("".equals(color)) {
                color = "#000000";
            }
            opacity = elt.getAttribute("fill-opacity");
            if (!"none".equals(color)) {
                ret.setValue(DrawAttr.FILL_COLOR, SvgReader.getColor(color, opacity));
            }
        }
        return ret;
    }

    private static AbstractCanvasObject createShapeObject(Element elt, String name) {
        return switch (name) {
            case "ellipse" -> SvgReader.createOval(elt);
            case "line" -> SvgReader.createLine(elt);
            case "path" -> SvgReader.createPath(elt);
            case "polyline" -> SvgReader.createPolyline(elt);
            case "polygon" -> SvgReader.createPolygon(elt);
            case "rect" -> SvgReader.createRectangle(elt);
            case "text" -> SvgReader.createText(elt);
            default -> null;
        };
    }

    private static AbstractCanvasObject createText(Element elt) {
        int x = Integer.parseInt(elt.getAttribute("x"));
        int y = Integer.parseInt(elt.getAttribute("y"));
        String text = elt.getTextContent();
        Text ret = new Text(x, y, text);
        String fontFamily = elt.getAttribute("font-family");
        String fontStyle = elt.getAttribute("font-style");
        String fontWeight = elt.getAttribute("font-weight");
        String fontSize = elt.getAttribute("font-size");
        int styleFlags = 0;
        if (SvgReader.isItalic(fontStyle)) {
            styleFlags |= 2;
        }
        if (SvgReader.isBold(fontWeight)) {
            styleFlags |= 1;
        }
        int size = Integer.parseInt(fontSize);
        ret.setValue(DrawAttr.FONT, new Font(fontFamily, styleFlags, size));
        String hAlignStr = elt.getAttribute("text-anchor");
        AttributeOption hAlign = "start".equals(hAlignStr) ? DrawAttr.HALIGN_LEFT : ("end".equals(hAlignStr) ? DrawAttr.HALIGN_RIGHT : DrawAttr.HALIGN_CENTER);
        ret.setValue(DrawAttr.HALIGNMENT, hAlign);
        String vAlignStr = elt.getAttribute("dominant-baseline");
        AttributeOption vAlign = SvgReader.getAlignment(vAlignStr);
        ret.setValue(DrawAttr.VALIGNMENT, vAlign);
        return ret;
    }

    private static AttributeOption getAlignment(String valignStr) {
        return switch (valignStr) {
            case "top" -> DrawAttr.VALIGN_TOP;
            case "bottom" -> DrawAttr.VALIGN_BOTTOM;
            case "alphabetic" -> DrawAttr.VALIGN_BASELINE;
            default -> DrawAttr.VALIGN_MIDDLE;
        };
    }

    public static Font getFontAttribute(Element elt, String prefix, String defaultFamily, int defaultSize) {
        String fontFamily = elt.getAttribute(prefix + "font-family");
        String fontStyle = elt.getAttribute(prefix + "font-style");
        String fontWeight = elt.getAttribute(prefix + "font-weight");
        String fontSize = elt.getAttribute(prefix + "font-size");
        if (StringUtil.isNullOrEmpty(fontFamily)) {
            fontFamily = defaultFamily;
        }
        if (StringUtil.isNullOrEmpty(fontStyle)) {
            fontStyle = "plain";
        }
        if (StringUtil.isNullOrEmpty(fontWeight)) {
            fontWeight = "plain";
        }
        int styleFlags = 0;
        if (SvgReader.isItalic(fontStyle)) {
            styleFlags |= 2;
        }
        if (SvgReader.isBold(fontWeight)) {
            styleFlags |= 1;
        }
        int size = defaultSize;
        if (StringUtil.isNotEmpty(fontSize)) {
            try {
                size = Integer.parseInt(fontSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Font(fontFamily, styleFlags, size);
    }

    public static Color getColor(String hue, String opacity) {
        int r = 0;
        int g = 0;
        int b = 0;
        int colorStrLen = 7;
        if (StringUtil.isNotEmpty(hue) && hue.length() == 7) {
            try {
                r = Integer.parseInt(hue.substring(1, 3), 16);
                g = Integer.parseInt(hue.substring(3, 5), 16);
                b = Integer.parseInt(hue.substring(5, 7), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int alpha = 255;
        if (StringUtil.isNotEmpty(opacity)) {
            double tmpOpacity;
            try {
                tmpOpacity = Double.parseDouble(opacity);
            }
            catch (NumberFormatException exception) {
                int commaIdx = opacity.lastIndexOf(44);
                if (commaIdx < 0) {
                    throw exception;
                }
                try {
                    String repl = opacity.substring(0, commaIdx) + "." + opacity.substring(commaIdx + 1);
                    tmpOpacity = Double.parseDouble(repl);
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            alpha = (int)Math.round(tmpOpacity * 255.0);
        }
        return new Color(r, g, b, alpha);
    }

    private static List<Location> parsePoints(String points) {
        Pattern patt = Pattern.compile("[ ,\n\r\t]+");
        String[] toks = patt.split(points);
        Location[] ret = new Location[toks.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int x = Integer.parseInt(toks[2 * i]);
            int y = Integer.parseInt(toks[2 * i + 1]);
            ret[i] = Location.create(x, y, false);
        }
        return UnmodifiableList.create(ret);
    }

    private static boolean isBold(String fontStyle) {
        return "bold".equals(fontStyle);
    }

    private static boolean isItalic(String fontStyle) {
        return "italic".equals(fontStyle);
    }
}

