/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.icons.DrawLineIcon;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.shapes.Poly;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;

public class LineTool
extends AbstractTool {
    private final DrawingAttributeSet attrs;
    private boolean active;
    private Location mouseStart;
    private Location mouseEnd;
    private int lastMouseX;
    private int lastMouseY;

    public LineTool(DrawingAttributeSet attrs) {
        this.attrs = attrs;
        this.active = false;
    }

    static Location snapTo4Cardinals(Location from, int mx, int my) {
        int px = from.getX();
        int py = from.getY();
        if (mx != px && my != py) {
            return Math.abs(my - py) < Math.abs(mx - px) ? Location.create(mx, py, false) : Location.create(px, my, false);
        }
        return Location.create(mx, my, false);
    }

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
        if (this.active) {
            Location start = this.mouseStart;
            Location end = this.mouseEnd;
            gfx.setColor(Color.GRAY);
            gfx.drawLine(start.getX(), start.getY(), end.getX(), end.getY());
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.ATTRS_STROKE;
    }

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public Icon getIcon() {
        return new DrawLineIcon();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        int code = e.getKeyCode();
        if (this.active && (code == 16 || code == 17)) {
            this.updateMouse(canvas, this.lastMouseX, this.lastMouseY, e.getModifiersEx());
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        this.keyPressed(canvas, e);
    }

    @Override
    public void mouseDragged(Canvas canvas, MouseEvent e) {
        this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        Location loc;
        int x = e.getX();
        int y = e.getY();
        int mods = e.getModifiersEx();
        if ((mods & 0x80) != 0) {
            x = canvas.snapX(x);
            y = canvas.snapY(y);
        }
        this.mouseStart = loc = Location.create(x, y, false);
        this.mouseEnd = loc;
        this.lastMouseX = loc.getX();
        this.lastMouseY = loc.getY();
        this.active = canvas.getModel() != null;
        this.repaintArea(canvas);
    }

    @Override
    public void mouseReleased(Canvas canvas, MouseEvent e) {
        if (this.active) {
            this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
            Location start = this.mouseStart;
            Location end = this.mouseEnd;
            Poly add = null;
            if (!start.equals(end)) {
                this.active = false;
                CanvasModel model = canvas.getModel();
                Location[] ends = new Location[]{start, end};
                List<Location> locs = UnmodifiableList.create(ends);
                add = this.attrs.applyTo(new Poly(false, locs));
                add.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_STROKE);
                canvas.doAction(new ModelAddAction(model, add));
                this.repaintArea(canvas);
            }
            canvas.toolGestureComplete(this, add);
        }
    }

    private void repaintArea(Canvas canvas) {
        canvas.repaint();
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        this.active = false;
        this.repaintArea(canvas);
    }

    private void updateMouse(Canvas canvas, int mx, int my, int mods) {
        if (this.active) {
            Location newEnd;
            boolean shift = (mods & 0x40) != 0;
            Location location = newEnd = shift ? LineUtil.snapTo8Cardinals(this.mouseStart, mx, my) : Location.create(mx, my, false);
            if ((mods & 0x80) != 0) {
                int x = newEnd.getX();
                int y = newEnd.getY();
                x = canvas.snapX(x);
                y = canvas.snapY(y);
                newEnd = Location.create(x, y, false);
            }
            if (!newEnd.equals(this.mouseEnd)) {
                this.mouseEnd = newEnd;
                this.repaintArea(canvas);
            }
        }
        this.lastMouseX = mx;
        this.lastMouseY = my;
    }
}

