/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;

public class Entry
implements Comparable<Entry>,
PreferenceChangeListener {
    public static final Entry OSCILLATE_ERROR = new Entry(-2, Strings.S.getter("oscillateError"));
    public static final Entry BUS_ERROR = new Entry(-1, Strings.S.getter("busError"));
    public static final Entry ZERO = new Entry(0, null);
    public static final Entry DONT_CARE = new Entry(1, null);
    public static final Entry ONE = new Entry(2, null);
    private final int sortOrder;
    private final StringGetter errorMessage;
    private final ArrayList<EntryChangedListener> listeners;

    public static Entry parse(String description) {
        if (AppPreferences.FALSE_CHAR.get().charAt(0) == description.charAt(0)) {
            return ZERO;
        }
        if (AppPreferences.TRUE_CHAR.get().charAt(0) == description.charAt(0)) {
            return ONE;
        }
        if (AppPreferences.DONTCARE_CHAR.get().charAt(0) == description.charAt(0)) {
            return DONT_CARE;
        }
        if (AppPreferences.ERROR_CHAR.get().charAt(0) == description.charAt(0)) {
            return BUS_ERROR;
        }
        return null;
    }

    private Entry(int sortOrder, StringGetter errorMessage) {
        this.sortOrder = sortOrder;
        this.errorMessage = errorMessage;
        this.listeners = new ArrayList();
        AppPreferences.getPrefs().addPreferenceChangeListener(this);
    }

    public String getDescription() {
        if (this == OSCILLATE_ERROR) {
            return "@";
        }
        if (this == BUS_ERROR) {
            return Character.toString(AppPreferences.ERROR_CHAR.get().charAt(0));
        }
        if (this == ZERO) {
            return Character.toString(AppPreferences.FALSE_CHAR.get().charAt(0));
        }
        if (this == DONT_CARE) {
            return Character.toString(AppPreferences.DONTCARE_CHAR.get().charAt(0));
        }
        if (this == ONE) {
            return Character.toString(AppPreferences.TRUE_CHAR.get().charAt(0));
        }
        return Character.toString(AppPreferences.UNKNOWN_CHAR.get().charAt(0));
    }

    public void addListener(EntryChangedListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(EntryChangedListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        for (EntryChangedListener l : this.listeners) {
            l.entryDesriptionChanged();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : this.errorMessage.toString();
    }

    public boolean isError() {
        return this.errorMessage != null;
    }

    public String toString() {
        return "Entry[" + this.getDescription() + "]";
    }

    public String toBitString() {
        return this == DONT_CARE || this == ZERO || this == ONE ? this.getDescription() : "?";
    }

    @Override
    public int compareTo(Entry other) {
        return this.sortOrder - other.sortOrder;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(AppPreferences.ERROR_CHAR.getIdentifier()) && this == BUS_ERROR || evt.getKey().equals(AppPreferences.FALSE_CHAR.getIdentifier()) && this == ZERO || evt.getKey().equals(AppPreferences.DONTCARE_CHAR.getIdentifier()) && this == DONT_CARE || evt.getKey().equals(AppPreferences.TRUE_CHAR.getIdentifier()) && this == ONE) {
            this.fireChange();
        }
    }

    public static interface EntryChangedListener {
        public void entryDesriptionChanged();
    }
}

