/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.Range;
import com.cburch.logisim.analyze.model.Assignments;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.ParserException;
import com.cburch.logisim.analyze.model.Var;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class Expression {
    public final List<Range> nots = new ArrayList<Range>();
    public final List<Range> subscripts = new ArrayList<Range>();
    public final List<Range> marks = new ArrayList<Range>();
    private Integer[] badness;
    private static final int BADNESS_NOT_BREAK = 15;
    private static final int BADNESS_PARENTESIS_BREAK = 10;
    private static final int BADNESS_CONST_BREAK = 100;
    private static final int BADNESS_VAR_BREAK = 200;
    private static final int BADNESS_AND_BREAK = 5;

    public boolean contains(final Op o) {
        return o == this.visit(new Visitor<Op>(){

            @Override
            public Op visitBinary(Expression a, Expression b, Op op) {
                return op == o || a.visit(this) == o || b.visit(this) == o ? o : null;
            }

            @Override
            public Op visitNot(Expression a) {
                return a.visit(this);
            }
        });
    }

    public boolean evaluate(final Assignments assignments) {
        int ret = this.visit(new IntVisitor(){

            @Override
            public int visitAnd(Expression a, Expression b) {
                return a.visit(this) & b.visit(this);
            }

            @Override
            public int visitConstant(int value) {
                return value;
            }

            @Override
            public int visitNot(Expression a) {
                return ~a.visit(this);
            }

            @Override
            public int visitOr(Expression a, Expression b) {
                return a.visit(this) | b.visit(this);
            }

            @Override
            public int visitVariable(String name) {
                return assignments.get(name) ? 1 : 0;
            }

            @Override
            public int visitXor(Expression a, Expression b) {
                return a.visit(this) ^ b.visit(this);
            }

            @Override
            public int visitXnor(Expression a, Expression b) {
                return ~(a.visit(this) ^ b.visit(this));
            }

            @Override
            public int visitEq(Expression a, Expression b) {
                return ~(a.visit(this) ^ b.visit(this) & 1);
            }
        });
        return (ret & 1) != 0;
    }

    public abstract int getPrecedence(Notation var1);

    public abstract Op getOp();

    public boolean isCircular() {
        final HashSet<Expression> visited = new HashSet<Expression>();
        visited.add(this);
        final Object loop = new Object();
        return loop == this.visit(new Visitor<Object>(this){

            @Override
            public Object visitBinary(Expression a, Expression b, Op op) {
                if (!visited.add(a)) {
                    return loop;
                }
                if (a.visit(this) == loop) {
                    return loop;
                }
                visited.remove(a);
                if (!visited.add(b)) {
                    return loop;
                }
                if (b.visit(this) == loop) {
                    return loop;
                }
                visited.remove(b);
                return null;
            }

            @Override
            public Object visitNot(Expression a) {
                if (!visited.add(a)) {
                    return loop;
                }
                if (a.visit(this) == loop) {
                    return loop;
                }
                visited.remove(a);
                return null;
            }
        });
    }

    public boolean isCnf() {
        final Object cnf = new Object();
        return cnf == this.visit(new Visitor<Object>(this){
            int level = 0;

            @Override
            public Object visitAnd(Expression a, Expression b) {
                if (this.level > 1) {
                    return null;
                }
                int oldLevel = this.level;
                this.level = 1;
                Object ret = a.visit(this) == cnf && b.visit(this) == cnf ? cnf : null;
                this.level = oldLevel;
                return ret;
            }

            @Override
            public Object visitConstant(int value) {
                return cnf;
            }

            @Override
            public Object visitNot(Expression a) {
                if (this.level == 2) {
                    return null;
                }
                int oldLevel = this.level;
                this.level = 2;
                Object ret = a.visit(this);
                this.level = oldLevel;
                return ret;
            }

            @Override
            public Object visitOr(Expression a, Expression b) {
                if (this.level > 0) {
                    return null;
                }
                return a.visit(this) == cnf && b.visit(this) == cnf ? cnf : null;
            }

            @Override
            public Object visitVariable(String name) {
                return cnf;
            }

            @Override
            public Object visitXor(Expression a, Expression b) {
                return null;
            }

            @Override
            public Object visitXnor(Expression a, Expression b) {
                return null;
            }

            @Override
            public Object visitEq(Expression a, Expression b) {
                return null;
            }
        });
    }

    Expression removeVariable(final String input) {
        return this.visit(new Visitor<Expression>(this){

            @Override
            public Expression visitAnd(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                if (l == null) {
                    return r;
                }
                if (r == null) {
                    return l;
                }
                return Expressions.and(l, r);
            }

            @Override
            public Expression visitConstant(int value) {
                return Expressions.constant(value);
            }

            @Override
            public Expression visitNot(Expression a) {
                Expression l = a.visit(this);
                if (l == null) {
                    return null;
                }
                return Expressions.not(l);
            }

            @Override
            public Expression visitOr(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                if (l == null) {
                    return r;
                }
                if (r == null) {
                    return l;
                }
                return Expressions.or(l, r);
            }

            @Override
            public Expression visitVariable(String name) {
                return name.equals(input) ? null : Expressions.variable(name);
            }

            @Override
            public Expression visitXor(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                if (l == null) {
                    return r;
                }
                if (r == null) {
                    return l;
                }
                return Expressions.xor(l, r);
            }

            @Override
            public Expression visitXnor(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                if (l == null) {
                    return r;
                }
                if (r == null) {
                    return l;
                }
                return Expressions.xnor(l, r);
            }

            @Override
            public Expression visitEq(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                if (l == null) {
                    return r;
                }
                if (r == null) {
                    return l;
                }
                return Expressions.eq(l, r);
            }
        });
    }

    Expression replaceVariable(final String oldName, final String newName) {
        return this.visit(new Visitor<Expression>(this){

            @Override
            public Expression visitAnd(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                return Expressions.and(l, r);
            }

            @Override
            public Expression visitConstant(int value) {
                return Expressions.constant(value);
            }

            @Override
            public Expression visitNot(Expression a) {
                Expression l = a.visit(this);
                return Expressions.not(l);
            }

            @Override
            public Expression visitOr(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                return Expressions.or(l, r);
            }

            @Override
            public Expression visitVariable(String name) {
                return Expressions.variable(name.equals(oldName) ? newName : name);
            }

            @Override
            public Expression visitXor(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                return Expressions.xor(l, r);
            }

            @Override
            public Expression visitXnor(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                return Expressions.xnor(l, r);
            }

            @Override
            public Expression visitEq(Expression a, Expression b) {
                Expression l = a.visit(this);
                Expression r = b.visit(this);
                return Expressions.eq(l, r);
            }
        });
    }

    public String toString() {
        return this.toString(Notation.MATHEMATICAL);
    }

    public String toString(Notation notation) {
        return this.toString(notation, false);
    }

    public String toString(Notation notation, boolean reduce) {
        return this.toString(notation, reduce, null);
    }

    public String toString(final Notation notation, final boolean reduce, final Expression other) {
        final StringBuilder text = new StringBuilder();
        final ArrayList badnessList = new ArrayList();
        if (reduce) {
            this.nots.clear();
            this.subscripts.clear();
            this.marks.clear();
        }
        this.visit(new Visitor<Void>(){
            int curBadness = 0;
            boolean andOp = false;
            boolean inXnor = false;
            final /* synthetic */ Expression this$0;
            {
                this.this$0 = this$0;
            }

            private void add(String txt) {
                text.append(txt);
                for (int i = 0; i < txt.length(); ++i) {
                    badnessList.add(this.curBadness);
                }
            }

            @Override
            public Void visitBinary(Expression a, Expression b, Op op) {
                Range mark = null;
                if (a.equals(other)) {
                    mark = new Range();
                    mark.startIndex = text.length();
                    this.this$0.marks.add(mark);
                }
                int opLvl = notation.opLvl[op.id];
                int aLvl = a.getPrecedence(notation);
                int bLvl = b.getPrecedence(notation);
                if (aLvl < opLvl || aLvl == opLvl && a.getOp() != op) {
                    this.curBadness += 10;
                    this.add("(");
                    a.visit(this);
                    this.add(")");
                    this.curBadness -= 10;
                } else {
                    a.visit(this);
                }
                if (mark != null) {
                    mark.stopIndex = text.length();
                    mark = null;
                }
                this.add(notation.opSym[op.id]);
                if (b.equals(other)) {
                    mark = new Range();
                    mark.startIndex = text.length();
                    this.this$0.marks.add(mark);
                }
                if (bLvl < opLvl || bLvl == opLvl && b.getOp() != op) {
                    this.curBadness += 10;
                    this.add("(");
                    b.visit(this);
                    this.add(")");
                    this.curBadness -= 10;
                } else {
                    b.visit(this);
                }
                if (mark != null) {
                    mark.stopIndex = text.length();
                }
                return null;
            }

            @Override
            public Void visitConstant(int value) {
                this.curBadness += 100;
                this.add(Integer.toString(value, 16));
                this.curBadness -= 100;
                return null;
            }

            @Override
            public Void visitNot(Expression a) {
                this.curBadness += 15;
                int opLvl = notation.opLvl[Op.NOT.id];
                int levelOfA = a.getPrecedence(notation);
                if (reduce && notation.equals((Object)Notation.MATHEMATICAL)) {
                    Range notData = new Range();
                    notData.startIndex = text.length();
                    this.this$0.nots.add(notData);
                    a.visit(this);
                    notData.stopIndex = text.length();
                } else {
                    this.add(notation.opSym[Op.NOT.id]);
                    if (notation.equals((Object)Notation.LATEX)) {
                        a.visit(this);
                        this.add("} ");
                    } else if (levelOfA < opLvl || levelOfA == opLvl && a.getOp() != Op.NOT) {
                        this.curBadness += 10;
                        this.add("(");
                        a.visit(this);
                        this.add(")");
                        this.curBadness -= 10;
                    } else {
                        a.visit(this);
                    }
                }
                this.curBadness -= 15;
                return null;
            }

            @Override
            public Void visitXnor(Expression a, Expression b) {
                if (this.inXnor || !notation.equals((Object)Notation.LATEX)) {
                    this.visitBinary(a, b, notation.equals((Object)Notation.LATEX) ? Op.XOR : Op.XNOR);
                } else {
                    this.inXnor = true;
                    text.append(" \\overline{");
                    this.visitBinary(a, b, Op.XOR);
                    text.append("}");
                    this.inXnor = false;
                }
                return null;
            }

            @Override
            public Void visitVariable(String name) {
                String baseName = name;
                String index = null;
                try {
                    Var.Bit b = Var.Bit.parse(name);
                    baseName = b.name;
                    if (b.bitIndex >= 0) {
                        index = Integer.toString(b.bitIndex);
                    }
                }
                catch (ParserException b) {
                    // empty catch block
                }
                this.curBadness += 200;
                if (reduce && index != null) {
                    this.add(baseName);
                    Range subscript = new Range();
                    subscript.startIndex = text.length();
                    this.add(index);
                    subscript.stopIndex = text.length();
                    this.this$0.subscripts.add(subscript);
                } else if (notation.equals((Object)Notation.LATEX)) {
                    this.add(baseName);
                    if (index != null) {
                        this.add("_{" + index + "}");
                    }
                } else {
                    this.add(name);
                }
                this.curBadness -= 200;
                return null;
            }

            @Override
            public Void visitAnd(Expression a, Expression b) {
                if (this.andOp) {
                    this.visitBinary(a, b, Op.AND);
                } else {
                    this.andOp = true;
                    this.curBadness += 5;
                    this.visitBinary(a, b, Op.AND);
                    this.curBadness -= 5;
                    this.andOp = false;
                }
                return null;
            }
        });
        this.badness = badnessList.toArray(new Integer[0]);
        return notation.equals((Object)Notation.LATEX) ? "$" + String.valueOf(text) + "$" : text.toString();
    }

    public Integer[] getBadness() {
        return this.badness;
    }

    public static boolean isAssignment(Expression expr) {
        boolean bl;
        if (expr instanceof Expressions.Eq) {
            Expressions.Eq eq = (Expressions.Eq)expr;
            bl = eq.exprA instanceof Expressions.Variable;
        } else {
            bl = false;
        }
        return bl;
    }

    public static String getAssignmentVariable(Expression expr) {
        String string;
        if (expr instanceof Expressions.Eq) {
            Expressions.Eq eq = (Expressions.Eq)expr;
            string = eq.exprA instanceof Expressions.Variable ? eq.exprA.toString() : null;
        } else {
            string = null;
        }
        return string;
    }

    public static Expression getAssignmentExpression(Expression expr) {
        Expression expression;
        if (expr instanceof Expressions.Eq) {
            Expressions.Eq eq = (Expressions.Eq)expr;
            expression = eq.exprA instanceof Expressions.Variable ? eq.exprB : null;
        } else {
            expression = null;
        }
        return expression;
    }

    public abstract <T> T visit(Visitor<T> var1);

    abstract int visit(IntVisitor var1);

    public static enum Op {
        EQ(0, 2),
        XNOR(1, 2),
        OR(2, 2),
        XOR(3, 2),
        AND(4, 2),
        NOT(5, 1);

        public final int id;
        public final int arity;

        private Op(int id, int arity) {
            this.id = id;
            this.arity = arity;
        }
    }

    public static interface Visitor<T> {
        default public T visitVariable(String name) {
            return null;
        }

        default public T visitConstant(int value) {
            return null;
        }

        default public T visitNot(Expression a) {
            return null;
        }

        default public T visitBinary(Expression a, Expression b, Op op) {
            a.visit(this);
            b.visit(this);
            return null;
        }

        default public T visitAnd(Expression a, Expression b) {
            return this.visitBinary(a, b, Op.AND);
        }

        default public T visitOr(Expression a, Expression b) {
            return this.visitBinary(a, b, Op.OR);
        }

        default public T visitXor(Expression a, Expression b) {
            return this.visitBinary(a, b, Op.XOR);
        }

        default public T visitXnor(Expression a, Expression b) {
            return this.visitBinary(a, b, Op.XNOR);
        }

        default public T visitEq(Expression a, Expression b) {
            return this.visitBinary(a, b, Op.EQ);
        }
    }

    protected static interface IntVisitor {
        public int visitVariable(String var1);

        public int visitConstant(int var1);

        public int visitNot(Expression var1);

        public int visitAnd(Expression var1, Expression var2);

        public int visitOr(Expression var1, Expression var2);

        public int visitXor(Expression var1, Expression var2);

        public int visitXnor(Expression var1, Expression var2);

        public int visitEq(Expression var1, Expression var2);
    }

    public static enum Notation {
        MATHEMATICAL(0),
        LOGIC(1),
        ALTLOGIC(2),
        PROGBOOLS(3),
        PROGBITS(4),
        LATEX(5);

        public final int id;
        protected final int[] opLvl;
        protected final String[] opSym;
        public static final int NOT_PRECEDENCE = 14;
        public static final int IMPLICIT_AND_PRECEDENCE = 13;
        public static final int TIMES_PRECEDENCE = 13;
        public static final int OPLUS_PRECEDENCE = 12;
        public static final int PLUS_PRECEDENCE = 11;
        public static final int OTIMES_PRECEDENCE = 10;
        public static final int LOGIC_PRECEDENCE = 9;
        public static final int BITAND_PRECEDENCE = 8;
        public static final int BITXOR_PRECEDENCE = 7;
        public static final int BITOR_PRECEDENCE = 6;
        public static final int AND_PRECEDENCE = 5;
        public static final int OR_PRECEDENCE = 4;
        public static final int PYTHON_AND_PRECEDENCE = 3;
        public static final int PYTHON_XOR_PRECEDENCE = 2;
        public static final int PYTHON_OR_PRECEDENCE = 1;
        public static final int EQ_PRECEDENCE = 0;

        private Notation(int id) {
            this.id = id;
            switch (id) {
                case 1: {
                    this.opLvl = new int[]{0, 9, 9, 9, 9, 14};
                    this.opSym = new String[]{" = ", "\u2261", "\u2228", "\u22bb", "\u2227", "\u00ac"};
                    break;
                }
                case 2: {
                    this.opLvl = new int[]{0, 9, 9, 9, 9, 14};
                    this.opSym = new String[]{" = ", "\u2261", "\u2228", "\u2262", "\u2227", "~"};
                    break;
                }
                case 3: {
                    this.opLvl = new int[]{0, 9, 4, 9, 5, 14};
                    this.opSym = new String[]{" = ", "==", "||", "!=", "&&", "!"};
                    break;
                }
                case 4: {
                    this.opLvl = new int[]{0, 9, 6, 7, 8, 14};
                    this.opSym = new String[]{" = ", "^~", "|", "^", "&", "~"};
                    break;
                }
                case 5: {
                    this.opLvl = new int[]{0, 10, 11, 12, 13, 14};
                    this.opSym = new String[]{" = ", " \\oplus ", "+", " \\oplus ", " \\cdot ", " \\overline{"};
                    break;
                }
                default: {
                    this.opLvl = new int[]{0, 10, 11, 12, 13, 14};
                    this.opSym = new String[]{" = ", "\u2299", "+", "\u2295", "\u22c5", "~"};
                }
            }
        }

        public String toString() {
            String key = this.name().toLowerCase() + "Notation";
            return Strings.S.get(key);
        }
    }
}

