/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.ParserException;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.function.Predicate;

public class Parser {
    private static final int TOKEN_AND = 0;
    private static final int TOKEN_OR = 1;
    private static final int TOKEN_XOR = 2;
    private static final int TOKEN_EQ = 3;
    private static final int TOKEN_XNOR = 4;
    private static final int TOKEN_NOT = 5;
    private static final int TOKEN_NOT_POSTFIX = 6;
    private static final int TOKEN_LPAREN = 7;
    private static final int TOKEN_RPAREN = 8;
    private static final int TOKEN_IDENT = 9;
    private static final int TOKEN_CONST = 10;
    private static final int TOKEN_WHITE = 11;
    private static final int TOKEN_ERROR_BADCHAR = 12;
    private static final int TOKEN_ERROR_BRACE = 13;
    private static final int TOKEN_ERROR_SUBSCRIPT = 14;
    private static final int TOKEN_ERROR_IDENT = 15;

    private Parser() {
    }

    private static boolean okCharacter(char c) {
        return Character.isWhitespace(c) || Character.isJavaIdentifierStart(c) || "()01~-^+*!&|=\\':[]".indexOf(c) >= 0 || "\u2260\u2262\u22c0\u22c1\u2227\u2228\u2295\u22c5\u00ac\u2219".indexOf(c) >= 0 || "\u21d4\u2261\u2194\u02dc\u00b7\u2225\u22bb\u22a4\u22a5".indexOf(c) >= 0;
    }

    public static Expression parseMaybeAssignment(String in, AnalyzerModel model) throws ParserException {
        return Parser.parse(in, model, true);
    }

    private static Expression parse(ArrayList<Token> tokens) throws ParserException {
        ArrayList<Context> stack = new ArrayList<Context>();
        Expression current = null;
        for (int i = 0; i < tokens.size(); ++i) {
            Token t = tokens.get(i);
            if (t.type == 9 || t.type == 10) {
                Expression here = t.type == 9 ? Expressions.variable(t.text) : Expressions.constant(Integer.parseInt(t.text, 16));
                while (i + 1 < tokens.size() && tokens.get((int)(i + 1)).type == 6) {
                    here = Expressions.not(here);
                    ++i;
                }
                while (Parser.peekLevel(stack) == 14) {
                    here = Expressions.not(here);
                    Parser.pop(stack);
                }
                current = Expressions.and(current, here);
                if (Parser.peekLevel(stack) != 13) continue;
                Context top = Parser.pop(stack);
                current = Expressions.and(top.current, current);
                continue;
            }
            if (t.type == 5) {
                if (current != null) {
                    Parser.push(stack, current, 13, new Token(0, t.offset, Strings.S.get("implicitAndOperator"), 13));
                }
                Parser.push(stack, null, 14, t);
                current = null;
                continue;
            }
            if (t.type == 6) {
                throw t.error(Strings.S.getter("unexpectedApostrophe"));
            }
            if (t.type == 7) {
                if (current != null) {
                    Parser.push(stack, current, 13, new Token(0, t.offset, 0, Strings.S.get("implicitAndOperator"), 13));
                }
                Parser.push(stack, null, -2, t);
                current = null;
                continue;
            }
            if (t.type == 8) {
                current = Parser.popTo(stack, -1, current);
                if (stack.isEmpty()) {
                    throw t.error(Strings.S.getter("lparenMissingError"));
                }
                Parser.pop(stack);
                while (i + 1 < tokens.size() && tokens.get((int)(i + 1)).type == 6) {
                    current = Expressions.not(current);
                    ++i;
                }
                current = Parser.popTo(stack, 13, current);
                continue;
            }
            if (current == null) {
                throw t.error(Strings.S.getter("missingLeftOperandError", t.text));
            }
            Parser.push(stack, Parser.popTo(stack, t.precedence, current), t.precedence, t);
            current = null;
        }
        current = Parser.popTo(stack, -1, current);
        if (!stack.isEmpty()) {
            Context top = Parser.pop(stack);
            throw top.cause.error(Strings.S.getter("rparenMissingError"));
        }
        return current;
    }

    public static Expression parse(String in, AnalyzerModel model) throws ParserException {
        return Parser.parse(in, model, false);
    }

    private static Expression parse(String in, AnalyzerModel model, boolean allowOutputAssignment) throws ParserException {
        ArrayList<Token> tokens = Parser.toTokens(in, false);
        if (tokens.isEmpty()) {
            return null;
        }
        int i = -1;
        for (Token token : tokens) {
            int index;
            ++i;
            if (token.type == 12) {
                throw token.error(Strings.S.getter("invalidCharacterError", token.text));
            }
            if (token.type == 13) {
                throw token.error(Strings.S.getter("missingBraceError", token.text));
            }
            if (token.type == 14) {
                throw token.error(Strings.S.getter("missingSubscriptError", token.text));
            }
            if (token.type == 15) {
                throw token.error(Strings.S.getter("missingIdentifierError", token.text));
            }
            if (!(token.type != 3 || i == 1 && allowOutputAssignment)) {
                throw token.error(Strings.S.getter("unexpectedAssignmentError", token.text));
            }
            if (token.type != 9 || (index = model.getInputs().bits.indexOf(token.text)) >= 0) continue;
            String opText = token.text.toUpperCase();
            if (opText.equals("NOT")) {
                token.type = 5;
                token.precedence = 14;
                continue;
            }
            if (opText.equals("AND")) {
                token.type = 0;
                token.precedence = 3;
                continue;
            }
            if (opText.equals("XOR")) {
                token.type = 2;
                token.precedence = 2;
                continue;
            }
            if (opText.equals("OR")) {
                token.type = 1;
                token.precedence = 1;
                continue;
            }
            if (opText.contentEquals("EQUALS")) {
                token.type = 4;
                token.precedence = 9;
                continue;
            }
            if (i == 0 && allowOutputAssignment && (index = model.getOutputs().bits.indexOf(token.text)) >= 0 && tokens.size() >= 2 && (tokens.get((int)1).type == 4 || tokens.get((int)1).type == 3)) {
                tokens.get((int)1).type = 3;
                tokens.get((int)1).precedence = 0;
                continue;
            }
            throw token.error(Strings.S.getter("badVariableName", token.text));
        }
        return Parser.parse(tokens);
    }

    private static int peekLevel(ArrayList<Context> stack) {
        if (stack.isEmpty()) {
            return -3;
        }
        Context context = stack.get(stack.size() - 1);
        return context.level;
    }

    private static Context pop(ArrayList<Context> stack) {
        return stack.remove(stack.size() - 1);
    }

    private static Expression popTo(ArrayList<Context> stack, int level, Expression current) throws ParserException {
        while (!stack.isEmpty() && Parser.peekLevel(stack) >= level) {
            Context top = Parser.pop(stack);
            if (current == null) {
                throw top.cause.error(Strings.S.getter("missingRightOperandError", top.cause.text));
            }
            if (top.cause.type == 0) {
                current = Expressions.and(top.current, current);
                continue;
            }
            if (top.cause.type == 1) {
                current = Expressions.or(top.current, current);
                continue;
            }
            if (top.cause.type == 2) {
                current = Expressions.xor(top.current, current);
                continue;
            }
            if (top.cause.type == 4) {
                current = Expressions.xnor(top.current, current);
                continue;
            }
            if (top.cause.type == 3) {
                current = Expressions.eq(top.current, current);
                continue;
            }
            if (top.cause.type != 5) continue;
            current = Expressions.not(current);
        }
        return current;
    }

    private static void push(ArrayList<Context> stack, Expression expr, int level, Token cause) {
        stack.add(new Context(expr, level, cause));
    }

    static String replaceVariable(String in, String oldName, String newName) {
        StringBuilder ret = new StringBuilder();
        ArrayList<Token> tokens = Parser.toTokens(in, true);
        for (Token token : tokens) {
            if (token.type == 9 && token.text.equals(oldName)) {
                ret.append(newName);
                continue;
            }
            ret.append(token.text);
        }
        return ret.toString();
    }

    private static ArrayList<Token> toTokens(String in, boolean includeWhite) {
        return new Tokenizer(in, includeWhite).tokenize();
    }

    private static class Token {
        int type;
        final int offset;
        final int length;
        int precedence;
        final String text;

        Token(int type, int offset, int length, String text, int precedence) {
            this.type = type;
            this.offset = offset;
            this.length = length;
            this.text = text;
            this.precedence = precedence;
        }

        Token(int type, int offset, String text, int precedence) {
            this(type, offset, text.length(), text, precedence);
        }

        ParserException error(StringGetter message) {
            return new ParserException(message, this.offset, this.length);
        }
    }

    private static class Context {
        final int level;
        final Expression current;
        final Token cause;

        Context(Expression current, int level, Token cause) {
            this.level = level;
            this.current = current;
            this.cause = cause;
        }
    }

    static class Tokenizer {
        private final String in;
        private final boolean includeWhite;
        private int pos;
        private final int len;

        public Tokenizer(String in, boolean includeWhite) {
            this.len = in.length();
            this.in = in + " ";
            this.includeWhite = includeWhite;
        }

        boolean skipWhile(Predicate<Character> pred) {
            while (this.pos < this.len && pred.test(Character.valueOf(this.peek()))) {
                ++this.pos;
            }
            return this.pos == this.len;
        }

        boolean skipUntil(Predicate<Character> pred) {
            return this.skipWhile(pred.negate());
        }

        boolean skipSpaces() {
            return this.skipWhile(Character::isWhitespace);
        }

        String readNumber() {
            int substart = this.pos;
            this.skipWhile(this::isDigit);
            return this.in.substring(substart, this.pos);
        }

        boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        boolean accept(char c) {
            if (this.peek() == c) {
                ++this.pos;
                return true;
            }
            return false;
        }

        char peek() {
            return this.in.charAt(this.pos);
        }

        char next() {
            return this.in.charAt(this.pos++);
        }

        Token readToken(char startChar, int start) {
            switch (startChar) {
                case '(': {
                    return new Token(7, start, "(", Integer.MAX_VALUE);
                }
                case ')': {
                    return new Token(8, start, ")", Integer.MAX_VALUE);
                }
                case '1': 
                case '\u22a4': {
                    return new Token(10, start, "1", Integer.MAX_VALUE);
                }
                case '0': 
                case '\u22a5': {
                    return new Token(10, start, "0", Integer.MAX_VALUE);
                }
                case '-': 
                case '~': 
                case '\u00ac': 
                case '\u02dc': {
                    return new Token(5, start, "~", 14);
                }
                case '!': {
                    if (this.accept('=')) {
                        return new Token(2, start, this.in.substring(start, this.pos), 9);
                    }
                    return new Token(5, start, "~", 14);
                }
                case '\'': {
                    return new Token(6, start, "'", 14);
                }
                case '^': 
                case '\u2295': {
                    return new Token(2, start, "^", 12);
                }
                case '\u2260': 
                case '\u2262': 
                case '\u22bb': {
                    return new Token(2, start, "^", 9);
                }
                case '+': 
                case '\u2228': 
                case '\u22c1': {
                    return new Token(1, start, "+", 9);
                }
                case '\u2225': {
                    return new Token(1, start, "+", 4);
                }
                case '*': 
                case '\u2227': 
                case '\u22c0': {
                    return new Token(0, start, "*", 9);
                }
                case '\u00b7': 
                case '\u2219': 
                case '\u22c5': {
                    return new Token(0, start, "*", 13);
                }
                case '\u2299': {
                    return new Token(4, start, "^", 10);
                }
                case '\u2194': 
                case '\u21d4': 
                case '\u2261': {
                    return new Token(4, start, "=", 9);
                }
                case '&': {
                    if (this.accept('&')) {
                        return new Token(0, start, "&&", 5);
                    }
                    return new Token(0, start, "&", 8);
                }
                case '|': {
                    if (this.accept('|')) {
                        return new Token(1, start, "||", 4);
                    }
                    return new Token(1, start, "|", 6);
                }
                case '=': {
                    this.accept('=');
                    return new Token(4, start, this.in.substring(start, this.pos), 9);
                }
                case ':': {
                    this.accept('=');
                    return new Token(3, start, this.in.substring(start, this.pos), 0);
                }
                case '[': 
                case ']': {
                    return new Token(15, start, this.in.substring(start, start + 1), 0);
                }
            }
            this.skipUntil(Parser::okCharacter);
            String errorText = this.in.substring(start, this.pos);
            return new Token(12, start, errorText, 0);
        }

        ArrayList<Token> tokenize() {
            ArrayList<Token> tokens = new ArrayList<Token>();
            this.pos = 0;
            while (true) {
                int whiteStart = this.pos;
                this.skipSpaces();
                if (this.includeWhite && this.pos != whiteStart) {
                    tokens.add(new Token(11, whiteStart, this.in.substring(whiteStart, this.pos), 0));
                }
                if (this.pos == this.len) {
                    return tokens;
                }
                int start = this.pos;
                char startChar = this.next();
                if (Character.isJavaIdentifierStart(startChar)) {
                    this.skipWhile(Character::isJavaIdentifierPart);
                    String name = this.in.substring(start, this.pos);
                    String subscript = null;
                    if (this.in.charAt(this.pos) == ':' && this.isDigit(this.in.charAt(this.pos + 1))) {
                        ++this.pos;
                        subscript = this.readNumber();
                    } else if (this.in.charAt(this.pos) == '[') {
                        int bracestart = this.pos++;
                        if (this.skipSpaces()) {
                            tokens.add(new Token(13, start, this.in.substring(bracestart), 0));
                            continue;
                        }
                        subscript = this.readNumber();
                        if (this.skipSpaces() || !this.accept(']')) {
                            tokens.add(new Token(13, start, this.in.substring(bracestart), 0));
                            continue;
                        }
                        ++this.pos;
                    }
                    if (subscript != null) {
                        if ((subscript = subscript.trim()).isEmpty()) {
                            tokens.add(new Token(14, start, this.in.substring(start, this.pos), 0));
                            continue;
                        }
                        try {
                            int s = Integer.parseInt(subscript);
                            tokens.add(new Token(9, start, name + "[" + s + "]", Integer.MAX_VALUE));
                        }
                        catch (NumberFormatException e) {
                            tokens.add(new Token(14, start, this.in.substring(start, this.pos), 0));
                        }
                        continue;
                    }
                    tokens.add(new Token(9, start, name, Integer.MAX_VALUE));
                    continue;
                }
                tokens.add(this.readToken(startChar, start));
            }
        }
    }
}

