/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.util.Collection;

public class CircuitChange {
    static final int CLEAR = 0;
    static final int ADD = 1;
    static final int ADD_ALL = 2;
    static final int REMOVE = 3;
    static final int REMOVE_ALL = 4;
    static final int REPLACE = 5;
    static final int SET = 6;
    static final int SET_FOR_CIRCUIT = 7;
    private final Circuit circuit;
    private final int type;
    private final Component comp;
    private Collection<? extends Component> comps;
    private final Attribute<?> attr;
    private final Object oldValue;
    private final Object newValue;

    public static CircuitChange add(Circuit circuit, Component comp) {
        return new CircuitChange(circuit, 1, comp);
    }

    public static CircuitChange addAll(Circuit circuit, Collection<? extends Component> comps) {
        return new CircuitChange(circuit, 2, comps);
    }

    public static CircuitChange clear(Circuit circuit, Collection<Component> oldComponents) {
        return new CircuitChange(circuit, 0, oldComponents);
    }

    public static CircuitChange remove(Circuit circuit, Component comp) {
        return new CircuitChange(circuit, 3, comp);
    }

    public static CircuitChange removeAll(Circuit circuit, Collection<? extends Component> comps) {
        return new CircuitChange(circuit, 4, comps);
    }

    public static CircuitChange replace(Circuit circuit, ReplacementMap replMap) {
        return new CircuitChange(circuit, 5, null, null, null, replMap);
    }

    public static CircuitChange set(Circuit circuit, Component comp, Attribute<?> attr, Object value) {
        return new CircuitChange(circuit, 6, comp, attr, null, value);
    }

    public static CircuitChange set(Circuit circuit, Component comp, Attribute<?> attr, Object oldValue, Object newValue) {
        return new CircuitChange(circuit, 6, comp, attr, oldValue, newValue);
    }

    public static CircuitChange setForCircuit(Circuit circuit, Attribute<?> attr, Object v) {
        return new CircuitChange(circuit, 7, null, attr, null, v);
    }

    public static CircuitChange setForCircuit(Circuit circuit, Attribute<?> attr, Object oldValue, Object newValue) {
        return new CircuitChange(circuit, 7, null, attr, oldValue, newValue);
    }

    private CircuitChange(Circuit circuit, int type, Collection<? extends Component> comps) {
        this(circuit, type, null, null, null, null);
        this.comps = comps;
    }

    private CircuitChange(Circuit circuit, int type, Component comp) {
        this(circuit, type, comp, null, null, null);
    }

    private CircuitChange(Circuit circuit, int type, Component comp, Attribute<?> attr, Object oldValue, Object newValue) {
        this.circuit = circuit;
        this.type = type;
        this.comp = comp;
        this.attr = attr;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    boolean concernsSupercircuit() {
        switch (this.type) {
            case 0: {
                return true;
            }
            case 1: 
            case 3: {
                return this.comp.getFactory() instanceof Pin;
            }
            case 2: 
            case 4: {
                for (Component component : this.comps) {
                    if (!(component.getFactory() instanceof Pin)) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                ReplacementMap repl = (ReplacementMap)this.newValue;
                for (Component component : repl.getRemovals()) {
                    if (!(component.getFactory() instanceof Pin)) continue;
                    return true;
                }
                for (Component component : repl.getAdditions()) {
                    if (!(component.getFactory() instanceof Pin)) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                return this.comp.getFactory() instanceof Pin && (this.attr == StdAttr.WIDTH || this.attr == Pin.ATTR_TYPE || this.attr == StdAttr.LABEL);
            }
            case 7: {
                return this.attr == CircuitAttributes.NAME_ATTR || this.attr == CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE || this.attr == CircuitAttributes.APPEARANCE_ATTR;
            }
        }
        return false;
    }

    boolean concernsSiblingComponents() {
        if (this.type == 6) {
            return this.comp.getFactory() instanceof SubcircuitFactory && this.attr == CircuitAttributes.APPEARANCE_ATTR || this.comp.getFactory() instanceof VhdlEntity && this.attr == StdAttr.APPEARANCE;
        }
        return false;
    }

    void execute(CircuitMutator mutator, ReplacementMap prevReplacements) {
        switch (this.type) {
            case 0: {
                mutator.clear(this.circuit);
                prevReplacements.reset();
                break;
            }
            case 1: {
                prevReplacements.add(this.comp);
                break;
            }
            case 2: {
                for (Component component : this.comps) {
                    prevReplacements.add(component);
                }
                break;
            }
            case 3: {
                prevReplacements.remove(this.comp);
                break;
            }
            case 4: {
                for (Component component : this.comps) {
                    prevReplacements.remove(component);
                }
                break;
            }
            case 5: {
                prevReplacements.append((ReplacementMap)this.newValue);
                break;
            }
            case 6: {
                mutator.replace(this.circuit, prevReplacements);
                prevReplacements.reset();
                mutator.set(this.circuit, this.comp, this.attr, this.newValue);
                break;
            }
            case 7: {
                mutator.replace(this.circuit, prevReplacements);
                prevReplacements.reset();
                mutator.setForCircuit(this.circuit, this.attr, this.newValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown change type " + this.type);
            }
        }
    }

    public Attribute<?> getAttribute() {
        return this.attr;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public Component getComponent() {
        return this.comp;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    CircuitChange getReverseChange() {
        return switch (this.type) {
            case 0 -> CircuitChange.addAll(this.circuit, this.comps);
            case 1 -> CircuitChange.remove(this.circuit, this.comp);
            case 2 -> CircuitChange.removeAll(this.circuit, this.comps);
            case 3 -> CircuitChange.add(this.circuit, this.comp);
            case 4 -> CircuitChange.addAll(this.circuit, this.comps);
            case 6 -> CircuitChange.set(this.circuit, this.comp, this.attr, this.newValue, this.oldValue);
            case 7 -> CircuitChange.setForCircuit(this.circuit, this.attr, this.newValue, this.oldValue);
            case 5 -> CircuitChange.replace(this.circuit, ((ReplacementMap)this.newValue).getInverseMap());
            default -> throw new IllegalArgumentException("unknown change type " + this.type);
        };
    }

    public int getType() {
        return this.type;
    }
}

