/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutatorImpl;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.ReplacementMap;
import java.util.Collection;

public class CircuitTransactionResult {
    private final CircuitMutatorImpl mutator;

    CircuitTransactionResult(CircuitMutatorImpl mutator) {
        this.mutator = mutator;
    }

    public Collection<Circuit> getModifiedCircuits() {
        return this.mutator.getModifiedCircuits();
    }

    public ReplacementMap getReplacementMap(Circuit circuit) {
        ReplacementMap ret = this.mutator.getReplacementMap(circuit);
        return ret == null ? new ReplacementMap() : ret;
    }

    public CircuitTransaction getReverseTransaction() {
        return this.mutator.getReverseTransaction();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("CircuitTransactionResult affecting...");
        for (Circuit c : this.getModifiedCircuits()) {
            s.append("\n    - circuit ").append(c).append(" with replacements...");
            s.append("\n").append(this.getReplacementMap(c));
        }
        return s.toString();
    }
}

