/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.PropagationPoints;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.gui.log.ClockSource;
import com.cburch.logisim.gui.log.ComponentSelector;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Simulator {
    private final SimThread simThread;
    private final ArrayList<StatusListener> statusListeners = new ArrayList();
    private ArrayList<Listener> activityListeners = new ArrayList();
    private volatile ProgressListener progressListener = null;
    private final Object lock = new Object();
    private volatile int numListeners = 0;
    private volatile Listener[] listeners = new Listener[10];

    public Simulator() {
        this.simThread = new SimThread(this);
        try {
            this.simThread.setPriority(this.simThread.getPriority() - 1);
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            // empty catch block
        }
        this.simThread.start();
        this.setTickFrequency(AppPreferences.TICK_FREQUENCY.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulatorListener(StatusListener listener) {
        if (listener instanceof Listener) {
            Object object = this.lock;
            synchronized (object) {
                this.statusListeners.add(listener);
                this.activityListeners.add((Listener)listener);
                if (this.numListeners >= 0) {
                    if (this.numListeners >= this.listeners.length) {
                        Listener[] newArray = new Listener[2 * this.listeners.length];
                        for (int idx = 0; idx < this.numListeners; ++idx) {
                            newArray[idx] = this.listeners[idx];
                        }
                        this.listeners = newArray;
                    }
                    this.listeners[this.numListeners] = (Listener)listener;
                    ++this.numListeners;
                }
                if (listener instanceof ProgressListener) {
                    if (this.progressListener != null) {
                        throw new IllegalStateException("only one chronogram listener supported");
                    }
                    this.progressListener = (ProgressListener)listener;
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.statusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulatorListener(StatusListener listener) {
        if (listener instanceof Listener) {
            Object object = this.lock;
            synchronized (object) {
                if (listener == this.progressListener) {
                    this.progressListener = null;
                }
                this.statusListeners.remove(listener);
                this.activityListeners.remove((Listener)listener);
                this.numListeners = -1;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.statusListeners.remove(listener);
        }
    }

    public void drawStepPoints(ComponentDrawContext context) {
        this.simThread.drawStepPoints(context);
    }

    public void drawPendingInputs(ComponentDrawContext context) {
        this.simThread.drawPendingInputs(context);
    }

    public String getSingleStepMessage() {
        return this.simThread.getSingleStepMessage();
    }

    public void addPendingInput(CircuitState state, Component comp) {
        this.simThread.addPendingInput(state, comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<StatusListener> copyStatusListeners() {
        ArrayList<StatusListener> copy;
        Object object = this.lock;
        synchronized (object) {
            copy = new ArrayList<StatusListener>(this.statusListeners);
        }
        return copy;
    }

    private void fireSimulatorReset() {
        Event event = new Event(this, false, false, false);
        for (StatusListener listener : this.copyStatusListeners()) {
            listener.simulatorReset(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropagationCompleted(boolean t, boolean s, boolean p) {
        Event event = new Event(this, t, s, p);
        int nrListeners = this.numListeners;
        if (nrListeners < 0) {
            Object object = this.lock;
            synchronized (object) {
                int idx;
                nrListeners = this.activityListeners.size();
                if (nrListeners > this.listeners.length) {
                    this.listeners = new Listener[2 * nrListeners];
                }
                for (idx = 0; idx < nrListeners; ++idx) {
                    this.listeners[idx] = this.activityListeners.get(idx);
                }
                for (idx = nrListeners; idx < this.listeners.length; ++idx) {
                    this.listeners[idx] = null;
                }
                this.numListeners = nrListeners;
            }
        }
        if (nrListeners == 0) {
            return;
        }
        for (int idx = 0; idx < nrListeners; ++idx) {
            this.listeners[idx].propagationCompleted(event);
        }
    }

    private void fireSimulatorStateChanged() {
        Event event = new Event(this, false, false, false);
        for (StatusListener listener : this.copyStatusListeners()) {
            listener.simulatorStateChanged(event);
        }
    }

    public double getTickFrequency() {
        return this.simThread.getTickFrequencyUnsynchronized();
    }

    public boolean isExceptionEncountered() {
        return this.simThread.exceptionEncountered;
    }

    public boolean isOscillating() {
        return this.simThread.oscillating;
    }

    public CircuitState getCircuitState() {
        Propagator prop = this.simThread.getPropagatorUnsynchronized();
        return prop == null ? null : prop.getRootState();
    }

    public boolean isAutoPropagating() {
        return this.simThread.isAutoPropagatingUnsynchronized();
    }

    public boolean isAutoTicking() {
        return this.simThread.isAutoTickingUnsynchronized();
    }

    public void setCircuitState(CircuitState state) {
        if (this.simThread.setPropagator(state == null ? null : state.getPropagator())) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setAutoPropagation(boolean value) {
        if (this.simThread.setAutoPropagation(value)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setAutoTicking(boolean value) {
        if (value && !this.ensureClocks()) {
            return;
        }
        if (this.simThread.setAutoTicking(value)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setTickFrequency(double freq) {
        if (this.simThread.setTickFrequency(freq)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void step() {
        this.simThread.requestStep();
    }

    public void tick(int count) {
        if (!this.ensureClocks()) {
            return;
        }
        this.simThread.requestTick(count);
    }

    public void reset() {
        this.simThread.requestReset();
    }

    public boolean nudge() {
        return this.simThread.requestNudge();
    }

    public void shutDown() {
        this.simThread.requestShutDown();
    }

    private boolean ensureClocks() {
        CircuitState cs = this.getCircuitState();
        if (cs == null) {
            return false;
        }
        if (cs.hasKnownClocks()) {
            return true;
        }
        Circuit circ = cs.getCircuit();
        ArrayList<SignalInfo> clocks = ComponentSelector.findClocks(circ);
        if (CollectionUtil.isNotEmpty(clocks)) {
            cs.markKnownClocks();
            return true;
        }
        Component clk = ClockSource.doClockDriverDialog(circ);
        if (clk == null || !cs.setTemporaryClock(clk)) {
            return false;
        }
        this.fireSimulatorStateChanged();
        return true;
    }

    public static interface ProgressListener
    extends Listener {
        public boolean wantsProgressEvents();

        public void propagationInProgress(Event var1);
    }

    public static interface Listener
    extends StatusListener {
        public void propagationCompleted(Event var1);
    }

    private static class SimThread
    extends UniquelyNamedThread {
        private final Simulator sim;
        private ReentrantLock simStateLock = new ReentrantLock();
        private Condition simStateUpdated = this.simStateLock.newCondition();
        private Propagator propagator = null;
        private boolean autoPropagating = true;
        private boolean autoTicking = false;
        private double autoTickFreq = 1.0;
        private int smoothingFactor = 1;
        private long autoTickNanos = Math.round(1.0E9 / this.autoTickFreq);
        private int manualTicksRequested = 0;
        private int manualStepsRequested = 0;
        private boolean nudgeRequested = false;
        private boolean resetRequested = false;
        private boolean complete = false;
        private double avgTickNanos = -1.0;
        private volatile Propagator propagatorUnsynchronized = null;
        private volatile boolean autoPropagatingUnsynchronized = true;
        private volatile boolean autoTickingUnsynchronized = false;
        private volatile double autoTickFreqUnsynchronized = 1.0;
        private volatile boolean exceptionEncountered = false;
        private volatile boolean oscillating = false;
        private final PropagationPoints stepPoints = new PropagationPoints();
        private long lastTick = System.nanoTime();

        SimThread(Simulator s) {
            super("SimThread");
            this.sim = s;
        }

        Propagator getPropagatorUnsynchronized() {
            return this.propagatorUnsynchronized;
        }

        boolean isAutoTickingUnsynchronized() {
            return this.autoTickingUnsynchronized;
        }

        boolean isAutoPropagatingUnsynchronized() {
            return this.autoPropagatingUnsynchronized;
        }

        double getTickFrequencyUnsynchronized() {
            return this.autoTickFreqUnsynchronized;
        }

        void drawStepPoints(ComponentDrawContext context) {
            if (!this.autoPropagatingUnsynchronized) {
                this.stepPoints.draw(context);
            }
        }

        void drawPendingInputs(ComponentDrawContext context) {
            if (!this.autoPropagatingUnsynchronized) {
                this.stepPoints.drawPendingInputs(context);
            }
        }

        void addPendingInput(CircuitState state, Component comp) {
            if (!this.autoPropagatingUnsynchronized) {
                this.stepPoints.addPendingInput(state, comp);
            }
        }

        synchronized String getSingleStepMessage() {
            return this.autoPropagatingUnsynchronized ? "" : this.stepPoints.getSingleStepMessage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setPropagator(Propagator prop) {
            int smoothFactor = 1;
            if (prop != null) {
                Options opts = prop.getRootState().getProject().getOptions();
                if (smoothFactor < 1) {
                    smoothFactor = 1;
                }
            }
            this.simStateLock.lock();
            try {
                if (this.propagator == prop) {
                    boolean bl = false;
                    return bl;
                }
                this.propagator = prop;
                this.propagatorUnsynchronized = prop;
                this.smoothingFactor = smoothFactor;
                this.manualTicksRequested = 0;
                this.manualStepsRequested = 0;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        boolean setAutoPropagation(boolean value) {
            this.simStateLock.lock();
            try {
                if (this.autoPropagating == value) {
                    boolean bl = false;
                    return bl;
                }
                this.autoPropagating = value;
                this.autoPropagatingUnsynchronized = value;
                if (this.autoPropagating) {
                    this.manualStepsRequested = 0;
                } else {
                    this.nudgeRequested = false;
                }
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        boolean setAutoTicking(boolean value) {
            this.simStateLock.lock();
            try {
                if (this.autoTicking == value) {
                    boolean bl = false;
                    return bl;
                }
                this.autoTicking = value;
                this.autoTickingUnsynchronized = value;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setTickFrequency(double freq) {
            this.simStateLock.lock();
            try {
                if (this.autoTickFreq == freq) {
                    boolean bl = false;
                    return bl;
                }
                this.autoTickFreq = freq;
                this.autoTickFreqUnsynchronized = freq;
                this.autoTickNanos = freq <= 0.0 ? 0L : Math.round(1.0E9 / this.autoTickFreq);
                this.avgTickNanos = -1.0;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        void requestStep() {
            this.simStateLock.lock();
            try {
                ++this.manualStepsRequested;
                this.autoPropagating = false;
                this.autoPropagatingUnsynchronized = false;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        void requestTick(int count) {
            this.simStateLock.lock();
            try {
                this.manualTicksRequested += count;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        void requestReset() {
            this.simStateLock.lock();
            try {
                this.resetRequested = true;
                this.manualTicksRequested = 0;
                this.manualStepsRequested = 0;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        boolean requestNudge() {
            this.simStateLock.lock();
            try {
                if (!this.autoPropagating) {
                    boolean bl = false;
                    return bl;
                }
                this.nudgeRequested = true;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        void requestShutDown() {
            this.simStateLock.lock();
            try {
                this.complete = true;
                if (Thread.currentThread() != this) {
                    this.simStateUpdated.signalAll();
                }
            }
            finally {
                this.simStateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean loop() {
            Propagator prop = null;
            boolean doReset = false;
            boolean doNudge = false;
            boolean doTick = false;
            boolean doTickIfStable = false;
            boolean doStep = false;
            boolean doProp = false;
            long now = 0L;
            this.simStateLock.lock();
            try {
                boolean ready = false;
                do {
                    if (this.complete) {
                        boolean bl = false;
                        return bl;
                    }
                    prop = this.propagator;
                    now = System.nanoTime();
                    if (this.resetRequested) {
                        this.resetRequested = false;
                        doReset = true;
                        doProp = this.autoPropagating;
                        ready = true;
                        continue;
                    }
                    if (this.nudgeRequested) {
                        this.nudgeRequested = false;
                        doNudge = true;
                        ready = true;
                        continue;
                    }
                    if (this.manualStepsRequested > 0) {
                        --this.manualStepsRequested;
                        doTickIfStable = this.autoTicking;
                        doStep = true;
                        ready = true;
                        continue;
                    }
                    if (this.manualTicksRequested > 0) {
                        doTick = true;
                        doProp = this.autoPropagating;
                        doStep = !this.autoPropagating;
                        ready = true;
                        continue;
                    }
                    if (this.autoTicking && this.autoPropagating && this.autoTickNanos > 0L) {
                        int smooth = this.smoothingFactor;
                        long lastNanos = now - this.lastTick;
                        if (this.avgTickNanos <= 0.0) {
                            this.avgTickNanos = this.autoTickNanos;
                            doTick = true;
                            doProp = true;
                            ready = true;
                            continue;
                        }
                        double avg = ((double)smooth - 1.0) / (double)smooth * this.avgTickNanos + 1.0 / (double)smooth * (double)lastNanos;
                        long deadline = this.lastTick + this.autoTickNanos - (long)((double)(smooth - 1) * (this.avgTickNanos - (double)this.autoTickNanos));
                        long delta = deadline - now;
                        if (delta <= 1000L) {
                            this.avgTickNanos = avg;
                            doTick = true;
                            doProp = true;
                            ready = true;
                            continue;
                        }
                        if (delta < 1000000L) {
                            this.simStateLock.unlock();
                            try {
                                long time = 0L;
                                while ((time = System.nanoTime()) < deadline) {
                                }
                            }
                            finally {
                                this.simStateLock.lock();
                            }
                        } else {
                            try {
                                this.simStateUpdated.awaitNanos(delta);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                    }
                    this.avgTickNanos = -1.0;
                    try {
                        this.simStateUpdated.await();
                    }
                    catch (InterruptedException smooth) {
                        // empty catch block
                    }
                } while (!ready);
            }
            finally {
                this.simStateLock.unlock();
            }
            this.exceptionEncountered = false;
            boolean oops = false;
            boolean osc = false;
            boolean ticked = false;
            boolean stepped = false;
            boolean propagated = false;
            boolean hasClocks = true;
            if (doReset) {
                try {
                    this.stepPoints.clear();
                    if (prop != null) {
                        prop.reset();
                    }
                    this.sim.fireSimulatorReset();
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            if (doTick || doTickIfStable && prop != null && !prop.isPending()) {
                this.lastTick = now;
                ticked = true;
                if (prop != null) {
                    hasClocks = prop.toggleClocks();
                }
            }
            if (doProp || doNudge) {
                try {
                    propagated = doProp;
                    ProgressListener listener = this.sim.progressListener;
                    Event evt = listener == null ? null : new Event(this.sim, false, false, false);
                    this.stepPoints.clear();
                    if (prop != null) {
                        propagated |= prop.propagate(listener, evt);
                    }
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            if (doStep) {
                try {
                    stepped = true;
                    this.stepPoints.clear();
                    if (prop != null) {
                        prop.step(this.stepPoints);
                    }
                    if (prop == null || !prop.isPending()) {
                        propagated = true;
                    }
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            osc = prop != null && prop.isOscillating();
            boolean clockDied = false;
            this.exceptionEncountered = oops;
            this.oscillating = osc;
            this.simStateLock.lock();
            try {
                if (osc) {
                    this.autoPropagating = false;
                    this.autoPropagatingUnsynchronized = false;
                    this.nudgeRequested = false;
                }
                if (ticked && this.manualTicksRequested > 0) {
                    --this.manualTicksRequested;
                }
                if (this.autoTicking && !hasClocks) {
                    this.autoTicking = false;
                    this.autoTickingUnsynchronized = false;
                    clockDied = true;
                }
            }
            finally {
                this.simStateLock.unlock();
            }
            if (ticked || stepped || propagated || doNudge) {
                this.sim.firePropagationCompleted(ticked, stepped && !propagated, propagated);
            }
            if (!clockDied) return true;
            this.sim.fireSimulatorStateChanged();
            return true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (this.loop()) {
                    }
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.exceptionEncountered = true;
                    this.simStateLock.lock();
                    try {
                        this.autoPropagating = false;
                        this.autoPropagatingUnsynchronized = false;
                        this.autoTicking = false;
                        this.autoTickingUnsynchronized = false;
                        this.manualTicksRequested = 0;
                        this.manualStepsRequested = 0;
                        this.nudgeRequested = false;
                    }
                    finally {
                        this.simStateLock.unlock();
                    }
                    SwingUtilities.invokeLater(new Runnable(this){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "The simulator crashed. Save your work and restart Logisim.");
                        }
                    });
                    continue;
                }
                break;
            }
        }
    }

    public static class Event {
        private final Simulator source;
        private final boolean didTick;
        private final boolean didSingleStep;
        private final boolean didPropagate;

        public Event(Simulator src, boolean t, boolean s, boolean p) {
            this.source = src;
            this.didTick = t;
            this.didSingleStep = s;
            this.didPropagate = p;
        }

        public Simulator getSource() {
            return this.source;
        }

        public boolean didTick() {
            return this.didTick;
        }

        public boolean didSingleStep() {
            return this.didSingleStep;
        }

        public boolean didPropagate() {
            return this.didPropagate;
        }
    }

    public static interface StatusListener {
        public void simulatorReset(Event var1);

        public void simulatorStateChanged(Event var1);
    }
}

