/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.data.Location;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WireSet {
    private static final Set<Wire> NULL_WIRES = Collections.emptySet();
    public static final WireSet EMPTY = new WireSet(NULL_WIRES);
    private final Set<Wire> wires;
    private final Set<Location> points;

    WireSet(Set<Wire> wires) {
        if (wires.isEmpty()) {
            this.wires = NULL_WIRES;
            this.points = Collections.emptySet();
        } else {
            this.wires = wires;
            this.points = new HashSet<Location>();
            for (Wire wire : wires) {
                this.points.add(wire.e0);
                this.points.add(wire.e1);
            }
        }
    }

    public boolean containsLocation(Location loc) {
        return this.points.contains(loc);
    }

    public boolean containsWire(Wire w) {
        return this.wires.contains(w);
    }
}

