/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public abstract class AppearanceElement
extends AbstractCanvasObject {
    private Location location;

    public AppearanceElement(Location location) {
        this.location = location;
    }

    @Override
    public boolean canRemove() {
        return false;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return Collections.emptyList();
    }

    protected Bounds getBounds(int radius) {
        return Bounds.create(this.location.getX() - radius, this.location.getY() - radius, 2 * radius, 2 * radius);
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public Location getRandomPoint(Bounds bds, Random rand) {
        return null;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        return null;
    }

    protected boolean isInCircle(Location loc, int radius) {
        int dy;
        int dx = loc.getX() - this.location.getX();
        return dx * dx + (dy = loc.getY() - this.location.getY()) * dy < radius * radius;
    }

    @Override
    public boolean matches(CanvasObject other) {
        if (other instanceof AppearanceElement) {
            AppearanceElement that = (AppearanceElement)other;
            return this.location.equals(that.location);
        }
        return false;
    }

    @Override
    public int matchesHashCode() {
        return this.location.hashCode();
    }

    @Override
    public void translate(int dx, int dy) {
        this.location = this.location.translate(dx, dy);
    }

    @Override
    protected void updateValue(Attribute<?> attr, Object value) {
    }
}

