/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.actions.ModelTranslateAction;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Drawing;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.CircuitAppearanceEvent;
import com.cburch.logisim.circuit.appear.CircuitAppearanceListener;
import com.cburch.logisim.circuit.appear.CircuitCustomAppearance;
import com.cburch.logisim.circuit.appear.CircuitPins;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.circuit.appear.DefaultCustomAppearance;
import com.cburch.logisim.circuit.appear.DefaultEvolutionAppearance;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementWithPoker;
import com.cburch.logisim.circuit.appear.PortManager;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.appear.CanvasActionAdapter;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CircuitAppearance
extends Drawing
implements AttributeListener {
    public static final int PIN_LENGTH = 10;
    private final Circuit circuit;
    private final EventSourceWeakSupport<CircuitAppearanceListener> listeners;
    private final PortManager portManager;
    private final CircuitPins circuitPins;
    private final MyListener myListener;
    private final ArrayList<CanvasObject> defaultCanvasObjects;
    private boolean suppressRecompute;
    private List<CanvasObject> defaultCustomAppearance;

    public CircuitAppearance(Circuit circuit) {
        this.circuit = circuit;
        this.listeners = new EventSourceWeakSupport();
        this.portManager = new PortManager(this);
        this.circuitPins = new CircuitPins(this.portManager);
        this.myListener = new MyListener();
        this.suppressRecompute = false;
        this.addCanvasModelListener(this.myListener);
        if (circuit != null) {
            circuit.getStaticAttributes().addAttributeListener(this);
        }
        this.defaultCanvasObjects = new ArrayList();
        this.recomputeDefaultAppearance();
        this.defaultCustomAppearance = DefaultCustomAppearance.build(this.circuitPins.getPins());
        this.setObjectsForce(this.defaultCustomAppearance, false);
    }

    public boolean hasCustomAppearance() {
        CanvasObject shape;
        ArrayList<CanvasObject> currentCustom = new ArrayList<CanvasObject>(this.getCustomObjectsFromBottom());
        ArrayList<CanvasObject> defaultCustom = new ArrayList<CanvasObject>(this.defaultCustomAppearance);
        Iterator<CanvasObject> shapeIterator = currentCustom.iterator();
        while (shapeIterator.hasNext()) {
            shape = shapeIterator.next();
            if (!(shape instanceof AppearancePort) && !(shape instanceof AppearanceAnchor)) continue;
            shapeIterator.remove();
        }
        shapeIterator = defaultCustom.iterator();
        while (shapeIterator.hasNext()) {
            shape = shapeIterator.next();
            if (!(shape instanceof AppearancePort) && !(shape instanceof AppearanceAnchor)) continue;
            shapeIterator.remove();
        }
        if (currentCustom.size() != defaultCustom.size()) {
            return true;
        }
        shapeIterator = currentCustom.iterator();
        while (shapeIterator.hasNext()) {
            CanvasObject currentShape = shapeIterator.next();
            boolean deleteIt = false;
            Iterator<CanvasObject> shapeDefaultIterator = defaultCustom.iterator();
            while (shapeDefaultIterator.hasNext()) {
                CanvasObject defaultShape = shapeDefaultIterator.next();
                boolean matches = currentShape.matches(defaultShape);
                deleteIt |= matches;
                if (!matches) continue;
                shapeDefaultIterator.remove();
            }
            if (!deleteIt) continue;
            shapeIterator.remove();
        }
        return !currentCustom.isEmpty();
    }

    public void resetDefaultCustomAppearance() {
        super.removeObjects(this.getCustomObjectsFromBottom());
        this.defaultCustomAppearance = DefaultCustomAppearance.build(this.circuitPins.getPins());
        this.setObjectsForce(this.defaultCustomAppearance, false);
    }

    public void loadDefaultLogisimAppearance() {
        super.removeObjects(this.getCustomObjectsFromBottom());
        this.defaultCustomAppearance.clear();
        this.setObjectsForce(DefaultEvolutionAppearance.build(this.circuitPins.getPins(), this.circuit.getName(), true), false);
    }

    public String getName() {
        return this.circuit == null || this.circuit.getStaticAttributes() == null ? null : this.circuit.getStaticAttributes().getValue(CircuitAttributes.NAME_ATTR);
    }

    public void addCircuitAppearanceListener(CircuitAppearanceListener l) {
        this.listeners.add(l);
    }

    public Drawing getCustomAppearanceDrawing() {
        return new CircuitCustomAppearance(this);
    }

    public void sortPinsList(List<Instance> pins, Direction facing) {
        DefaultAppearance.sortPinList(pins, facing);
    }

    @Override
    public void addObjects(int index, Collection<? extends CanvasObject> shapes) {
        super.addObjects(index, shapes);
        this.checkToFirePortsChanged(shapes);
    }

    @Override
    public void addObjects(Map<? extends CanvasObject, Integer> shapes) {
        super.addObjects(shapes);
        this.checkToFirePortsChanged(shapes.keySet());
    }

    private boolean affectsPorts(Collection<? extends CanvasObject> shapes) {
        for (CanvasObject canvasObject : shapes) {
            if (!(canvasObject instanceof AppearanceElement)) continue;
            return true;
        }
        return false;
    }

    private void checkToFirePortsChanged(Collection<? extends CanvasObject> shapes) {
        if (this.affectsPorts(shapes)) {
            this.recomputePorts();
        }
    }

    public boolean contains(Location loc) {
        Location query;
        AppearanceAnchor anchor = this.findAnchor();
        if (anchor == null) {
            query = loc;
        } else {
            Location anchorLoc = anchor.getLocation();
            query = loc.translate(anchorLoc.getX(), anchorLoc.getY());
        }
        for (CanvasObject obj : this.getObjectsFromBottom()) {
            if (obj instanceof AppearanceElement || !obj.contains(query, true)) continue;
            return true;
        }
        return false;
    }

    private AppearanceAnchor findAnchor() {
        for (CanvasObject shape : this.getObjectsFromBottom()) {
            if (!(shape instanceof AppearanceAnchor)) continue;
            AppearanceAnchor appAnchor = (AppearanceAnchor)shape;
            return appAnchor;
        }
        return null;
    }

    private Location findAnchorLocation() {
        AppearanceAnchor anchor = this.findAnchor();
        return anchor == null ? Location.create(100, 100, true) : anchor.getLocation();
    }

    void fireCircuitAppearanceChanged(int affected) {
        CircuitAppearanceEvent event = new CircuitAppearanceEvent(this.circuit, affected);
        for (CircuitAppearanceListener listener : this.listeners) {
            listener.circuitAppearanceChanged(event);
        }
    }

    public Bounds getAbsoluteBounds() {
        return this.getBounds(false);
    }

    private Bounds getBounds(boolean relativeToAnchor) {
        Bounds ret = null;
        Location offset = null;
        for (CanvasObject obj : this.getObjectsFromBottom()) {
            if (obj instanceof AppearanceElement) {
                AppearanceElement appEl = (AppearanceElement)obj;
                Location loc = appEl.getLocation();
                if (obj instanceof AppearanceAnchor) {
                    offset = loc;
                }
                ret = ret == null ? Bounds.create(loc) : ret.add(loc);
                continue;
            }
            ret = ret == null ? obj.getBounds() : ret.add(obj.getBounds());
        }
        if (ret == null) {
            return Bounds.EMPTY_BOUNDS;
        }
        if (relativeToAnchor && offset != null) {
            return ret.translate(-offset.getX(), -offset.getY());
        }
        return ret;
    }

    public CircuitPins getCircuitPins() {
        return this.circuitPins;
    }

    public AttributeOption getCircuitAppearance() {
        return this.circuit == null || this.circuit.getStaticAttributes() == null ? null : this.circuit.getStaticAttributes().getValue(CircuitAttributes.APPEARANCE_ATTR);
    }

    public Direction getFacing() {
        AppearanceAnchor anchor = this.findAnchor();
        return anchor == null ? Direction.EAST : anchor.getFacingDirection();
    }

    public Bounds getOffsetBounds() {
        return this.getBounds(true);
    }

    public SortedMap<Location, Instance> getPortOffsets(Direction facing) {
        Location anchor = null;
        Direction defaultFacing = Direction.EAST;
        ArrayList<AppearancePort> ports = new ArrayList<AppearancePort>();
        for (CanvasObject shape : this.getObjectsFromBottom()) {
            if (shape instanceof AppearancePort) {
                AppearancePort appPort = (AppearancePort)shape;
                ports.add(appPort);
                continue;
            }
            if (!(shape instanceof AppearanceAnchor)) continue;
            AppearanceAnchor appAnchor = (AppearanceAnchor)shape;
            anchor = appAnchor.getLocation();
            defaultFacing = appAnchor.getFacingDirection();
        }
        TreeMap<Location, Instance> ret = new TreeMap<Location, Instance>();
        for (AppearancePort port : ports) {
            Location loc = port.getLocation();
            if (anchor != null) {
                loc = loc.translate(-anchor.getX(), -anchor.getY());
            }
            if (facing != defaultFacing) {
                loc = loc.rotate(defaultFacing, facing, 0, 0);
            }
            ret.put(loc, port.getPin());
        }
        return ret;
    }

    public boolean isDefaultAppearance() {
        return this.circuit == null || !this.circuit.getStaticAttributes().getValue(CircuitAttributes.APPEARANCE_ATTR).equals(CircuitAttributes.APPEAR_CUSTOM);
    }

    public List<CanvasObject> getCustomObjectsFromBottom() {
        return super.getObjectsFromBottom();
    }

    @Override
    public List<CanvasObject> getObjectsFromBottom() {
        return this.isDefaultAppearance() ? Collections.unmodifiableList(this.defaultCanvasObjects) : super.getObjectsFromBottom();
    }

    @Override
    public List<CanvasObject> getObjectsFromTop() {
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>(this.getObjectsFromBottom());
        Collections.reverse(ret);
        return ret;
    }

    public void paintSubcircuit(InstancePainter painter, Graphics g, Direction facing) {
        Direction defaultFacing = this.getFacing();
        double rotate = 0.0;
        if (facing != defaultFacing && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            rotate = defaultFacing.toRadians() - facing.toRadians();
            g2d.rotate(rotate);
        }
        Location offset = this.findAnchorLocation();
        g.translate(-offset.getX(), -offset.getY());
        CircuitState state = null;
        if (painter.getShowState()) {
            try {
                state = (CircuitState)painter.getData();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        for (CanvasObject shape : this.getObjectsFromBottom()) {
            if (shape instanceof AppearanceElement) continue;
            Graphics dup = g.create();
            if (shape instanceof DynamicElement) {
                DynamicElement dynEl = (DynamicElement)shape;
                dynEl.paintDynamic(dup, state);
                if (shape instanceof DynamicElementWithPoker) {
                    DynamicElementWithPoker dynElWithPoker = (DynamicElementWithPoker)shape;
                    dynElWithPoker.setAnchor(offset);
                }
            } else {
                shape.paint(dup, null);
            }
            dup.dispose();
        }
        g.translate(offset.getX(), offset.getY());
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
    }

    public boolean isNamedBoxShapedFixedSize() {
        if (this.circuit == null || this.circuit.getStaticAttributes() == null) {
            return true;
        }
        AttributeSet staticAttrs = this.circuit.getStaticAttributes();
        return staticAttrs.containsAttribute(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE) ? staticAttrs.getValue(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE) : true;
    }

    public void recomputeDefaultAppearance() {
        List<CanvasObject> shapes = DefaultAppearance.build(this.circuitPins.getPins(), this.getCircuitAppearance(), this.isNamedBoxShapedFixedSize(), this.getName());
        this.setObjectsForce(shapes, true);
    }

    void recomputePorts() {
        if (this.isDefaultAppearance()) {
            this.recomputeDefaultAppearance();
        } else {
            this.fireCircuitAppearanceChanged(7);
        }
    }

    public void removeCircuitAppearanceListener(CircuitAppearanceListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void removeObjects(Collection<? extends CanvasObject> shapes) {
        super.removeObjects(shapes);
        this.checkToFirePortsChanged(shapes);
    }

    public void repairCustomAppearance(List<CanvasObject> oldCustomAppearanceElements, Project proj, Circuit circ) {
        ModelTranslateAction action;
        int dy;
        int dx;
        HashSet<CanvasObject> translates;
        AppearanceElement item;
        Iterator iterator;
        AppearanceElement element;
        ArrayList<CanvasObject> toBeRemoved = new ArrayList<CanvasObject>();
        ArrayList<CanvasObject> toBeAdded = new ArrayList<CanvasObject>();
        ArrayList<AppearanceElement> apearanceToBeRemoved = new ArrayList<AppearanceElement>();
        ArrayList<AppearanceElement> apearanceToBeAdded = new ArrayList<AppearanceElement>();
        for (CanvasObject canvasObject : this.getCustomObjectsFromBottom()) {
            if (canvasObject instanceof AppearanceElement) {
                element = (AppearanceElement)canvasObject;
                apearanceToBeRemoved.add(element);
                continue;
            }
            toBeRemoved.add(canvasObject);
        }
        for (CanvasObject canvasObject : oldCustomAppearanceElements) {
            if (canvasObject instanceof AppearanceElement) {
                element = (AppearanceElement)canvasObject;
                apearanceToBeAdded.add(element);
                continue;
            }
            toBeAdded.add(canvasObject);
        }
        block2: for (AppearanceElement appearanceElement : apearanceToBeRemoved) {
            if (!(appearanceElement instanceof AppearanceAnchor)) continue;
            AppearanceAnchor oldAnchor = (AppearanceAnchor)appearanceElement;
            iterator = apearanceToBeAdded.iterator();
            while (iterator.hasNext()) {
                item = (AppearanceElement)iterator.next();
                if (!(item instanceof AppearanceAnchor)) continue;
                AppearanceAnchor newAnchor = (AppearanceAnchor)item;
                translates = new HashSet<CanvasObject>();
                translates.add(oldAnchor);
                oldAnchor.setValue(AppearanceAnchor.FACING, newAnchor.getValue(AppearanceAnchor.FACING));
                dx = newAnchor.getLocation().getX() - oldAnchor.getLocation().getX();
                dy = newAnchor.getLocation().getY() - oldAnchor.getLocation().getY();
                action = new ModelTranslateAction(this, translates, dx, dy);
                proj.doAction(new CanvasActionAdapter(circ, action));
                iterator.remove();
                continue block2;
            }
        }
        block4: for (AppearanceElement appearanceElement : apearanceToBeRemoved) {
            if (!(appearanceElement instanceof AppearancePort)) continue;
            AppearancePort oldPort = (AppearancePort)appearanceElement;
            iterator = apearanceToBeAdded.iterator();
            while (iterator.hasNext()) {
                AppearancePort newPort;
                item = (AppearanceElement)iterator.next();
                if (!(item instanceof AppearancePort) || !(newPort = (AppearancePort)item).getPin().getLocation().equals(oldPort.getPin().getLocation())) continue;
                translates = new HashSet();
                translates.add(oldPort);
                dx = newPort.getLocation().getX() - oldPort.getLocation().getX();
                dy = newPort.getLocation().getY() - oldPort.getLocation().getY();
                action = new ModelTranslateAction(this, translates, dx, dy);
                proj.doAction(new CanvasActionAdapter(circ, action));
                iterator.remove();
                continue block4;
            }
        }
        this.removeObjects(toBeRemoved);
        this.addObjects(this.getCustomObjectsFromBottom().size() - 1, toBeAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicElement(InstanceComponent c) {
        ArrayList<CanvasObject> toRemove = new ArrayList<CanvasObject>();
        for (CanvasObject obj : super.getObjectsFromBottom()) {
            DynamicElement el;
            if (!(obj instanceof DynamicElement) || !(el = (DynamicElement)obj).getPath().contains(c)) continue;
            toRemove.add(obj);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        boolean oldSuppress = this.suppressRecompute;
        try {
            this.suppressRecompute = true;
            this.removeObjects(toRemove);
        }
        finally {
            this.suppressRecompute = oldSuppress;
        }
        this.fireCircuitAppearanceChanged(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceAutomatically(List<AppearancePort> removes, List<AppearancePort> adds) {
        boolean oldSuppress = this.suppressRecompute;
        try {
            this.suppressRecompute = true;
            boolean hasCustom = this.hasCustomAppearance();
            if (hasCustom) {
                this.defaultCustomAppearance = DefaultCustomAppearance.build(this.circuitPins.getPins());
                this.removeObjects(removes);
                this.addObjects(this.getCustomObjectsFromBottom().size() - 1, adds);
            } else {
                super.removeObjects(this.getCustomObjectsFromBottom());
                this.defaultCustomAppearance = DefaultCustomAppearance.build(this.circuitPins.getPins());
                this.setObjectsForce(this.defaultCustomAppearance, false);
            }
        }
        finally {
            this.suppressRecompute = oldSuppress;
        }
        this.fireCircuitAppearanceChanged(7);
    }

    public void setObjectsForce(List<? extends CanvasObject> shapesBase) {
        this.setObjectsForce(shapesBase, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectsForce(List<? extends CanvasObject> shapesBase, boolean isDefault) {
        int nrOfShapes = shapesBase.size();
        ArrayList<CanvasObject> shapes = new ArrayList<CanvasObject>(nrOfShapes);
        int end = nrOfShapes - 1;
        for (int shapeCount = 0; shapeCount < nrOfShapes; ++shapeCount) {
            shapes.add(shapesBase.get(shapeCount).clone());
        }
        int reserved = 0;
        for (int shapeIndex = end; shapeIndex >= 0; --shapeIndex) {
            CanvasObject obj = (CanvasObject)shapes.get(shapeIndex);
            if (obj instanceof AppearanceAnchor) {
                if (shapeIndex != end) {
                    shapes.remove(shapeIndex);
                    shapes.add(obj);
                }
                ++reserved;
                continue;
            }
            if (!(obj instanceof AppearancePort)) continue;
            if (shapeIndex != end - reserved) {
                shapes.remove(shapeIndex);
                shapes.add(end - reserved, obj);
            }
            ++reserved;
        }
        try {
            this.suppressRecompute = true;
            if (isDefault) {
                this.defaultCanvasObjects.clear();
                this.defaultCanvasObjects.addAll(shapes);
            } else {
                super.removeObjects(new ArrayList<CanvasObject>(this.getCustomObjectsFromBottom()));
                super.addObjects(0, shapes);
            }
        }
        finally {
            this.suppressRecompute = false;
        }
        this.fireCircuitAppearanceChanged(7);
    }

    @Override
    public void translateObjects(Collection<? extends CanvasObject> shapes, int dx, int dy) {
        super.translateObjects(shapes, dx, dy);
        this.checkToFirePortsChanged(shapes);
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        if (e.getAttribute() == CircuitAttributes.APPEARANCE_ATTR && (e.getValue() == CircuitAttributes.APPEAR_CLASSIC || e.getValue() == CircuitAttributes.APPEAR_FPGA || e.getValue() == CircuitAttributes.APPEAR_EVOLUTION)) {
            this.recomputeDefaultAppearance();
        }
    }

    private class MyListener
    implements CanvasModelListener {
        private MyListener() {
        }

        @Override
        public void modelChanged(CanvasModelEvent event) {
            if (!CircuitAppearance.this.suppressRecompute) {
                CircuitAppearance.this.fireCircuitAppearanceChanged(7);
            }
        }
    }
}

