/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.instance.InstanceComponent;
import java.util.HashSet;
import java.util.LinkedList;

public interface DynamicElementProvider {
    public DynamicElement createDynamicElement(int var1, int var2, DynamicElement.Path var3);

    public static void removeDynamicElements(Circuit circuit, Component comp) {
        if (!(comp instanceof InstanceComponent)) {
            return;
        }
        HashSet<Circuit> allAffected = new HashSet<Circuit>();
        LinkedList<Circuit> todo = new LinkedList<Circuit>();
        todo.add(circuit);
        while (!todo.isEmpty()) {
            Circuit circ = (Circuit)todo.remove();
            if (allAffected.contains(circ)) continue;
            allAffected.add(circ);
            for (Circuit other : circ.getCircuitsUsingThis()) {
                if (allAffected.contains(other)) continue;
                todo.add(other);
            }
        }
        for (Circuit circ : allAffected) {
            circ.getAppearance().removeDynamicElement((InstanceComponent)comp);
        }
    }
}

