/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class TestVector {
    public static final FileFilter FILE_FILTER = new TestVectorFilter();
    public String[] columnName;
    public BitWidth[] columnWidth;
    public int[] columnRadix;
    public List<Value[]> data;

    public TestVector(File src) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(src));){
            TestVectorReader r = new TestVectorReader(in);
            r.parse();
        }
    }

    public TestVector(String filename) throws IOException {
        this(new File(filename));
    }

    private class TestVectorReader {
        private final BufferedReader in;
        private StringTokenizer curLine;

        public TestVectorReader(BufferedReader in) throws IOException {
            this.in = in;
            this.curLine = this.findNonemptyLine();
        }

        private StringTokenizer findNonemptyLine() throws IOException {
            String line = this.in.readLine();
            while (line != null) {
                StringTokenizer ret;
                int i = line.indexOf(35);
                if (i >= 0) {
                    line = line.substring(0, i);
                }
                if ((ret = new StringTokenizer(line)).hasMoreTokens()) {
                    return ret;
                }
                line = this.in.readLine();
            }
            return null;
        }

        public void parse() throws IOException {
            if (this.curLine == null) {
                throw new IOException("TestVector format error: empty file");
            }
            this.parseHeader();
            TestVector.this.data = new ArrayList<Value[]>();
            this.curLine = this.findNonemptyLine();
            while (this.curLine != null) {
                this.parseData();
                this.curLine = this.findNonemptyLine();
            }
        }

        private void parseData() throws IOException {
            Value[] vals = new Value[TestVector.this.columnName.length];
            for (int i = 0; i < TestVector.this.columnName.length; ++i) {
                String t = this.curLine.nextToken();
                try {
                    vals[i] = Value.fromLogString(TestVector.this.columnWidth[i], t);
                }
                catch (Exception e) {
                    throw new IOException("Test Vector data format error: " + e.getMessage());
                }
                if (!TestVector.this.data.isEmpty()) continue;
                TestVector.this.columnRadix[i] = Value.radixOfLogString(TestVector.this.columnWidth[i], t);
            }
            if (this.curLine.hasMoreTokens()) {
                throw new IOException("Test Vector data format error: " + this.curLine.nextToken());
            }
            TestVector.this.data.add(vals);
        }

        private void parseHeader() throws IOException {
            int n = this.curLine.countTokens();
            TestVector.this.columnName = new String[n];
            TestVector.this.columnWidth = new BitWidth[n];
            TestVector.this.columnRadix = new int[n];
            for (int i = 0; i < n; ++i) {
                TestVector.this.columnRadix[i] = 2;
                String t = (String)this.curLine.nextElement();
                int s = t.indexOf(91);
                if (s < 0) {
                    TestVector.this.columnName[i] = t;
                    TestVector.this.columnWidth[i] = BitWidth.ONE;
                    continue;
                }
                int e = t.indexOf(93);
                if (e != t.length() - 1 || s == 0 || e == s + 1) {
                    throw new IOException("Test Vector header format error: bad spec: " + t);
                }
                TestVector.this.columnName[i] = t.substring(0, s);
                int w = 0;
                try {
                    w = Integer.parseInt(t.substring(s + 1, e));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (w < 1 || w > 64) {
                    throw new IOException("Test Vector header format error: bad width: " + t);
                }
                TestVector.this.columnWidth[i] = BitWidth.create(w);
            }
        }
    }

    private static class TestVectorFilter
    extends FileFilter {
        private TestVectorFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (!f.isFile()) {
                return true;
            }
            String name = f.getName();
            int i = name.lastIndexOf(46);
            return i > 0 && name.substring(i).equalsIgnoreCase(".txt");
        }

        @Override
        public String getDescription() {
            return "Logisim-evolution Test Vector (*.txt)";
        }
    }
}

