/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlIterator<E extends Node>
implements Iterable<E>,
Iterator<E>,
Cloneable {
    private final NodeList list;
    private int index;

    public XmlIterator(NodeList nodes) {
        this.list = nodes;
        this.index = 0;
    }

    public static Iterable<Element> forChildElements(Element node) {
        NodeList nodes = node.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node sub = nodes.item(i);
            if (sub.getNodeType() != 1) continue;
            ret.add((Element)sub);
        }
        return ret;
    }

    public static Iterable<Element> forChildElements(Element node, String tagName) {
        NodeList nodes = node.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Element elt;
            Node sub = nodes.item(i);
            if (sub.getNodeType() != 1 || !(elt = (Element)sub).getTagName().equals(tagName)) continue;
            ret.add(elt);
        }
        return ret;
    }

    public static XmlIterator<Node> forChildren(Element node) {
        return new XmlIterator<Node>(node.getChildNodes());
    }

    public static Iterable<Element> forDescendantElements(Element node, String tagName) {
        return new XmlIterator<Element>(node.getElementsByTagName(tagName));
    }

    public XmlIterator<E> clone() {
        try {
            XmlIterator ret = (XmlIterator)super.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    @Override
    public boolean hasNext() {
        return this.list != null && this.index < this.list.getLength();
    }

    @Override
    public Iterator<E> iterator() {
        Object ret = this.clone();
        ((XmlIterator)ret).index = 0;
        return ret;
    }

    @Override
    public E next() {
        Node ret = this.list.item(this.index);
        if (ret == null) {
            throw new NoSuchElementException();
        }
        ++this.index;
        Node ret2 = ret;
        return (E)ret2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("XmlChildIterator.remove");
    }
}

