/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ComponentMapParser {
    private File fileToPase = null;
    private MappableResourcesContainer mappableComponents = null;
    private BoardInformation boardInfo = null;
    private final String[] MapSectionStrings = new String[]{"Key", "LocationX", "LocationY", "Width", "Height"};
    private static final int WrongCircuit = -1;
    private static final int WrongBoard = -2;
    private static final int ErrorCreatingDocument = -3;
    private static final int ErrorParsingFile = -4;

    public ComponentMapParser(File file, MappableResourcesContainer mapResContainer, BoardInformation brdInfo) {
        this.fileToPase = file;
        this.mappableComponents = mapResContainer;
        this.boardInfo = brdInfo;
    }

    private void unMapAll() {
        this.mappableComponents.unMapAll();
        this.mappableComponents.updateMapableComponents();
    }

    public String getError(int error) {
        return switch (error) {
            case -1 -> Strings.S.get("BoardMapWrongCircuit");
            case -2 -> Strings.S.get("BoardMapWrongBoard");
            case -3 -> Strings.S.get("BoardMapErrorCD");
            case -4 -> Strings.S.get("BoardMapErrorPF");
            default -> Strings.S.get("BoardMapUnknown");
        };
    }

    public int parseFile() {
        int i;
        NodeList nodeList = null;
        String absoluteFileName = this.fileToPase.getPath();
        DocumentBuilderFactory factory = XmlUtil.getHardenedBuilderFactory();
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return -3;
        }
        File xml = new File(absoluteFileName);
        Document mapDoc = null;
        try {
            mapDoc = parser.parse(xml);
        }
        catch (IOException | SAXException e) {
            return -4;
        }
        nodeList = mapDoc.getElementsByTagName("LogisimGoesFPGABoardMapInformation");
        Node circuitInfo = nodeList.item(0);
        NodeList circuitInfoDetails = circuitInfo.getChildNodes();
        for (i = 0; i < circuitInfoDetails.getLength(); ++i) {
            if (!circuitInfoDetails.item(i).getNodeName().equals("GlobalMapInformation")) continue;
            NamedNodeMap attrs = circuitInfoDetails.item(i).getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                if (attrs.item(j).getNodeName().equals("BoardName")) {
                    if (this.boardInfo.getBoardName().equals(attrs.item(j).getNodeValue())) continue;
                    return -2;
                }
                if (!attrs.item(j).getNodeName().equals("ToplevelCircuitName") || this.mappableComponents.getToplevelName().equals(attrs.item(j).getNodeValue())) continue;
                return -1;
            }
            break;
        }
        this.unMapAll();
        for (i = 0; i < circuitInfoDetails.getLength(); ++i) {
            if (!circuitInfoDetails.item(i).getNodeName().startsWith("MAPPEDCOMPONENT")) continue;
            int x = -1;
            int y = -1;
            int width = -1;
            int height = -1;
            String key = "";
            NamedNodeMap attrs = circuitInfoDetails.item(i).getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                if (attrs.item(j).getNodeName().equals(this.MapSectionStrings[0])) {
                    key = attrs.item(j).getNodeValue();
                }
                if (attrs.item(j).getNodeName().equals(this.MapSectionStrings[1])) {
                    x = Integer.parseInt(attrs.item(j).getNodeValue());
                }
                if (attrs.item(j).getNodeName().equals(this.MapSectionStrings[2])) {
                    y = Integer.parseInt(attrs.item(j).getNodeValue());
                }
                if (attrs.item(j).getNodeName().equals(this.MapSectionStrings[3])) {
                    width = Integer.parseInt(attrs.item(j).getNodeValue());
                }
                if (!attrs.item(j).getNodeName().equals(this.MapSectionStrings[4])) continue;
                height = Integer.parseInt(attrs.item(j).getNodeValue());
            }
            if (key.isEmpty() || x <= 0 || y <= 0 || width <= 0 || height <= 0) continue;
            BoardRectangle rect = null;
            for (FpgaIoInformationContainer comp : this.boardInfo.getAllComponents()) {
                if (comp.getRectangle().getXpos() != x || comp.getRectangle().getYpos() != y || comp.getRectangle().getWidth() != width || comp.getRectangle().getHeight() != height) continue;
                rect = comp.getRectangle();
                break;
            }
            if (rect == null) continue;
            this.mappableComponents.tryMap(key, rect);
        }
        return 0;
    }
}

