/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPointArray;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Net {
    private final Set<Location> myPoints = new HashSet<Location>();
    private final Set<String> tunnelNames = new HashSet<String>();
    private final Set<Wire> segments = new HashSet<Wire>();
    private int nrOfBits;
    private Net myParent;
    private Boolean requiresToBeRoot;
    private final ArrayList<Byte> inheritedBits = new ArrayList();
    private final ArrayList<ConnectionPointArray> sourceList = new ArrayList();
    private final ArrayList<ConnectionPointArray> sinkList = new ArrayList();
    private final ArrayList<ConnectionPointArray> sourceNetsList = new ArrayList();
    private final ArrayList<ConnectionPointArray> sinkNetsList = new ArrayList();

    public Net() {
        this.cleanup();
    }

    public Net(Location loc) {
        this.cleanup();
        this.myPoints.add(loc);
    }

    public Net(Location loc, int width) {
        this.cleanup();
        this.myPoints.add(loc);
        this.nrOfBits = width;
    }

    public void add(Wire segment) {
        this.myPoints.add(segment.getEnd0());
        this.myPoints.add(segment.getEnd1());
        this.segments.add(segment);
    }

    public Set<Wire> getWires() {
        return this.segments;
    }

    public boolean addParentBit(byte bitId) {
        if (bitId < 0) {
            return false;
        }
        this.inheritedBits.add(bitId);
        return true;
    }

    public boolean addSink(int bitIndex, ConnectionPoint sink) {
        if (bitIndex < 0 || bitIndex >= this.sinkList.size()) {
            return false;
        }
        this.sinkList.get(bitIndex).add(sink);
        return true;
    }

    public boolean addSinkNet(int bitIndex, ConnectionPoint sinkNet) {
        if (bitIndex < 0 || bitIndex >= this.sinkNetsList.size()) {
            return false;
        }
        this.sinkNetsList.get(bitIndex).add(sinkNet);
        return true;
    }

    public boolean addSource(int bitIndex, ConnectionPoint source) {
        if (bitIndex < 0 || bitIndex >= this.sourceList.size()) {
            return false;
        }
        this.sourceList.get(bitIndex).add(source);
        return true;
    }

    public boolean addSourceNet(int bitIndex, ConnectionPoint sourceNet) {
        if (bitIndex < 0 || bitIndex >= this.sourceNetsList.size()) {
            return false;
        }
        this.sourceNetsList.get(bitIndex).add(sourceNet);
        return true;
    }

    public void addTunnel(String tunnelName) {
        this.tunnelNames.add(tunnelName);
    }

    public int getBitWidth() {
        return this.nrOfBits;
    }

    private void cleanup() {
        this.myPoints.clear();
        this.segments.clear();
        this.tunnelNames.clear();
        this.nrOfBits = 0;
        this.myParent = null;
        this.requiresToBeRoot = false;
        this.inheritedBits.clear();
        this.sourceList.clear();
        this.sinkList.clear();
        this.sourceNetsList.clear();
        this.sinkNetsList.clear();
    }

    public boolean contains(Location point) {
        return this.myPoints.contains(point);
    }

    public boolean containsTunnel(String tunnelName) {
        return this.tunnelNames.contains(tunnelName);
    }

    public void forceRootNet() {
        this.myParent = null;
        this.requiresToBeRoot = true;
        this.inheritedBits.clear();
    }

    public byte getBit(byte bit) {
        if (bit < 0 || bit >= this.inheritedBits.size() || this.isRootNet()) {
            return -1;
        }
        return this.inheritedBits.get(bit);
    }

    public Net getParent() {
        return this.myParent;
    }

    public Set<Location> getPoints() {
        return this.myPoints;
    }

    public List<ConnectionPoint> getSinkNets(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.sinkNetsList.size()) {
            return new ArrayList<ConnectionPoint>();
        }
        return this.sinkNetsList.get(bitIndex).getAll();
    }

    public List<ConnectionPoint> getSourceNets(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.sourceNetsList.size()) {
            return new ArrayList<ConnectionPoint>();
        }
        return this.sourceNetsList.get(bitIndex).getAll();
    }

    public void cleanupSourceNets(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.sourceNetsList.size()) {
            return;
        }
        List<ConnectionPoint> oldconns = this.sourceNetsList.get(bitIndex).getAll();
        if (oldconns.size() > 1) {
            ConnectionPoint point = oldconns.get(0);
            this.sourceNetsList.get(bitIndex).clear();
            this.sourceNetsList.get(bitIndex).add(point);
        }
    }

    public boolean hasBitSinks(int bitid) {
        return bitid < 0 || bitid >= this.sinkList.size() ? false : this.sinkList.get(bitid).size() > 0;
    }

    public List<ConnectionPoint> getBitSinks(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.sourceNetsList.size()) {
            return new ArrayList<ConnectionPoint>();
        }
        return new ArrayList<ConnectionPoint>(this.sinkList.get(bitIndex).getAll());
    }

    public List<ConnectionPoint> getBitSources(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.sourceNetsList.size()) {
            return null;
        }
        return this.sourceList.get(bitIndex).getAll();
    }

    public boolean hasBitSource(int bitid) {
        return bitid < 0 || bitid >= this.sourceList.size() ? false : this.sourceList.get(bitid).size() > 0;
    }

    public boolean hasShortCircuit() {
        boolean ret = false;
        for (int i = 0; i < this.nrOfBits; ++i) {
            ret |= this.sourceList.get(i).size() > 1;
        }
        return ret;
    }

    public boolean hasSinks() {
        boolean ret = false;
        for (int i = 0; i < this.nrOfBits; ++i) {
            ret |= this.sinkList.get(i).size() > 0;
        }
        return ret;
    }

    public Set<ConnectionPoint> getSinks() {
        HashSet<ConnectionPoint> sinks = new HashSet<ConnectionPoint>();
        for (int i = 0; i < this.nrOfBits; ++i) {
            sinks.addAll(this.sinkList.get(i).getAll());
        }
        return sinks;
    }

    public boolean hasSource() {
        boolean ret = false;
        for (int i = 0; i < this.nrOfBits; ++i) {
            ret |= this.sourceList.get(i).size() > 0;
        }
        return ret;
    }

    public boolean hasTunnel() {
        return this.tunnelNames.size() != 0;
    }

    public void initializeSourceSinks() {
        this.sourceList.clear();
        this.sinkList.clear();
        this.sourceNetsList.clear();
        this.sinkNetsList.clear();
        for (int i = 0; i < this.nrOfBits; ++i) {
            this.sourceList.add(new ConnectionPointArray());
            this.sinkList.add(new ConnectionPointArray());
            this.sourceNetsList.add(new ConnectionPointArray());
            this.sinkNetsList.add(new ConnectionPointArray());
        }
    }

    public boolean isBus() {
        return this.nrOfBits > 1;
    }

    public boolean isEmpty() {
        return this.myPoints.isEmpty();
    }

    public boolean isForcedRootNet() {
        return this.requiresToBeRoot;
    }

    public boolean isRootNet() {
        return this.myParent == null || this.requiresToBeRoot != false;
    }

    public boolean merge(Net theNet) {
        if (theNet.getBitWidth() == this.nrOfBits) {
            this.myPoints.addAll(theNet.getPoints());
            this.segments.addAll(theNet.getWires());
            this.tunnelNames.addAll(theNet.getTunnelNames());
            return true;
        }
        return false;
    }

    public boolean setWidth(int width) {
        if (this.nrOfBits > 0 && width != this.nrOfBits) {
            return false;
        }
        this.nrOfBits = width;
        return true;
    }

    public boolean setParent(Net parent) {
        if (this.requiresToBeRoot.booleanValue()) {
            return false;
        }
        if (parent == null) {
            return false;
        }
        if (this.myParent != null) {
            return false;
        }
        this.myParent = parent;
        return true;
    }

    public Set<String> getTunnelNames() {
        return this.tunnelNames;
    }
}

