/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.file;

import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.FpgaClass;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.file.BoardWriterClass;
import com.cburch.logisim.fpga.file.ImageXmlFactory;
import com.cburch.logisim.fpga.gui.DialogNotification;
import com.cburch.logisim.util.XmlUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoardReaderClass {
    static final Logger logger = LoggerFactory.getLogger(BoardReaderClass.class);
    private final String myfilename;
    private DocumentBuilderFactory factory;
    private DocumentBuilder parser;
    private Document BoardDoc;

    public BoardReaderClass(String filename) {
        this.myfilename = filename;
    }

    private BufferedImage createImage(int width, int height, String[] CodeTable, String PixelData) {
        ImageXmlFactory reader = new ImageXmlFactory();
        reader.setCodeTable(CodeTable);
        reader.setCompressedString(PixelData);
        return reader.getPicture(width, height);
    }

    public BoardInformation getBoardInformation() {
        try {
            this.factory = XmlUtil.getHardenedBuilderFactory();
            this.parser = this.factory.newDocumentBuilder();
            if (this.myfilename.startsWith("url:")) {
                xml = this.getClass().getResourceAsStream("/" + this.myfilename.substring("url:".length()));
                this.BoardDoc = this.parser.parse((InputStream)xml);
            } else if (this.myfilename.startsWith("file:")) {
                xml = new File(this.myfilename.substring("file:".length()));
                this.BoardDoc = this.parser.parse((File)xml);
            } else {
                xml = new File(this.myfilename);
                this.BoardDoc = this.parser.parse((File)xml);
            }
            NodeList ImageList = this.BoardDoc.getElementsByTagName("BoardPicture");
            if (ImageList.getLength() != 1) {
                return null;
            }
            Node ThisImage = ImageList.item(0);
            NodeList ImageParameters = ThisImage.getChildNodes();
            String[] CodeTable = null;
            String PixelData = null;
            int PictureWidth = 0;
            int PictureHeight = 0;
            for (int i = 0; i < ImageParameters.getLength(); ++i) {
                int j;
                if (ImageParameters.item(i).getNodeName().equals("CompressionCodeTable")) {
                    NamedNodeMap TableAttrs = ImageParameters.item(i).getAttributes();
                    for (j = 0; j < TableAttrs.getLength(); ++j) {
                        if (!TableAttrs.item(j).getNodeName().equals("TableData")) continue;
                        String CodeTableStr = TableAttrs.item(j).getNodeValue();
                        CodeTable = CodeTableStr.split(" ");
                    }
                }
                if (ImageParameters.item(i).getNodeName().equals("PictureDimension")) {
                    NamedNodeMap SizeAttrs = ImageParameters.item(i).getAttributes();
                    for (j = 0; j < SizeAttrs.getLength(); ++j) {
                        if (SizeAttrs.item(j).getNodeName().equals("Width")) {
                            PictureWidth = Integer.parseInt(SizeAttrs.item(j).getNodeValue());
                        }
                        if (!SizeAttrs.item(j).getNodeName().equals("Height")) continue;
                        PictureHeight = Integer.parseInt(SizeAttrs.item(j).getNodeValue());
                    }
                }
                if (!ImageParameters.item(i).getNodeName().equals("PixelData")) continue;
                NamedNodeMap PixelAttrs = ImageParameters.item(i).getAttributes();
                for (j = 0; j < PixelAttrs.getLength(); ++j) {
                    if (!PixelAttrs.item(j).getNodeName().equals("PixelRGB")) continue;
                    PixelData = PixelAttrs.item(j).getNodeValue();
                }
            }
            if (CodeTable == null) {
                DialogNotification.showDialogNotification(null, "Error", "The selected XML file does not contain a compression code table");
                return null;
            }
            if (PictureWidth == 0 || PictureHeight == 0) {
                DialogNotification.showDialogNotification(null, "Error", "The selected XML file does not contain the picture dimensions");
                return null;
            }
            if (PixelData == null) {
                DialogNotification.showDialogNotification(null, "Error", "The selected XML file does not contain the picture data");
                return null;
            }
            BoardInformation result = new BoardInformation();
            result.setBoardName(this.BoardDoc.getDocumentElement().getNodeName());
            BufferedImage Picture = this.createImage(PictureWidth, PictureHeight, CodeTable, PixelData);
            if (Picture == null) {
                return null;
            }
            result.setImage(Picture);
            FpgaClass FPGA = this.getFpgaInfo();
            if (FPGA == null) {
                return null;
            }
            result.fpga = FPGA;
            NodeList CompList = this.BoardDoc.getElementsByTagName("PinsInformation");
            this.processComponentList(CompList, result);
            CompList = this.BoardDoc.getElementsByTagName("ButtonsInformation");
            this.processComponentList(CompList, result);
            CompList = this.BoardDoc.getElementsByTagName("LEDsInformation");
            this.processComponentList(CompList, result);
            CompList = this.BoardDoc.getElementsByTagName("IOComponents");
            this.processComponentList(CompList, result);
            return result;
        }
        catch (Exception e) {
            logger.error("Exceptions not handled yet in GetBoardInformation(), but got an exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    private FpgaClass getFpgaInfo() {
        NodeList fpgaList = this.BoardDoc.getElementsByTagName("BoardInformation");
        long frequency = -1L;
        String clockPin = null;
        String clockPull = null;
        String clockStand = null;
        String unusedPull = null;
        String vendor = null;
        String part = null;
        String family = null;
        String Package2 = null;
        String speed = null;
        String usbTmc = null;
        String jtagPos = null;
        String flashName = null;
        String flashPos = null;
        if (fpgaList.getLength() != 1) {
            return null;
        }
        Node thisFpga = fpgaList.item(0);
        NodeList fpgaParams = thisFpga.getChildNodes();
        for (int i = 0; i < fpgaParams.getLength(); ++i) {
            int j;
            if (fpgaParams.item(i).getNodeName().equals("ClockInformation")) {
                NamedNodeMap clockAttrs = fpgaParams.item(i).getAttributes();
                for (j = 0; j < clockAttrs.getLength(); ++j) {
                    if (clockAttrs.item(j).getNodeName().equals(BoardWriterClass.CLOCK_SECTION_STRINGS[0])) {
                        frequency = Long.parseLong(clockAttrs.item(j).getNodeValue());
                    }
                    if (clockAttrs.item(j).getNodeName().equals(BoardWriterClass.CLOCK_SECTION_STRINGS[1])) {
                        clockPin = clockAttrs.item(j).getNodeValue();
                    }
                    if (clockAttrs.item(j).getNodeName().equals(BoardWriterClass.CLOCK_SECTION_STRINGS[2])) {
                        clockPull = clockAttrs.item(j).getNodeValue();
                    }
                    if (!clockAttrs.item(j).getNodeName().equals(BoardWriterClass.CLOCK_SECTION_STRINGS[3])) continue;
                    clockStand = clockAttrs.item(j).getNodeValue();
                }
            }
            if (fpgaParams.item(i).getNodeName().equals("UnusedPins")) {
                NamedNodeMap unusedAttrs = fpgaParams.item(i).getAttributes();
                for (j = 0; j < unusedAttrs.getLength(); ++j) {
                    if (!unusedAttrs.item(j).getNodeName().equals("PullBehavior")) continue;
                    unusedPull = unusedAttrs.item(j).getNodeValue();
                }
            }
            if (!fpgaParams.item(i).getNodeName().equals("FPGAInformation")) continue;
            NamedNodeMap fpgaAttrs = fpgaParams.item(i).getAttributes();
            for (j = 0; j < fpgaAttrs.getLength(); ++j) {
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[0])) {
                    vendor = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[1])) {
                    part = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[2])) {
                    family = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[3])) {
                    Package2 = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[4])) {
                    speed = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[5])) {
                    usbTmc = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[6])) {
                    jtagPos = fpgaAttrs.item(j).getNodeValue();
                }
                if (fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[7])) {
                    flashName = fpgaAttrs.item(j).getNodeValue();
                }
                if (!fpgaAttrs.item(j).getNodeName().equals(BoardWriterClass.FPGA_SECTION_STRINGS[8])) continue;
                flashPos = fpgaAttrs.item(j).getNodeValue();
            }
        }
        if (frequency < 0L || clockPin == null || clockPull == null || clockStand == null || unusedPull == null || vendor == null || part == null || family == null || Package2 == null || speed == null) {
            DialogNotification.showDialogNotification(null, "Error", "The selected xml file does not contain the required FPGA parameters");
            return null;
        }
        if (usbTmc == null) {
            usbTmc = Boolean.toString(false);
        }
        if (jtagPos == null) {
            jtagPos = "1";
        }
        if (flashPos == null) {
            flashPos = "2";
        }
        FpgaClass result = new FpgaClass();
        result.set(frequency, clockPin, clockPull, clockStand, family, part, Package2, speed, vendor, unusedPull, usbTmc.equals(Boolean.toString(true)), jtagPos, flashName, flashPos);
        return result;
    }

    private void processComponentList(NodeList compList, BoardInformation board) {
        Node tempNode = null;
        if (compList.getLength() == 1) {
            tempNode = compList.item(0);
            compList = tempNode.getChildNodes();
            for (int i = 0; i < compList.getLength(); ++i) {
                FpgaIoInformationContainer newComp = new FpgaIoInformationContainer(compList.item(i));
                if (!newComp.isKnownComponent()) continue;
                board.addComponent(newComp);
            }
        }
    }
}

