/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class BoardIcon
implements Icon {
    private Image image;
    private static final int ICON_WIDTH = 240;
    private static final int ICON_HEIGHT = 130;

    public BoardIcon(BufferedImage boardImage) {
        this.image = boardImage == null ? null : boardImage.getScaledInstance(this.getIconWidth(), this.getIconHeight(), 4);
    }

    @Override
    public int getIconHeight() {
        return AppPreferences.getScaled(130);
    }

    @Override
    public int getIconWidth() {
        return AppPreferences.getScaled(240);
    }

    @Override
    public void paintIcon(Component comp, Graphics gfx, int x, int y) {
        if (this.image != null) {
            gfx.drawImage(this.image, x, y, null);
        } else {
            gfx.setColor(Color.gray);
            gfx.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }
    }

    public void setImage(BufferedImage boardImage) {
        this.image = boardImage == null ? null : boardImage.getScaledInstance(this.getIconWidth(), this.getIconHeight(), 4);
    }
}

