/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseListDataListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.fpga.data.FpgaCommanderListModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;

public class FpgaCommanderListWindow
extends JFrame
implements BaseWindowListenerContract,
BaseListDataListenerContract {
    private final String Title;
    private final JList<Object> textArea = new JList();
    private boolean IsActive = false;
    private final boolean count;
    private final FpgaCommanderListModel model;
    private final JScrollPane textMessages;

    public FpgaCommanderListWindow(String Title2, Color fg, boolean count, FpgaCommanderListModel model) {
        super((String)(count ? Title2 + " (" + model.getCountNr() + ")" : Title2));
        this.Title = Title2;
        this.setResizable(true);
        this.setAlwaysOnTop(false);
        this.setDefaultCloseOperation(1);
        Color bg = Color.black;
        this.textArea.setBackground(bg);
        this.textArea.setForeground(fg);
        this.textArea.setSelectionBackground(fg);
        this.textArea.setSelectionForeground(bg);
        this.textArea.setFont(new Font("monospaced", 0, 14));
        this.textArea.setModel(model);
        this.textArea.setCellRenderer(model.getMyRenderer());
        this.textArea.setSelectionMode(0);
        model.addListDataListener(this);
        this.textMessages = new JScrollPane(this.textArea);
        this.textMessages.setVerticalScrollBarPolicy(20);
        this.textMessages.setHorizontalScrollBarPolicy(30);
        this.add(this.textMessages);
        this.setLocationRelativeTo(null);
        this.pack();
        this.addWindowListener(this);
        this.count = count;
        this.model = model;
    }

    public boolean isActivated() {
        return this.IsActive;
    }

    public JList<Object> getListObject() {
        return this.textArea;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.IsActive = false;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.IsActive = true;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.setTitle((String)(this.count ? this.Title + " (" + this.model.getCountNr() + ")" : this.Title));
        this.revalidate();
        this.repaint();
    }
}

