/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.designrulecheck.SimpleDrcContainer;
import com.cburch.logisim.gui.icons.DrcIcon;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ListModelCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private static final long serialVersionUID = 1L;
    private final boolean CountLines;
    private static final Color FATAL = Color.RED;
    private static final Color SEVERE = Color.yellow;
    private static final Color NORMAL = Color.LIGHT_GRAY;
    private static final Color ADDENDUM = Color.GRAY;
    private static final DrcIcon NoDRC = new DrcIcon(false);
    private static final DrcIcon DRCError = new DrcIcon(true);

    public ListModelCellRenderer(boolean countLines) {
        this.CountLines = countLines;
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SimpleDrcContainer msg = null;
        this.setBackground(list.getBackground());
        this.setForeground(list.getForeground());
        StringBuilder Line2 = new StringBuilder();
        if (value instanceof SimpleDrcContainer) {
            SimpleDrcContainer cont;
            msg = cont = (SimpleDrcContainer)value;
        }
        this.setIcon(msg != null && msg.isDrcInfoPresent() ? DRCError : NoDRC);
        if (msg != null) {
            switch (msg.getSeverity()) {
                case 2: {
                    this.setForeground(SEVERE);
                    break;
                }
                case 3: {
                    this.setBackground(FATAL);
                    this.setForeground(list.getBackground());
                    break;
                }
                default: {
                    this.setForeground(NORMAL);
                }
            }
        }
        if (value.toString().contains("BUG")) {
            this.setBackground(Color.MAGENTA);
            this.setForeground(Color.black);
        }
        if (this.CountLines) {
            if (msg != null) {
                if (msg.getSupressCount()) {
                    this.setForeground(ADDENDUM);
                    Line2.append("       ");
                } else {
                    int line = msg.getListNumber();
                    if (line < 10) {
                        Line2.append("    ");
                    } else if (line < 100) {
                        Line2.append("   ");
                    } else if (line < 1000) {
                        Line2.append("  ");
                    } else if (line < 10000) {
                        Line2.append(" ");
                    }
                    Line2.append(line).append("> ");
                }
            } else {
                if (index < 9) {
                    Line2.append("    ");
                } else if (index < 99) {
                    Line2.append("   ");
                } else if (index < 999) {
                    Line2.append("  ");
                } else if (index < 9999) {
                    Line2.append(" ");
                }
                Line2.append(index + 1).append("> ");
            }
        }
        if (msg != null) {
            switch (msg.getSeverity()) {
                case 2: {
                    Line2.append(Strings.S.get("SEVERE_MSG")).append(" ");
                    break;
                }
                case 3: {
                    Line2.append(Strings.S.get("FATAL_MSG")).append(" ");
                }
            }
            if (msg.hasCircuit()) {
                Line2.append(msg.getCircuit().getName()).append(": ");
            }
        }
        Line2.append(value);
        this.setText(Line2.toString());
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        return this;
    }
}

