/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HdlWires {
    public static final int WIRE = 0;
    public static final int REGISTER = 1;
    private final List<Wire> myWires = new ArrayList<Wire>();

    public HdlWires addWire(String name, int nrOfBits) {
        this.myWires.add(new Wire(0, name, nrOfBits));
        return this;
    }

    public HdlWires addRegister(String name, int nrOfBits) {
        this.myWires.add(new Wire(1, name, nrOfBits));
        return this;
    }

    public HdlWires addAllWires(Map<String, Integer> wires) {
        for (String wire : wires.keySet()) {
            this.myWires.add(new Wire(0, wire, wires.get(wire)));
        }
        return this;
    }

    public List<String> wireKeySet() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Wire wire : this.myWires) {
            if (!wire.isWire()) continue;
            keys.add(wire.getName());
        }
        return keys;
    }

    public List<String> registerKeySet() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Wire wire : this.myWires) {
            if (wire.isWire()) continue;
            keys.add(wire.getName());
        }
        return keys;
    }

    public int get(String wireName) {
        for (Wire wire : this.myWires) {
            if (!wire.getName().equals(wireName)) continue;
            return wire.getNrOfBits();
        }
        throw new ArrayStoreException("Wire or register not contained in structure");
    }

    public void removeWires() {
        this.myWires.clear();
    }

    private static class Wire {
        private final int myType;
        private final String myName;
        private final int myNrOfBits;

        public Wire(int type, String name, int nrOfBits) {
            this.myType = type;
            this.myName = name;
            this.myNrOfBits = nrOfBits;
        }

        public boolean isWire() {
            return this.myType == 0;
        }

        public String getName() {
            return this.myName;
        }

        public int getNrOfBits() {
            return this.myNrOfBits;
        }
    }
}

