/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WithSelectHdlGenerator {
    private final Map<Long, Long> myCases = new HashMap<Long, Long>();
    private final String regName;
    private final String sourceSignal;
    private final int nrOfSourceBits;
    private final String destinationSignal;
    private final int nrOfDestinationBits;
    private Long defaultValue = 0L;

    public WithSelectHdlGenerator(String componentName, String sourceSignal, int nrOfSourceBits, String destinationSignal, int nrOfDestinationBits) {
        this.regName = LineBuffer.format("s_{{1}}_reg", componentName);
        this.sourceSignal = sourceSignal;
        this.nrOfSourceBits = nrOfSourceBits;
        this.destinationSignal = destinationSignal;
        this.nrOfDestinationBits = nrOfDestinationBits;
    }

    private Long binairyStringToInt(String binairyValue) {
        long result = 0L;
        for (int charIndex = 0; charIndex < binairyValue.length(); ++charIndex) {
            int character = binairyValue.charAt(charIndex) - 48;
            if (character < 0 || character > 1) {
                throw new NumberFormatException("Invalid binairy value in WithSelectHDLGenerator");
            }
            result *= 2L;
            result += (long)character;
        }
        return result;
    }

    public WithSelectHdlGenerator add(Long selectValue, Long assignValue) {
        this.myCases.put(selectValue, assignValue);
        return this;
    }

    public WithSelectHdlGenerator add(Long selectValue, String binairyAssignValue) {
        this.myCases.put(selectValue, this.binairyStringToInt(binairyAssignValue));
        return this;
    }

    public WithSelectHdlGenerator add(String binairySelectValue, String binairyAssignValue) {
        this.myCases.put(this.binairyStringToInt(binairySelectValue), this.binairyStringToInt(binairyAssignValue));
        return this;
    }

    public WithSelectHdlGenerator add(String binairySelectValue, Long assignValue) {
        this.myCases.put(this.binairyStringToInt(binairySelectValue), assignValue);
        return this;
    }

    public WithSelectHdlGenerator setDefault(Long assignValue) {
        this.defaultValue = assignValue;
        return this;
    }

    public WithSelectHdlGenerator setDefault(String binairyAssignValue) {
        this.defaultValue = this.binairyStringToInt(binairyAssignValue);
        return this;
    }

    public List<String> getHdlCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("sourceName", this.sourceSignal).pair("destName", this.destinationSignal).pair("regName", this.regName).pair("regBits", this.nrOfDestinationBits - 1);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("{{with}} ({{sourceName}}) {{select}} {{destName}} <=");
        } else {
            contents.add("reg[{{regBits}}:0] {{regName}};\n   always @(*)\n   begin\n      case ({{sourceName}})\n");
        }
        for (Long thisCase : this.myCases.keySet()) {
            Long value = this.myCases.get(thisCase);
            if (Hdl.isVhdl()) {
                contents.add("   {{1}} {{when}} {{2}},", Hdl.getConstantVector(value, this.nrOfDestinationBits), Hdl.getConstantVector(thisCase, this.nrOfSourceBits));
                continue;
            }
            contents.add("      {{1}} : {{regName}} = {{2}};", Hdl.getConstantVector(thisCase, this.nrOfSourceBits), Hdl.getConstantVector(value, this.nrOfDestinationBits));
        }
        if (Hdl.isVhdl()) {
            contents.add("   {{1}} {{when}} {{others}};", Hdl.getConstantVector(this.defaultValue, this.nrOfDestinationBits));
        } else {
            contents.add("      default : {{regName}} = {{1}};", Hdl.getConstantVector(this.defaultValue, this.nrOfDestinationBits));
        }
        if (Hdl.isVerilog()) {
            contents.add("   endcase\nend\n\nassign {{destName}} = {{regName}};\n");
        }
        return contents.get();
    }
}

