/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTableModel;
import com.cburch.logisim.gui.generic.AttrTableModelEvent;
import com.cburch.logisim.gui.generic.AttrTableModelListener;
import com.cburch.logisim.gui.generic.AttrTableModelRow;
import com.cburch.logisim.gui.generic.AttrTableSetException;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AttributeSetTableModel
implements AttrTableModel,
AttributeListener {
    private final ArrayList<AttrTableModelListener> listeners;
    private final HashMap<Attribute<?>, AttrRow> rowMap;
    private AttributeSet attrs;
    private ArrayList<AttrRow> rows;
    private ComponentFactory compInst = null;

    public AttributeSetTableModel(AttributeSet attrs) {
        this.attrs = attrs;
        this.listeners = new ArrayList();
        this.rowMap = new HashMap();
        this.rows = new ArrayList();
        if (attrs != null) {
            HDLrow rowd = new HDLrow(null);
            this.rows.add(rowd);
            for (Attribute<?> attr : attrs.getAttributes()) {
                if (attr.isHidden()) continue;
                AttrRow row = new AttrRow(attr);
                this.rowMap.put(attr, row);
                this.rows.add(row);
            }
        }
    }

    public void setInstance(ComponentFactory fact) {
        this.compInst = fact;
    }

    public void setIsTool() {
        for (Attribute<?> attr : this.attrs.getAttributes()) {
            if (!"label".equals(attr.getName())) continue;
            AttrRow row = this.rowMap.get(attr);
            this.rowMap.remove(attr);
            this.rows.remove(row);
        }
    }

    @Override
    public void addAttrTableModelListener(AttrTableModelListener listener) {
        if (this.attrs != null && this.listeners.isEmpty()) {
            this.attrs.addAttributeListener(this);
        }
        this.listeners.add(listener);
    }

    @Override
    public void attributeListChanged(AttributeEvent e) {
        int index = 0;
        boolean match = true;
        int rowsSize = this.rows.size();
        for (Attribute<?> attr : this.attrs.getAttributes()) {
            if (attr.isHidden()) continue;
            if (index >= rowsSize || this.rows.get((int)index).attr != attr) {
                match = false;
                break;
            }
            ++index;
        }
        if (match && index == this.rows.size()) {
            return;
        }
        ArrayList<AttrRow> newRows = new ArrayList<AttrRow>();
        HashSet missing = new HashSet(this.rowMap.keySet());
        HDLrow rowd = new HDLrow(null);
        newRows.add(rowd);
        for (Attribute<?> attr : this.attrs.getAttributes()) {
            if (attr.isHidden()) continue;
            AttrRow row = this.rowMap.get(attr);
            if (row == null) {
                row = new AttrRow(attr);
                this.rowMap.put(attr, row);
            } else {
                missing.remove(attr);
            }
            newRows.add(row);
        }
        this.rows = newRows;
        for (Attribute<?> attr : missing) {
            this.rowMap.remove(attr);
        }
        this.fireStructureChanged();
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        int index;
        Attribute<?> attr = e.getAttribute();
        AttrRow row = this.rowMap.get(attr);
        if (row != null && (index = this.rows.indexOf(row)) >= 0) {
            this.fireValueChanged(index);
        }
    }

    protected void fireStructureChanged() {
        AttrTableModelEvent event = new AttrTableModelEvent(this);
        for (AttrTableModelListener l : this.listeners) {
            l.attrStructureChanged(event);
        }
    }

    protected void fireTitleChanged() {
        AttrTableModelEvent event = new AttrTableModelEvent(this);
        for (AttrTableModelListener l : this.listeners) {
            l.attrTitleChanged(event);
        }
    }

    protected void fireValueChanged(int index) {
        AttrTableModelEvent event = new AttrTableModelEvent(this, index);
        for (AttrTableModelListener l : this.listeners) {
            l.attrValueChanged(event);
        }
    }

    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    public void setAttributeSet(AttributeSet value) {
        if (this.attrs != value) {
            if (!this.listeners.isEmpty()) {
                this.attrs.removeAttributeListener(this);
            }
            this.attrs = value;
            if (!this.listeners.isEmpty()) {
                this.attrs.addAttributeListener(this);
            }
            this.attributeListChanged(null);
        }
    }

    @Override
    public AttrTableModelRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public void removeAttrTableModelListener(AttrTableModelListener listener) {
        this.listeners.remove(listener);
        if (this.attrs != null && this.listeners.isEmpty()) {
            this.attrs.removeAttributeListener(this);
        }
    }

    protected abstract void setValueRequested(Attribute<Object> var1, Object var2) throws AttrTableSetException;

    private class HDLrow
    extends AttrRow {
        HDLrow(Attribute<?> attr) {
            super(attr);
        }

        @Override
        public String getLabel() {
            return Strings.S.get("FPGA_Supported");
        }

        @Override
        public String getValue() {
            if (AttributeSetTableModel.this.compInst == null) {
                return "HDL_UNKNOWN";
            }
            return AttributeSetTableModel.this.compInst.isHDLSupportedComponent(AttributeSetTableModel.this.attrs) ? "HDL_SUPPORTED" : "HDL_NOT_SUPPORTED";
        }

        @Override
        public boolean isValueEditable() {
            return false;
        }

        @Override
        public void setValue(Window parent, Object value) {
        }
    }

    private class AttrRow
    implements AttrTableModelRow {
        private final Attribute<Object> attr;

        AttrRow(Attribute<?> attr) {
            Attribute<?> objAttr = attr;
            this.attr = objAttr;
        }

        @Override
        public Component getEditor(Window parent) {
            Object value = AttributeSetTableModel.this.attrs.getValue(this.attr);
            return this.attr.getCellEditor(parent, value);
        }

        @Override
        public String getLabel() {
            return this.attr.getDisplayName();
        }

        @Override
        public String getValue() {
            Object value = AttributeSetTableModel.this.attrs.getValue(this.attr);
            if (value == null) {
                try {
                    return this.attr.toDisplayString(value);
                }
                catch (NullPointerException e) {
                    return "";
                }
            }
            try {
                String str = this.attr.toDisplayString(value);
                if (str.isEmpty() && "label".equals(this.attr.getName()) && AttributeSetTableModel.this.compInst != null && AttributeSetTableModel.this.compInst.requiresNonZeroLabel()) {
                    return ">_HDL_REQUIRED_FIELD_<";
                }
                return str;
            }
            catch (Exception e) {
                return "???";
            }
        }

        @Override
        public boolean isValueEditable() {
            return !AttributeSetTableModel.this.attrs.isReadOnly(this.attr);
        }

        @Override
        public boolean multiEditCompatible(AttrTableModelRow other) {
            if (!(other instanceof AttrRow)) {
                return false;
            }
            AttrRow o = (AttrRow)other;
            if (!(this.attr instanceof SplitterAttributes.BitOutAttribute)) {
                return false;
            }
            if (!(o.attr instanceof SplitterAttributes.BitOutAttribute)) {
                return false;
            }
            SplitterAttributes.BitOutAttribute a = (SplitterAttributes.BitOutAttribute)this.attr;
            SplitterAttributes.BitOutAttribute b = (SplitterAttributes.BitOutAttribute)o.attr;
            return a.sameOptions(b);
        }

        @Override
        public void setValue(Window parent, Object value) throws AttrTableSetException {
            Attribute<Object> attr = this.attr;
            if (attr == null || value == null) {
                return;
            }
            try {
                if (value instanceof String) {
                    value = attr.parse((String)value);
                }
                AttributeSetTableModel.this.setValueRequested(attr, value);
            }
            catch (ClassCastException e) {
                String msg = Strings.S.get("attributeChangeInvalidError") + ": " + String.valueOf(e);
                throw new AttrTableSetException(msg);
            }
            catch (NumberFormatException e) {
                Object msg = Strings.S.get("attributeChangeInvalidError");
                String eMsg = e.getMessage();
                if (eMsg != null && eMsg.length() > 0) {
                    msg = (String)msg + ": " + eMsg;
                }
                msg = (String)msg + ".";
                throw new AttrTableSetException((String)msg);
            }
        }
    }
}

