/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.Main;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPane {
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int ERROR_MESSAGE = 0;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int PLAIN_MESSAGE = -1;
    public static final int CLOSED_OPTION = -1;
    static final Logger logger = LoggerFactory.getLogger(OptionPane.class);

    public static void showMessageDialog(Component parentComponent, Object message) {
        if (Main.hasGui()) {
            JOptionPane.showMessageDialog(parentComponent, message);
        } else if (message instanceof String) {
            String msg = (String)message;
            logger.info(msg);
        }
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        if (Main.hasGui()) {
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
        } else if (message instanceof String) {
            String logMessage = title + ":" + String.valueOf(message);
            switch (messageType) {
                case 0: {
                    logger.error(logMessage);
                    break;
                }
                case 2: {
                    logger.warn(logMessage);
                    break;
                }
                default: {
                    logger.info(logMessage);
                }
            }
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return Main.hasGui() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType) : 2;
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return Main.hasGui() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType) : 2;
    }

    public static String showInputDialog(Object message) {
        return Main.hasGui() ? JOptionPane.showInputDialog(message) : null;
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return Main.hasGui() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType) : null;
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        return Main.hasGui() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue) : null;
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        return Main.hasGui() ? JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue) : -1;
    }

    public static Frame getFrameForComponent(Component parentComponent) {
        return Main.hasGui() ? JOptionPane.getFrameForComponent(parentComponent) : null;
    }
}

