/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Graphics2D;

public class OpenSaveIcon
extends BaseIcon {
    public static final int FILE_OPEN = 0;
    public static final int FILE_SAVE = 1;
    public static final int FILE_SAVE_AS = 2;
    private static final int[] arrowUp = new int[]{4, 3, 7, 0, 10, 3, 8, 3, 8, 6, 6, 6, 6, 3};
    private static final int[] arrowDown = new int[]{6, 0, 8, 0, 8, 3, 10, 3, 7, 6, 4, 3, 6, 3};
    private final int myType;

    public OpenSaveIcon(int type) {
        this.myType = type;
    }

    private Bounds getScaled(int x, int y, int width, int height) {
        return Bounds.create(AppPreferences.getScaled(x), AppPreferences.getScaled(y), AppPreferences.getScaled(width), AppPreferences.getScaled(height));
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        Color discCol = this.myType == 2 ? Color.GRAY : Color.BLUE;
        Bounds bds = this.getScaled(2, 2, 12, 12);
        g2.setColor(discCol);
        g2.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g2.setColor(Color.YELLOW);
        bds = this.getScaled(4, 2, 8, 7);
        g2.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g2.setColor(Color.LIGHT_GRAY);
        bds = this.getScaled(6, 10, 4, 4);
        g2.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g2.setColor(Color.BLACK);
        bds = this.getScaled(8, 11, 1, 2);
        g2.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        g2.setColor(Color.MAGENTA);
        switch (this.myType) {
            case 0: {
                int[] xPoints = new int[7];
                int[] yPoints = new int[7];
                for (int i = 0; i < 7; ++i) {
                    xPoints[i] = AppPreferences.getScaled(arrowUp[i * 2]);
                    yPoints[i] = AppPreferences.getScaled(arrowUp[i * 2 + 1]);
                }
                g2.fillPolygon(xPoints, yPoints, 7);
                break;
            }
            case 1: 
            case 2: {
                int[] xPoints = new int[7];
                int[] yPoints = new int[7];
                for (int i = 0; i < 7; ++i) {
                    xPoints[i] = AppPreferences.getScaled(arrowDown[i * 2]);
                    yPoints[i] = AppPreferences.getScaled(arrowDown[i * 2 + 1]);
                }
                g2.fillPolygon(xPoints, yPoints, 7);
                break;
            }
        }
    }
}

