/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.GridPainter;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;

class CanvasPainter
implements PropertyChangeListener {
    private static final Set<Component> NO_COMPONENTS = Collections.emptySet();
    private final Canvas canvas;
    private final GridPainter grid;
    private Component haloedComponent = null;
    private Circuit haloedCircuit = null;
    private WireSet highlightedWires = WireSet.EMPTY;

    CanvasPainter(Canvas canvas) {
        this.canvas = canvas;
        this.grid = new GridPainter(canvas);
        AppPreferences.ATTRIBUTE_HALO.addPropertyChangeListener(this);
        AppPreferences.CANVAS_BG_COLOR.addPropertyChangeListener(this);
        AppPreferences.GRID_BG_COLOR.addPropertyChangeListener(this);
        AppPreferences.GRID_DOT_COLOR.addPropertyChangeListener(this);
        AppPreferences.GRID_ZOOMED_DOT_COLOR.addPropertyChangeListener(this);
    }

    private void drawWidthIncompatibilityData(Graphics base, Graphics g, Project proj) {
        Set<WidthIncompatibilityData> exceptions = proj.getCurrentCircuit().getWidthIncompatibilityData();
        if (CollectionUtil.isNullOrEmpty(exceptions)) {
            return;
        }
        FontMetrics fm = base.getFontMetrics(g.getFont());
        for (WidthIncompatibilityData ex : exceptions) {
            BitWidth common = ex.getCommonBitWidth();
            for (int i = 0; i < ex.size(); ++i) {
                Location p = ex.getPoint(i);
                BitWidth w = ex.getBitWidth(i);
                boolean drawn = false;
                for (int j = 0; j < i; ++j) {
                    if (!ex.getPoint(j).equals(p)) continue;
                    drawn = true;
                    break;
                }
                if (drawn) continue;
                StringBuilder caption = new StringBuilder("" + w.getWidth());
                for (int j = i + 1; j < ex.size(); ++j) {
                    if (!ex.getPoint(j).equals(p)) continue;
                    caption.append("/" + String.valueOf(ex.getBitWidth(j)));
                    break;
                }
                GraphicsUtil.switchToWidth(g, 2);
                if (common != null && !w.equals(common)) {
                    g.setColor(Value.widthErrorHighlightColor);
                    g.drawOval(p.getX() - 5, p.getY() - 5, 10, 10);
                }
                g.setColor(Value.widthErrorColor);
                g.drawOval(p.getX() - 4, p.getY() - 4, 8, 8);
                GraphicsUtil.switchToWidth(g, 3);
                GraphicsUtil.outlineText(g, caption.toString(), p.getX() + 4, p.getY() + 1 + fm.getAscent(), Value.widthErrorCaptionColor, common != null && !w.equals(common) ? Value.widthErrorHighlightColor : Value.widthErrorCaptionBgcolor);
            }
        }
        g.setColor(Color.BLACK);
        GraphicsUtil.switchToWidth(g, 1);
    }

    private void drawWithUserState(Graphics base, Graphics g, Project proj) {
        Tool tool;
        boolean showHalo;
        Set<Component> hidden;
        Circuit circ = proj.getCurrentCircuit();
        Selection sel = proj.getSelection();
        Tool dragTool = this.canvas.getDragTool();
        Set<Component> set = hidden = dragTool == null ? NO_COMPONENTS : dragTool.getHiddenComponents(this.canvas);
        if (hidden == null) {
            hidden = NO_COMPONENTS;
        }
        if ((showHalo = AppPreferences.ATTRIBUTE_HALO.getBoolean()) && this.haloedComponent != null && this.haloedCircuit == circ && !hidden.contains(this.haloedComponent)) {
            GraphicsUtil.switchToWidth(g, 3);
            g.setColor(Canvas.HALO_COLOR);
            Bounds bds = this.haloedComponent.getBounds(g).expand(5);
            int width = bds.getWidth();
            int height = bds.getHeight();
            double a = Canvas.SQRT_2 * (double)width;
            double b = Canvas.SQRT_2 * (double)height;
            g.drawOval((int)Math.round((double)bds.getX() + (double)width / 2.0 - a / 2.0), (int)Math.round((double)bds.getY() + (double)height / 2.0 - b / 2.0), (int)Math.round(a), (int)Math.round(b));
            GraphicsUtil.switchToWidth(g, 1);
            g.setColor(Color.BLACK);
        }
        CircuitState circState = proj.getCircuitState();
        ComponentDrawContext context = new ComponentDrawContext(this.canvas, circ, circState, base, g, false);
        context.setHighlightedWires(this.highlightedWires);
        circ.draw(context, hidden);
        sel.draw(context, hidden);
        Tool tool2 = tool = dragTool != null ? dragTool : proj.getTool();
        if (tool != null && !this.canvas.isPopupMenuUp()) {
            Graphics gfxCopy = g.create();
            context.setGraphics(gfxCopy);
            tool.draw(this.canvas, context);
            gfxCopy.dispose();
        }
    }

    private void exposeHaloedComponent(Graphics gfx) {
        Component comp = this.haloedComponent;
        if (comp == null) {
            return;
        }
        Bounds bds = comp.getBounds(gfx).expand(7);
        int width = bds.getWidth();
        int height = bds.getHeight();
        double a = Canvas.SQRT_2 * (double)width;
        double b = Canvas.SQRT_2 * (double)height;
        this.canvas.repaint((int)Math.round((double)bds.getX() + (double)width / 2.0 - a / 2.0), (int)Math.round((double)bds.getY() + (double)height / 2.0 - b / 2.0), (int)Math.round(a), (int)Math.round(b));
    }

    GridPainter getGridPainter() {
        return this.grid;
    }

    Component getHaloedComponent() {
        return this.haloedComponent;
    }

    void paintContents(Graphics g, Project proj) {
        Dimension size = this.canvas.getSize();
        double zoomFactor = this.canvas.getZoomFactor();
        this.grid.paintGrid(g);
        g.setColor(Color.black);
        Graphics gfxScaled = g.create();
        if (zoomFactor != 1.0 && gfxScaled instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)gfxScaled;
            g2d.scale(zoomFactor, zoomFactor);
        }
        this.drawWithUserState(g, gfxScaled, proj);
        this.drawWidthIncompatibilityData(g, gfxScaled, proj);
        Circuit circ = proj.getCurrentCircuit();
        CircuitState circState = proj.getCircuitState();
        ComponentDrawContext ptContext = new ComponentDrawContext(this.canvas, circ, circState, g, gfxScaled);
        ptContext.setHighlightedWires(this.highlightedWires);
        gfxScaled.setColor(Color.RED);
        circState.drawOscillatingPoints(ptContext);
        gfxScaled.setColor(Color.BLUE);
        proj.getSimulator().drawStepPoints(ptContext);
        gfxScaled.setColor(Color.MAGENTA);
        proj.getSimulator().drawPendingInputs(ptContext);
        gfxScaled.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (AppPreferences.GRID_BG_COLOR.isSource(event) || AppPreferences.GRID_DOT_COLOR.isSource(event) || AppPreferences.GRID_ZOOMED_DOT_COLOR.isSource(event)) {
            this.canvas.repaint();
        }
    }

    void setHaloedComponent(Circuit circ, Component comp) {
        if (comp == this.haloedComponent) {
            return;
        }
        Graphics g = this.canvas.getGraphics();
        this.exposeHaloedComponent(g);
        this.haloedCircuit = circ;
        this.haloedComponent = comp;
        this.exposeHaloedComponent(g);
    }

    void setHighlightedWires(WireSet value) {
        this.highlightedWires = value == null ? WireSet.EMPTY : value;
    }
}

