/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.CircuitTransactionResult;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Clipboard;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionSave;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Dependencies;
import com.cburch.logisim.proj.JoinedAction;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SelectionActions {
    private SelectionActions() {
    }

    public static Action anchorAll(Selection sel) {
        int numAnchor = sel.getFloatingComponents().size();
        if (numAnchor == 0) {
            return null;
        }
        return new Anchor(sel, numAnchor);
    }

    public static Action clear(Selection sel) {
        return new Delete(sel);
    }

    public static Action copy(Selection sel) {
        return new Copy(sel);
    }

    public static Action cut(Selection sel) {
        return new Cut(sel);
    }

    public static Action drop(Selection sel, Collection<Component> comps) {
        HashSet<Component> floating = new HashSet<Component>(sel.getFloatingComponents());
        HashSet<Component> anchored = new HashSet<Component>(sel.getAnchoredComponents());
        ArrayList<Component> toDrop = new ArrayList<Component>();
        ArrayList<Component> toIgnore = new ArrayList<Component>();
        for (Component comp : comps) {
            if (floating.contains(comp)) {
                toDrop.add(comp);
                continue;
            }
            if (!anchored.contains(comp)) continue;
            toDrop.add(comp);
            toIgnore.add(comp);
        }
        if (toDrop.size() == toIgnore.size()) {
            for (Component comp : toIgnore) {
                sel.remove(null, comp);
            }
            return null;
        }
        int numDrop = toDrop.size() - toIgnore.size();
        return new Drop(sel, toDrop, numDrop);
    }

    public static Action dropAll(Selection sel) {
        return SelectionActions.drop(sel, sel.getComponents());
    }

    public static Action duplicate(Selection sel) {
        return new Duplicate(sel);
    }

    private static ComponentFactory findComponentFactory(ComponentFactory factory, ArrayList<Library> libs, boolean acceptNameMatch) {
        String name = factory.getName();
        for (Library lib : libs) {
            for (Tool tool : lib.getTools()) {
                AddTool addTool;
                if (!(tool instanceof AddTool) || !name.equals((addTool = (AddTool)tool).getName())) continue;
                ComponentFactory fact = addTool.getFactory(true);
                if (acceptNameMatch || fact == factory) {
                    return fact;
                }
                if (fact.getClass() != factory.getClass() || fact instanceof SubcircuitFactory || fact instanceof VhdlEntity) continue;
                return fact;
            }
        }
        return null;
    }

    private static HashMap<Component, Component> getReplacementMap(Project proj) {
        HashMap<Component, Component> replMap = new HashMap<Component, Component>();
        LogisimFile file = proj.getLogisimFile();
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(file);
        libs.addAll(file.getLibraries());
        ArrayList<String> dropped = null;
        Clipboard clip = Clipboard.get();
        Collection<Component> comps = clip.getComponents();
        HashMap<ComponentFactory, ComponentFactory> factoryReplacements = new HashMap<ComponentFactory, ComponentFactory>();
        for (Component comp : comps) {
            ComponentFactory compFactory;
            if (comp instanceof Wire || (compFactory = comp.getFactory()) == Text.FACTORY) continue;
            ComponentFactory copyFactory = SelectionActions.findComponentFactory(compFactory, libs, false);
            if (factoryReplacements.containsKey(compFactory)) {
                copyFactory = (ComponentFactory)factoryReplacements.get(compFactory);
            } else if (copyFactory == null) {
                ComponentFactory candidate = SelectionActions.findComponentFactory(compFactory, libs, true);
                if (candidate == null) {
                    if (dropped == null) {
                        dropped = new ArrayList<String>();
                    }
                    dropped.add(compFactory.getDisplayName());
                } else {
                    String msg = Strings.S.get("pasteCloneQuery", compFactory.getName());
                    Object[] opts = new Object[]{Strings.S.get("pasteCloneReplace"), Strings.S.get("pasteCloneIgnore"), Strings.S.get("pasteCloneCancel")};
                    int select = OptionPane.showOptionDialog(proj.getFrame(), msg, Strings.S.get("pasteCloneTitle"), 0, 3, null, opts, opts[0]);
                    if (select == 0) {
                        copyFactory = candidate;
                    } else if (select == 1) {
                        copyFactory = null;
                    } else {
                        return null;
                    }
                    factoryReplacements.put(compFactory, copyFactory);
                }
            }
            if (copyFactory == null) {
                replMap.put(comp, null);
                continue;
            }
            if (copyFactory == compFactory) continue;
            Location copyLoc = comp.getLocation();
            AttributeSet copyAttrs = (AttributeSet)comp.getAttributeSet().clone();
            Component copy = copyFactory.createComponent(copyLoc, copyAttrs);
            replMap.put(comp, copy);
        }
        if (dropped != null) {
            Collections.sort(dropped);
            StringBuilder droppedStr = new StringBuilder();
            droppedStr.append(Strings.S.get("pasteDropMessage"));
            String curName = (String)dropped.get(0);
            int curCount = 1;
            int lines = 1;
            for (int i = 1; i <= dropped.size(); ++i) {
                String nextName;
                String string = nextName = i == dropped.size() ? "" : (String)dropped.get(i);
                if (nextName.equals(curName)) {
                    ++curCount;
                    continue;
                }
                ++lines;
                droppedStr.append("\n  ");
                droppedStr.append(curName);
                if (curCount > 1) {
                    droppedStr.append(" \u00d7 ").append(curCount);
                }
                curName = nextName;
                curCount = 1;
            }
            lines = Math.max(3, Math.min(7, lines));
            JTextArea area = new JTextArea(lines, 60);
            area.setEditable(false);
            area.setText(droppedStr.toString());
            area.setCaretPosition(0);
            JScrollPane areaPane = new JScrollPane(area);
            OptionPane.showMessageDialog(proj.getFrame(), areaPane, Strings.S.get("pasteDropTitle"), 2);
        }
        return replMap;
    }

    public static Action pasteMaybe(Project proj, Selection sel) {
        HashMap<Component, Component> replacements = SelectionActions.getReplacementMap(proj);
        return new Paste(sel, replacements);
    }

    public static Action translate(Selection sel, int dx, int dy, ReplacementMap repl) {
        return new Translate(sel, dx, dy, repl);
    }

    private static class Anchor
    extends SelectedComponentsAction {
        private final Selection sel;
        private final int numAnchor;
        private final SelectionSave before;

        Anchor(Selection sel, int numAnchor) {
            this.sel = sel;
            this.before = SelectionSave.create(sel);
            this.numAnchor = numAnchor;
        }

        @Override
        public void doItFirstTime(Project proj) {
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            this.sel.dropAll(xn);
            this.xnForward = xn;
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
        }

        @Override
        public String getName() {
            return this.numAnchor == 1 ? Strings.S.get("dropComponentAction") : Strings.S.get("dropComponentsAction");
        }

        @Override
        public boolean shouldAppendTo(Action other) {
            Action last = other instanceof JoinedAction ? ((JoinedAction)other).getLastAction() : other;
            SelectionSave otherAfter = null;
            if (last instanceof Paste) {
                Paste paste = (Paste)last;
                otherAfter = paste.after;
            } else if (last instanceof Duplicate) {
                Duplicate dupe = (Duplicate)last;
                otherAfter = dupe.after;
            }
            return otherAfter != null && otherAfter.equals(this.before);
        }
    }

    private static class Delete
    extends SelectedComponentsAction {
        private final Selection sel;

        Delete(Selection sel) {
            this.sel = sel;
        }

        @Override
        public void doItFirstTime(Project proj) {
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            this.sel.deleteAllHelper(xn);
            this.xnForward = xn;
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
        }

        @Override
        public String getName() {
            return Strings.S.get("deleteSelectionAction");
        }
    }

    private static class Copy
    extends SelectedComponentsAction {
        private final Selection sel;
        private Clipboard oldClip;
        private Clipboard newClip;

        Copy(Selection sel) {
            this.sel = sel;
        }

        @Override
        public void doItFirstTime(Project proj) {
            this.oldClip = Clipboard.get();
            Clipboard.set(this.sel, this.sel.getAttributeSet());
            this.newClip = Clipboard.get();
        }

        @Override
        public String getName() {
            return Strings.S.get("copySelectionAction");
        }

        @Override
        public boolean isModification() {
            return false;
        }

        @Override
        public void undo(Project proj) {
            Clipboard.set(this.oldClip);
        }

        @Override
        public void redo(Project proj) {
            Clipboard.set(this.newClip);
        }
    }

    private static class Cut
    extends SelectedComponentsAction {
        private final Selection sel;
        private final Action second;
        private Clipboard oldClip;
        private Clipboard newClip;

        Cut(Selection sel) {
            this.sel = sel;
            this.second = new Delete(sel);
        }

        @Override
        public void doItFirstTime(Project proj) {
            this.oldClip = Clipboard.get();
            Clipboard.set(this.sel, this.sel.getAttributeSet());
            this.newClip = Clipboard.get();
            this.second.doIt(proj);
        }

        @Override
        public String getName() {
            return Strings.S.get("cutSelectionAction");
        }

        @Override
        public void undo(Project proj) {
            this.second.undo(proj);
            Clipboard.set(this.oldClip);
        }

        @Override
        public void redo(Project proj) {
            Clipboard.set(this.newClip);
            this.second.doIt(proj);
        }
    }

    private static class Drop
    extends SelectedComponentsAction {
        private final Selection sel;
        private final Component[] drops;
        private final int numDrops;
        private final SelectionSave before;

        Drop(Selection sel, Collection<Component> toDrop, int numDrops) {
            this.sel = sel;
            this.drops = new Component[toDrop.size()];
            toDrop.toArray(this.drops);
            this.numDrops = numDrops;
            this.before = SelectionSave.create(sel);
        }

        @Override
        public void doItFirstTime(Project proj) {
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            for (Component comp : this.drops) {
                this.sel.remove(xn, comp);
            }
            this.xnForward = xn;
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
        }

        @Override
        public String getName() {
            return this.numDrops == 1 ? Strings.S.get("dropComponentAction") : Strings.S.get("dropComponentsAction");
        }

        @Override
        public boolean shouldAppendTo(Action other) {
            Action action;
            if (other instanceof JoinedAction) {
                JoinedAction action2 = (JoinedAction)other;
                action = action2.getLastAction();
            } else {
                action = other;
            }
            Action last = action;
            SelectionSave otherAfter = null;
            if (last instanceof Paste) {
                Paste paste = (Paste)last;
                otherAfter = paste.after;
            } else if (last instanceof Duplicate) {
                Duplicate dupe = (Duplicate)last;
                otherAfter = dupe.after;
            }
            return otherAfter != null && otherAfter.equals(this.before);
        }
    }

    private static class Duplicate
    extends SelectedComponentsAction {
        private final Selection sel;
        private SelectionSave after;

        Duplicate(Selection sel) {
            this.sel = sel;
        }

        @Override
        public void doItFirstTime(Project proj) {
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            this.sel.duplicateHelper(xn);
            this.xnForward = xn;
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
            this.after = SelectionSave.create(this.sel);
        }

        @Override
        public String getName() {
            return Strings.S.get("duplicateSelectionAction");
        }
    }

    private static class Paste
    extends SelectedComponentsAction {
        private final Selection sel;
        private final HashMap<Component, Component> componentReplacements;
        private SelectionSave after;

        Paste(Selection sel, HashMap<Component, Component> replacements) {
            this.sel = sel;
            this.componentReplacements = replacements;
        }

        private Collection<Component> computeAdditions(Collection<Component> comps) {
            HashMap<Component, Component> replMap = this.componentReplacements;
            ArrayList<Component> toAdd = new ArrayList<Component>(comps.size());
            for (Component comp : comps) {
                if (replMap.containsKey(comp)) {
                    Component repl = replMap.get(comp);
                    if (repl == null) continue;
                    toAdd.add(repl);
                    continue;
                }
                toAdd.add(comp);
            }
            return toAdd;
        }

        @Override
        public void doItFirstTime(Project proj) {
            Clipboard clip = Clipboard.get();
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            Collection<Component> comps = clip.getComponents();
            Collection<Component> toAdd = this.computeAdditions(comps);
            Canvas canvas = proj.getFrame().getCanvas();
            Circuit circ = canvas.getCircuit();
            for (Component c : comps) {
                ComponentFactory factory = c.getFactory();
                if (!(factory instanceof SubcircuitFactory)) continue;
                SubcircuitFactory circFact = (SubcircuitFactory)factory;
                Dependencies depends = canvas.getProject().getDependencies();
                if (depends.canAdd(circ, circFact.getSubcircuit())) continue;
                canvas.setErrorMessage(Strings.S.getter("circularError"));
                return;
            }
            if (!toAdd.isEmpty()) {
                this.sel.pasteHelper(xn, toAdd);
                this.xnForward = xn;
                CircuitTransactionResult result = xn.execute();
                this.xnReverse = result.getReverseTransaction();
                this.after = SelectionSave.create(this.sel);
            } else {
                this.xnForward = null;
                this.xnReverse = null;
            }
        }

        @Override
        public String getName() {
            return Strings.S.get("pasteClipboardAction");
        }
    }

    private static class Translate
    extends SelectedComponentsAction {
        private final Selection sel;
        private final int dx;
        private final int dy;
        private final ReplacementMap replacements;
        private final SelectionSave before;

        Translate(Selection sel, int dx, int dy, ReplacementMap replacements) {
            this.sel = sel;
            this.dx = dx;
            this.dy = dy;
            this.replacements = replacements;
            this.before = SelectionSave.create(sel);
        }

        @Override
        public void doItFirstTime(Project proj) {
            Circuit circuit = proj.getCurrentCircuit();
            CircuitMutation xn = new CircuitMutation(circuit);
            this.sel.translateHelper(xn, this.dx, this.dy);
            if (this.replacements != null) {
                xn.replace(this.replacements);
            }
            this.xnForward = xn;
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
        }

        @Override
        public String getName() {
            return Strings.S.get("moveSelectionAction");
        }

        @Override
        public boolean shouldAppendTo(Action other) {
            Action action;
            if (other instanceof JoinedAction) {
                JoinedAction action2 = (JoinedAction)other;
                action = action2.getLastAction();
            } else {
                action = other;
            }
            Action last = action;
            SelectionSave otherAfter = null;
            if (last instanceof Paste) {
                Paste paste = (Paste)last;
                otherAfter = paste.after;
            } else if (last instanceof Duplicate) {
                Duplicate dupe = (Duplicate)last;
                otherAfter = dupe.after;
            }
            return otherAfter != null && otherAfter.equals(this.before);
        }
    }

    private static abstract class SelectedComponentsAction
    extends Action {
        public CircuitTransaction xnForward;
        public CircuitTransaction xnReverse;
        private boolean hasDoneFirstTime = false;

        private SelectedComponentsAction() {
        }

        @Override
        public void doIt(Project proj) {
            if (this.hasDoneFirstTime) {
                this.redo(proj);
            } else {
                this.doItFirstTime(proj);
                this.hasDoneFirstTime = true;
            }
        }

        public abstract void doItFirstTime(Project var1);

        @Override
        public void undo(Project proj) {
            if (this.xnReverse != null) {
                this.xnReverse.execute();
            }
        }

        public void redo(Project proj) {
            if (this.xnForward != null) {
                this.xnForward.execute();
            }
        }
    }
}

