/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.draw.toolbar.AbstractToolbarModel;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.icons.SimulationIcon;
import com.cburch.logisim.gui.main.LogisimToolbarItem;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.MenuListener;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.UnmodifiableList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulationToolbarModel
extends AbstractToolbarModel
implements ChangeListener {
    private static final SimulationIcon RunToggleIcon = new SimulationIcon(0);
    private static final SimulationIcon EnableDisableIcon = new SimulationIcon(3);
    private final Project project;
    private final LogisimToolbarItem simRunToggle;
    private final LogisimToolbarItem simStep;
    private final LogisimToolbarItem tickEnable;
    private final LogisimToolbarItem tickHalf;
    private final LogisimToolbarItem tickFull;
    private final List<ToolbarItem> items;

    public SimulationToolbarModel(Project project, MenuListener menu) {
        this.project = project;
        this.simRunToggle = new LogisimToolbarItem(menu, RunToggleIcon, LogisimMenuBar.SIMULATE_RUN_TOGGLE, Strings.S.getter("simulateRunTip"));
        this.simStep = new LogisimToolbarItem(menu, new SimulationIcon(2), LogisimMenuBar.SIMULATE_STEP, Strings.S.getter("simulateStepTip"));
        this.tickEnable = new LogisimToolbarItem(menu, EnableDisableIcon, LogisimMenuBar.TICK_ENABLE, Strings.S.getter("simulateEnableTicksTip"));
        this.tickHalf = new LogisimToolbarItem(menu, new SimulationIcon(5), LogisimMenuBar.TICK_HALF, Strings.S.getter("simulateTickHalfTip"));
        this.tickFull = new LogisimToolbarItem(menu, new SimulationIcon(6), LogisimMenuBar.TICK_FULL, Strings.S.getter("simulateTickFullTip"));
        this.items = UnmodifiableList.create(new ToolbarItem[]{this.simRunToggle, this.simStep, this.tickEnable, this.tickHalf, this.tickFull});
        menu.getMenuBar().addEnableListener(this);
        this.stateChanged(null);
    }

    @Override
    public List<ToolbarItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSelected(ToolbarItem item) {
        return false;
    }

    @Override
    public void itemSelected(ToolbarItem item) {
        if (item instanceof LogisimToolbarItem) {
            LogisimToolbarItem toolbarItem = (LogisimToolbarItem)item;
            toolbarItem.doAction();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean ticking;
        Simulator sim = this.project.getSimulator();
        boolean running = sim != null && sim.isAutoPropagating();
        boolean bl = ticking = sim != null && sim.isAutoTicking();
        if (running) {
            RunToggleIcon.setType(1);
            this.simRunToggle.setToolTip(Strings.S.getter("simulateStopTip"));
        } else {
            RunToggleIcon.setType(0);
            this.simRunToggle.setToolTip(Strings.S.getter("simulateRunTip"));
        }
        if (ticking) {
            EnableDisableIcon.setType(4);
            this.tickEnable.setToolTip(Strings.S.getter("simulateDisableTicksTip"));
        } else {
            EnableDisableIcon.setType(3);
            this.tickEnable.setToolTip(Strings.S.getter("simulateEnableTicksTip"));
        }
        this.fireToolbarAppearanceChanged();
    }
}

