/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryEventSource;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.gui.generic.ProjectExplorer;
import com.cburch.logisim.gui.generic.ProjectExplorerLibraryNode;
import com.cburch.logisim.gui.generic.ProjectExplorerToolNode;
import com.cburch.logisim.gui.main.AttrTableCircuitModel;
import com.cburch.logisim.gui.menu.Popups;
import com.cburch.logisim.gui.menu.ProjectCircuitActions;
import com.cburch.logisim.gui.menu.ProjectLibraryActions;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.std.base.BaseLibrary;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.EditTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.PokeTool;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import javax.swing.JPopupMenu;

class ToolboxManip
implements ProjectExplorer.Listener {
    private final Project proj;
    private final ProjectExplorer explorer;
    private final MyListener myListener = new MyListener();
    private Tool lastSelected = null;

    ToolboxManip(Project proj, ProjectExplorer explorer) {
        this.proj = proj;
        this.explorer = explorer;
        proj.addProjectListener(this.myListener);
        this.myListener.setFile(null, proj.getLogisimFile());
    }

    private static void setDefaultTool(Tool lastSelected, Project proj) {
        if (lastSelected != null) {
            proj.setTool(lastSelected);
        } else {
            for (Library sub : proj.getLogisimFile().getLibraries()) {
                Tool tool;
                if (!(sub instanceof BaseLibrary) || (tool = sub.getTool("Edit Tool")) == null) continue;
                proj.setTool(tool);
                break;
            }
        }
    }

    @Override
    public void deleteRequested(ProjectExplorer.Event event) {
        AddTool addTool;
        ComponentFactory factory;
        ProjectExplorerToolNode toolNode;
        Tool tool;
        Object request = event.getTarget();
        if (request instanceof ProjectExplorerLibraryNode) {
            ProjectExplorerLibraryNode libNode = (ProjectExplorerLibraryNode)request;
            ProjectLibraryActions.doUnloadLibrary(this.proj, (Library)libNode.getValue());
        } else if (request instanceof ProjectExplorerToolNode && (tool = (Tool)(toolNode = (ProjectExplorerToolNode)request).getValue()) instanceof AddTool && (factory = (addTool = (AddTool)tool).getFactory()) instanceof SubcircuitFactory) {
            SubcircuitFactory circFact = (SubcircuitFactory)factory;
            ProjectCircuitActions.doRemoveCircuit(this.proj, circFact.getSubcircuit());
        }
    }

    @Override
    public void doubleClicked(ProjectExplorer.Event event) {
        Object clicked = event.getTarget();
        if (clicked instanceof ProjectExplorerToolNode) {
            ProjectExplorerToolNode clickedNode = (ProjectExplorerToolNode)clicked;
            clickedNode.fireNodeChanged();
            Tool baseTool = (Tool)((ProjectExplorerToolNode)clicked).getValue();
            if (baseTool instanceof AddTool) {
                AddTool tool = (AddTool)baseTool;
                ComponentFactory source = tool.getFactory();
                if (source instanceof SubcircuitFactory) {
                    SubcircuitFactory circFact = (SubcircuitFactory)source;
                    this.proj.setCurrentCircuit(circFact.getSubcircuit());
                    this.proj.getFrame().setEditorView("layout");
                    ToolboxManip.setDefaultTool(this.lastSelected, this.proj);
                } else if (source instanceof VhdlEntity) {
                    VhdlEntity vhdl = (VhdlEntity)source;
                    this.proj.setCurrentHdlModel(vhdl.getContent());
                }
            }
        }
    }

    @Override
    public JPopupMenu menuRequested(ProjectExplorer.Event event) {
        Object clicked = event.getTarget();
        if (clicked instanceof ProjectExplorerToolNode) {
            ProjectExplorerToolNode toolNode = (ProjectExplorerToolNode)clicked;
            Tool baseTool = (Tool)toolNode.getValue();
            if (baseTool instanceof AddTool) {
                AddTool tool = (AddTool)baseTool;
                ComponentFactory source = tool.getFactory();
                if (source instanceof SubcircuitFactory) {
                    SubcircuitFactory sub = (SubcircuitFactory)source;
                    return Popups.forCircuit(this.proj, tool, sub.getSubcircuit());
                }
                if (source instanceof VhdlEntity) {
                    VhdlEntity vhdlEntity = (VhdlEntity)source;
                    return Popups.forVhdl(this.proj, tool, vhdlEntity.getContent());
                }
                return null;
            }
            return null;
        }
        if (clicked instanceof ProjectExplorerLibraryNode) {
            ProjectExplorerLibraryNode libNode = (ProjectExplorerLibraryNode)clicked;
            Library lib = (Library)libNode.getValue();
            if (lib == this.proj.getLogisimFile()) {
                return Popups.forProject(this.proj);
            }
            boolean isTop = event.getTreePath().getPathCount() <= 2;
            return Popups.forLibrary(this.proj, lib, isTop);
        }
        return null;
    }

    @Override
    public void moveRequested(ProjectExplorer.Event event, AddTool dragged, AddTool target) {
        LogisimFile file = this.proj.getLogisimFile();
        int draggedIndex = file.getTools().indexOf(dragged);
        int targetIndex = file.getTools().indexOf(target);
        if (targetIndex > draggedIndex) {
            ++targetIndex;
        }
        this.proj.doAction(LogisimFileActions.moveCircuit(dragged, targetIndex));
    }

    @Override
    public void selectionChanged(ProjectExplorer.Event event) {
        Object selected;
        if (this.proj.getTool() instanceof PokeTool || this.proj.getTool() instanceof EditTool) {
            this.lastSelected = this.proj.getTool();
        }
        if ((selected = event.getTarget()) instanceof ProjectExplorerToolNode) {
            AddTool addTool;
            ComponentFactory source;
            ProjectExplorerToolNode toolNode = (ProjectExplorerToolNode)selected;
            toolNode.fireNodeChanged();
            Tool tool = (Tool)toolNode.getValue();
            if (tool instanceof AddTool && (source = (addTool = (AddTool)tool).getFactory()) instanceof SubcircuitFactory) {
                SubcircuitFactory circFact = (SubcircuitFactory)source;
                Circuit circ = circFact.getSubcircuit();
                if (this.proj.getCurrentCircuit() == circ) {
                    this.proj.getFrame().setAttrTableModel(new AttrTableCircuitModel(this.proj, circ));
                    ToolboxManip.setDefaultTool(this.lastSelected, this.proj);
                    return;
                }
            }
            this.proj.setTool(tool);
            this.proj.getFrame().viewAttributes(tool);
        }
    }

    private class MyListener
    implements ProjectListener,
    LibraryListener,
    AttributeListener {
        private LogisimFile curFile = null;

        private MyListener() {
        }

        private void addLibrary(Library lib) {
            if (lib instanceof LibraryEventSource) {
                LibraryEventSource src = (LibraryEventSource)((Object)lib);
                src.addLibraryListener(this);
            }
            for (Tool tool : lib.getTools()) {
                AttributeSet attrs = tool.getAttributeSet();
                if (attrs == null) continue;
                attrs.addAttributeListener(this);
            }
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            ToolboxManip.this.explorer.repaint();
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            Tool tool;
            AttributeSet attrs;
            int action = event.getAction();
            if (action == 3) {
                if (event.getSource() == this.curFile) {
                    this.addLibrary((Library)event.getData());
                }
            } else if (action == 4) {
                if (event.getSource() == this.curFile) {
                    this.removeLibrary((Library)event.getData());
                }
            } else if (action == 0) {
                Tool tool2 = (Tool)event.getData();
                AttributeSet attrs2 = tool2.getAttributeSet();
                if (attrs2 != null) {
                    attrs2.addAttributeListener(this);
                }
            } else if (action == 1 && (attrs = (tool = (Tool)event.getData()).getAttributeSet()) != null) {
                attrs.removeAttributeListener(this);
            }
            ToolboxManip.this.explorer.repaint();
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int action = event.getAction();
            if (action == 0) {
                this.setFile((LogisimFile)event.getOldData(), (LogisimFile)event.getData());
                ToolboxManip.this.explorer.repaint();
            }
        }

        private void removeLibrary(Library lib) {
            if (lib instanceof LibraryEventSource) {
                LibraryEventSource src = (LibraryEventSource)((Object)lib);
                src.removeLibraryListener(this);
            }
            for (Tool tool : lib.getTools()) {
                AttributeSet attrs = tool.getAttributeSet();
                if (attrs == null) continue;
                attrs.removeAttributeListener(this);
            }
        }

        private void setFile(LogisimFile oldFile, LogisimFile newFile) {
            if (oldFile != null) {
                this.removeLibrary(oldFile);
                for (Library lib : oldFile.getLibraries()) {
                    this.removeLibrary(lib);
                }
            }
            this.curFile = newFile;
            if (newFile != null) {
                this.addLibrary(newFile);
                for (Library lib : newFile.getLibraries()) {
                    this.addLibrary(lib);
                }
            }
        }
    }
}

