/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.gui.menu.Menu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;

class MenuItemHelper
implements ActionListener {
    private final JMenuItem source;
    private final LogisimMenuItem menuItem;
    private final Menu menu;
    private final ArrayList<ActionListener> listeners;
    private boolean enabled;
    private boolean inActionListener;

    public MenuItemHelper(JMenuItem source, Menu menu, LogisimMenuItem menuItem) {
        this.source = source;
        this.menu = menu;
        this.menuItem = menuItem;
        this.enabled = true;
        this.inActionListener = false;
        this.listeners = new ArrayList();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.listeners.isEmpty()) {
            ActionEvent e = new ActionEvent(this.menuItem, event.getID(), event.getActionCommand(), event.getWhen(), event.getModifiers());
            for (ActionListener l : this.listeners) {
                l.actionPerformed(e);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
        this.computeEnabled();
    }

    private void computeEnabled() {
        this.inActionListener = true;
        try {
            this.source.setEnabled(this.enabled);
            this.menu.computeEnabled();
        }
        finally {
            this.inActionListener = false;
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
        this.computeEnabled();
    }

    public void setEnabled(boolean value) {
        if (!this.inActionListener) {
            this.enabled = value;
        }
    }
}

