/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.opts;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Tool;

class OptionsActions {
    private OptionsActions() {
    }

    public static Action removeMapping(MouseMappings mm, Integer mods) {
        return new RemoveMapping(mm, mods);
    }

    public static Action setAttribute(AttributeSet attrs, Attribute<?> attr, Object value) {
        Object oldValue = attrs.getValue(attr);
        if (!oldValue.equals(value)) {
            return new SetAction(attrs, attr, value);
        }
        return null;
    }

    public static Action setMapping(MouseMappings mm, Integer mods, Tool tool) {
        return new SetMapping(mm, mods, tool);
    }

    private static class RemoveMapping
    extends Action {
        final MouseMappings mm;
        final Integer mods;
        Tool oldtool;

        RemoveMapping(MouseMappings mm, Integer mods) {
            this.mm = mm;
            this.mods = mods;
        }

        @Override
        public void doIt(Project proj) {
            this.oldtool = this.mm.getToolFor(this.mods);
            this.mm.setToolFor(this.mods, (Tool)null);
        }

        @Override
        public String getName() {
            return Strings.S.get("removeMouseMappingAction");
        }

        @Override
        public void undo(Project proj) {
            this.mm.setToolFor(this.mods, this.oldtool);
        }
    }

    private static class SetAction
    extends Action {
        private final AttributeSet attrs;
        private final Attribute<Object> attr;
        private final Object newval;
        private Object oldval;

        SetAction(AttributeSet attrs, Attribute<?> attr, Object value) {
            Attribute<?> a = attr;
            this.attrs = attrs;
            this.attr = a;
            this.newval = value;
        }

        @Override
        public void doIt(Project proj) {
            this.oldval = this.attrs.getValue(this.attr);
            this.attrs.setValue(this.attr, this.newval);
        }

        @Override
        public String getName() {
            return Strings.S.get("setOptionAction", this.attr.getDisplayName());
        }

        @Override
        public void undo(Project proj) {
            this.attrs.setValue(this.attr, this.oldval);
        }
    }

    private static class SetMapping
    extends Action {
        final MouseMappings mm;
        final Integer mods;
        Tool oldtool;
        final Tool tool;

        SetMapping(MouseMappings mm, Integer mods, Tool tool) {
            this.mm = mm;
            this.mods = mods;
            this.tool = tool;
        }

        @Override
        public void doIt(Project proj) {
            this.oldtool = this.mm.getToolFor(this.mods);
            this.mm.setToolFor(this.mods, this.tool);
        }

        @Override
        public String getName() {
            return Strings.S.get("addMouseMappingAction");
        }

        @Override
        public void undo(Project proj) {
            this.mm.setToolFor(this.mods, this.oldtool);
        }
    }
}

