/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.start.About;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreen
extends JWindow {
    public static final int LIBRARIES = 0;
    public static final int TEMPLATE_CREATE = 1;
    public static final int TEMPLATE_OPEN = 2;
    public static final int TEMPLATE_LOAD = 3;
    public static final int TEMPLATE_CLOSE = 4;
    public static final int GUI_INIT = 5;
    public static final int FILE_CREATE = 6;
    public static final int FILE_LOAD = 7;
    public static final int PROJECT_CREATE = 8;
    public static final int FRAME_CREATE = 9;
    static final Logger logger = LoggerFactory.getLogger(SplashScreen.class);
    private static final long serialVersionUID = 1L;
    private static final int PROGRESS_MAX = 3568;
    private static final boolean PRINT_TIMES = false;
    Marker[] markers = new Marker[]{new Marker(377, Strings.S.get("progressLibraries")), new Marker(990, Strings.S.get("progressTemplateCreate")), new Marker(1002, Strings.S.get("progressTemplateOpen")), new Marker(1002, Strings.S.get("progressTemplateLoad")), new Marker(1470, Strings.S.get("progressTemplateClose")), new Marker(1478, Strings.S.get("progressGuiInitialize")), new Marker(2114, Strings.S.get("progressFileCreate")), new Marker(2114, Strings.S.get("progressFileLoad")), new Marker(2383, Strings.S.get("progressProjectCreate")), new Marker(2519, Strings.S.get("progressFrameCreate"))};
    boolean inClose = false;
    final JProgressBar progress = new JProgressBar(0, 3568);
    final long startTime = System.currentTimeMillis();

    public SplashScreen() {
        this.setName("Logisim-evolution v4.0.0");
        About.AboutPanel imagePanel = About.getImagePanel();
        imagePanel.setBorder(null);
        this.progress.setStringPainted(true);
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)imagePanel, "North");
        contents.add((Component)this.progress, "Center");
        contents.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        Color bg = imagePanel.getBackground();
        contents.setBackground(bg);
        this.setBackground(bg);
        this.setContentPane(contents);
    }

    public void close() {
        if (this.inClose) {
            return;
        }
        this.inClose = true;
        this.setVisible(false);
        this.inClose = false;
        this.markers = null;
    }

    public void setProgress(int markerId) {
        Marker marker;
        Marker marker2 = marker = this.markers == null ? null : this.markers[markerId];
        if (marker != null) {
            SwingUtilities.invokeLater(() -> {
                this.progress.setString(marker.message);
                this.progress.setValue(marker.count);
            });
        }
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.pack();
            Dimension dim = this.getToolkit().getScreenSize();
            int x = (int)(dim.getWidth() - (double)this.getWidth()) / 2;
            int y = (int)(dim.getHeight() - (double)this.getHeight()) / 2;
            this.setLocation(x, y);
        }
        super.setVisible(value);
    }

    private static class Marker {
        final int count;
        final String message;

        Marker(int count, String message) {
            this.count = count;
            this.message = message;
        }
    }
}

