/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.proj.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Template {
    private final String contents;

    public static Template create(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in);
        char[] buf = new char[4096];
        StringBuilder dest = new StringBuilder();
        try {
            int nbytes;
            while ((nbytes = reader.read(buf)) >= 0) {
                dest.append(buf, 0, nbytes);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return new Template(dest.toString());
    }

    public static Template createEmpty() {
        String circName = Strings.S.get("newCircuitName");
        String buf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project source=\"" + String.valueOf(BuildInfo.version) + "\" version=\"1.0\"> <circuit name=\"" + circName + "\" /></project>";
        return new Template(buf);
    }

    private Template(String contents) {
        this.contents = contents;
    }

    public InputStream createStream() {
        return new ByteArrayInputStream(this.contents.getBytes(StandardCharsets.UTF_8));
    }
}

