/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.ComponentDataGuiProvider;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.bus.SocBus;
import com.cburch.logisim.soc.bus.SocBusAttributes;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocMemMapModel;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.gui.TraceWindowTableModel;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SocBusStateInfo
extends JDialog
implements ActionListener,
LocaleListener,
BaseWindowListenerContract {
    private static final long serialVersionUID = 1L;
    public static final int TRACE_WIDTH = 630;
    public static final int TRACE_HEIGHT = 30;
    public static final int BLOCK_WIDTH = 238;
    private final SocSimulationManager socManager;
    private Component myComp;
    private final ArrayList<SocBusSnifferInterface> sniffers;
    private final JButton okButton;
    private final JLabel title;
    private final JScrollPane scroll;
    private final SocMemMapModel memMap;

    public SocBusStateInfo(SocSimulationManager man, Component comp) {
        LocaleManager.addLocaleListener(this);
        this.socManager = man;
        this.myComp = comp;
        this.sniffers = new ArrayList();
        this.memMap = new SocMemMapModel();
        this.setTitle(Strings.S.get("SocMemMapWindowTitle") + this.getName());
        this.setLayout(new BorderLayout());
        this.title = new JLabel(Strings.S.get("SocMemoryMapTitle"), 0);
        this.add((java.awt.Component)this.title, "North");
        JTable table = new JTable(this.memMap){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return SocBusStateInfo.this.memMap.getCellRender();
            }
        };
        table.getTableHeader().setDefaultRenderer(this.memMap.getHeaderRenderer());
        table.setFillsViewportHeight(true);
        table.setRowHeight(AppPreferences.getScaled(20));
        table.addMouseListener(this.memMap);
        this.scroll = new JScrollPane(table);
        this.scroll.setPreferredSize(new Dimension(AppPreferences.getScaled(320), AppPreferences.getScaled(240)));
        this.add((java.awt.Component)this.scroll, "Center");
        this.okButton = new JButton(Strings.S.get("SocMemoryMapOk"));
        this.add((java.awt.Component)this.okButton, "South");
        this.okButton.addActionListener(this);
        this.pack();
    }

    public void registerSocBusSlave(SocBusSlaveInterface slave) {
        this.memMap.registerSocBusSlave(slave);
    }

    public void removeSocBusSlave(SocBusSlaveInterface slave) {
        this.memMap.removeSocBusSlave(slave);
    }

    public void registerSocBusSniffer(SocBusSnifferInterface sniffer) {
        if (!this.sniffers.contains(sniffer)) {
            this.sniffers.add(sniffer);
        }
    }

    public void removeSocBusSniffer(SocBusSnifferInterface sniffer) {
        this.sniffers.remove(sniffer);
    }

    public List<SocBusSlaveInterface> getSlaves() {
        return this.memMap.getSlaves();
    }

    @Override
    public String getName() {
        Object name = this.myComp.getAttributeSet().getValue(StdAttr.LABEL);
        if (StringUtil.isNullOrEmpty((CharSequence)name)) {
            Location loc = this.myComp.getLocation();
            name = this.myComp.getFactory().getDisplayName() + "@" + loc.getX() + "," + loc.getY();
        }
        return name;
    }

    public SocSimulationManager getSocSimulationManager() {
        return this.socManager;
    }

    public Component getComponent() {
        return this.myComp;
    }

    public void setComponent(Component comp) {
        this.myComp = comp;
    }

    public void initializeTransaction(SocBusTransaction trans, String busId) {
        SocBusState data;
        int nrOfReponders = 0;
        int reponder = -1;
        List<SocBusSlaveInterface> slaves = this.memMap.getSlaves();
        if (slaves.isEmpty()) {
            trans.setError(2);
        } else if (trans.isReadTransaction() && trans.isWriteTransaction() && !trans.isAtomicTransaction()) {
            trans.setError(4);
        } else {
            for (int i = 0; i < slaves.size(); ++i) {
                if (!slaves.get(i).canHandleTransaction(trans)) continue;
                ++nrOfReponders;
                reponder = i;
            }
            if (nrOfReponders == 0) {
                trans.setError(1);
            } else if (nrOfReponders != 1) {
                trans.setError(3);
            } else {
                slaves.get(reponder).handleTransaction(trans);
            }
        }
        if (!trans.hasError() && !trans.isHidden()) {
            for (SocBusSnifferInterface sniffer : this.sniffers) {
                sniffer.sniffTransaction(trans);
            }
        }
        if (!trans.isHidden() && (data = this.getRegPropagateState()) != null) {
            data.addTransaction(trans);
            if (this.myComp.getAttributeSet().getValue(SocBusAttributes.SOC_TRACE_VISIBLE).booleanValue()) {
                ((InstanceComponent)this.myComp).getInstance().fireInvalidated();
            }
        }
    }

    public void paint(int x, int y, Graphics2D g2, Instance inst, boolean visible, InstanceData info) {
        Graphics2D g = (Graphics2D)g2.create();
        g.translate(x + 5, y + 25);
        int nrOfTraces = inst.getAttributeValue(SocBusAttributes.NrOfTracesAttr).getWidth();
        int height = nrOfTraces * 30;
        g.setColor(Color.YELLOW);
        g.fillRect(0, 0, 630, height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, 630, height);
        if (!visible) {
            GraphicsUtil.drawCenteredText(g, Strings.S.get("SocHiddenForFasterSimulation"), 320, height / 2);
        } else if (info != null) {
            ((SocBusState)info).paint(g, Bounds.create(0, 0, 640, height));
        }
        g.dispose();
    }

    public SocBusState getNewState(Instance instance) {
        return new SocBusState(this, instance);
    }

    public SocBusState getRegPropagateState() {
        return (SocBusState)this.socManager.getdata(this.myComp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setVisible(false);
        }
    }

    @Override
    public void localeChanged() {
        this.okButton.setText(Strings.S.get("SocMemoryMapOk"));
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public static class SocBusState
    implements InstanceData,
    Cloneable,
    ComponentDataGuiProvider {
        private static final int NR_OF_TRACES_TO_KEEP = 10000;
        private final LinkedList<SocBusTransaction> trace = new LinkedList();
        private long startTraceIndex = 0L;
        private final SocBusStateInfo parent;
        private final Instance instance;
        private final ArrayList<SocBusStateListener> listeners;

        public SocBusState(SocBusStateInfo parent, Instance instance) {
            this.parent = parent;
            this.instance = instance;
            SocBus.MENU_PROVIDER.registerBusState(this, instance);
            this.listeners = new ArrayList();
        }

        @Override
        public SocBusState clone() {
            try {
                return (SocBusState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void addTransaction(SocBusTransaction t) {
            while (this.trace.size() >= 10000) {
                ++this.startTraceIndex;
                this.trace.removeFirst();
            }
            this.trace.addLast(t);
            for (SocBusStateListener l : this.listeners) {
                l.fireCanged(this);
            }
        }

        public void clear() {
            if (this.trace.size() == 0) {
                return;
            }
            this.trace.clear();
            this.startTraceIndex = 0L;
            for (SocBusStateListener l : this.listeners) {
                l.fireCanged(this);
            }
        }

        public void paint(Graphics2D g, Bounds b) {
            if (this.trace.isEmpty()) {
                GraphicsUtil.drawCenteredText(g, Strings.S.get("SocBusNoTrace"), b.getCenterX(), b.getCenterY());
                return;
            }
            long nrOfTraces = b.getHeight() / 30;
            if (nrOfTraces > (long)this.trace.size()) {
                nrOfTraces = this.trace.size();
            }
            int startIndex = this.trace.size() - 1;
            int i = 0;
            while ((long)i < nrOfTraces) {
                SocBusTransaction t = this.trace.get(startIndex - i);
                t.paint(b.getX() + 1, b.getY() + 1 + i * 30, g, this.startTraceIndex + (long)startIndex - (long)i);
                ++i;
            }
        }

        public int getNrOfEntires() {
            return this.trace.size();
        }

        public void registerListener(SocBusStateListener l) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        public void deregisterListener(SocBusStateListener l) {
            this.listeners.remove(l);
        }

        public SocBusStateTrace getEntry(int index, TraceWindowTableModel model) {
            if (index < 0 || index >= this.trace.size()) {
                if (index == 0) {
                    return new SocBusStateTrace(null, 0L, model);
                }
                return null;
            }
            long indx = this.startTraceIndex + (long)this.trace.size() - (long)index - 1L;
            return new SocBusStateTrace(this.trace.get(this.trace.size() - index - 1), indx, model);
        }

        @Override
        public void destroy() {
            if (this.parent != null && this.parent.isVisible()) {
                this.parent.setVisible(false);
            }
            SocBus.MENU_PROVIDER.deregisterBusState(this, this.instance);
        }

        public static class SocBusStateTrace
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private final SocBusTransaction action;
            private final long index;
            private final TraceWindowTableModel model;

            public SocBusStateTrace(SocBusTransaction action, long index, TraceWindowTableModel model) {
                this.action = action;
                this.index = index;
                this.model = model;
            }

            public SocBusTransaction getTransaction() {
                return this.action;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setFont(AppPreferences.getScaledFont(g2.getFont()));
                if (this.action == null) {
                    if (this.index == 0L) {
                        GraphicsUtil.drawCenteredText(g2, Strings.S.get("SocBusNoTrace"), this.getWidth() / 2, this.getHeight() / 2);
                    }
                    g2.dispose();
                    return;
                }
                int boxWidth = this.action.paint(g2, this.index, this.model.getBoxWidth());
                g2.dispose();
                if (boxWidth != this.model.getBoxWidth()) {
                    this.model.setBoxWidth(boxWidth);
                }
            }
        }
    }

    public static interface SocBusStateListener {
        public void fireCanged(SocBusState var1);
    }
}

