/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocInstanceFactory;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.file.ElfProgramHeader;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ProcessorReadElf {
    private static final int SUCCESS = 0;
    private static final int FILE_OPEN_ERROR = 1;
    private static final int ELF_HEADER_ERROR = 2;
    private static final int ARCHITECTURE_ERROR = 3;
    private static final int NO_EXECUTABLE_ERROR = 4;
    private static final int ENDIAN_MISMATCH_ERROR = 5;
    private static final int PROGRAM_HEADER_INVALID = 6;
    private static final int SECTION_HEADER_INVALID = 7;
    private static final int LOADABLE_SECTION_NOT_FOUND = 8;
    private static final int LOADABLE_SECTION_TOO_BIG = 9;
    private static final int LOADABLE_SECTION_READ_ERROR = 10;
    private static final int LOADABLE_SECTION_SIZE_ERROR = 11;
    private static final int NOT_SUPPORTED_YET_ERROR = 12;
    private static final int MEM_LOAD_ERROR = 13;
    private final SocProcessorInterface cpu;
    private final int architecture;
    private final File elfFile;
    private FileInputStream elfFileStream;
    private int status;
    private ElfHeader elfHeader;
    private ElfProgramHeader programHeader;
    private ElfSectionHeader sectionHeader;
    private long start;
    private long end;

    public ProcessorReadElf(File elfFile, Instance instance, int architecture, boolean littleEndian) {
        this.cpu = ((SocInstanceFactory)instance.getFactory()).getProcessorInterface(instance.getAttributeSet());
        this.architecture = architecture;
        this.elfFile = elfFile;
        this.status = 0;
        if (!this.open()) {
            return;
        }
        this.elfHeader = new ElfHeader(this.elfFileStream);
        this.close();
        if (!this.elfHeader.isValid()) {
            this.status = 2;
            return;
        }
        int arch = ElfHeader.getIntValue(this.elfHeader.getValue(18));
        if (arch != architecture) {
            this.status = 3;
            return;
        }
        int type = ElfHeader.getIntValue(this.elfHeader.getValue(17));
        if (type != 2) {
            this.status = 4;
            return;
        }
        if (this.elfHeader.isLittleEndian() != littleEndian) {
            this.status = 5;
            return;
        }
        if (!this.open()) {
            return;
        }
        this.programHeader = new ElfProgramHeader(this.elfFileStream, this.elfHeader);
        this.close();
        if (!this.programHeader.isValid()) {
            this.status = 6;
            return;
        }
        if (!this.open()) {
            return;
        }
        this.sectionHeader = new ElfSectionHeader(this.elfFileStream, this.elfHeader);
        this.close();
        if (!this.sectionHeader.isValid()) {
            this.status = 7;
            return;
        }
        if (!this.elfHeader.is32Bit()) {
            this.status = 12;
            return;
        }
        if (!this.open()) {
            return;
        }
        this.sectionHeader.readSectionNames(this.elfFileStream, this.elfHeader);
        this.close();
        if (!this.sectionHeader.isValid()) {
            this.status = 7;
            return;
        }
        if (!this.open()) {
            return;
        }
        this.sectionHeader.readSymbolTable(this.elfFileStream, this.elfHeader);
        this.close();
        if (!this.sectionHeader.isValid()) {
            this.status = 7;
            return;
        }
    }

    public boolean canExecute() {
        return this.status == 0;
    }

    public String getErrorMessage() {
        return switch (this.status) {
            case 0 -> Strings.S.get("ProcReadElfSuccess");
            case 1 -> Strings.S.get("ProcReadElfErrorOpeningFile");
            case 2 -> this.elfHeader.getErrorString();
            case 3 -> Strings.S.get("ProcReadElfArchError", this.elfHeader.getArchitectureString(ElfHeader.getIntValue(this.elfHeader.getValue(18))), this.elfHeader.getArchitectureString(this.architecture));
            case 4 -> Strings.S.get("ProcReadElfNotExecutable");
            case 5 -> Strings.S.get("ProcReadElfEndianMismatch", this.elfHeader.isLittleEndian() ? "little endian" : "big endian", this.elfHeader.isLittleEndian() ? "big endian" : "little endian");
            case 6 -> this.programHeader.getErrorString();
            case 7 -> this.sectionHeader.getErrorString();
            case 8 -> Strings.S.get("ProcReadElfLoadableSectionNotFound");
            case 9 -> Strings.S.get("ProcReadElfLoadableSectionTooBig");
            case 10 -> Strings.S.get("ProcReadElfLoadableSectionReadError");
            case 11 -> Strings.S.get("ProcReadElfLoadableSectionSizeError");
            case 12 -> Strings.S.get("ProcReadElf64BitNotSupportedYet");
            case 13 -> Strings.S.get("ProcReadElfMemoryError", String.format("0x%08X", this.start), String.format("0x%08X", this.end));
            default -> "BUG: Should not happen";
        };
    }

    public boolean execute(CircuitState cState) {
        for (int i = 0; i < this.programHeader.getNrOfHeaders(); ++i) {
            ElfProgramHeader.ProgramHeader h = this.programHeader.getHeader(i);
            if (ElfHeader.getIntValue(h.getValue(0)) != 1) continue;
            if (!this.open()) {
                return false;
            }
            try {
                this.elfFileStream.skip(ElfHeader.getLongValue(h.getValue(2)));
            }
            catch (IOException e) {
                this.status = 8;
                return false;
            }
            long sectionSize = ElfHeader.getLongValue(h.getValue(5));
            long memSize = ElfHeader.getLongValue(h.getValue(6));
            if (sectionSize > Integer.MAX_VALUE || memSize > Integer.MAX_VALUE) {
                this.status = 9;
                return false;
            }
            byte[] buffer = new byte[(int)sectionSize];
            int nrRead = 0;
            try {
                nrRead = this.elfFileStream.read(buffer);
            }
            catch (IOException e) {
                this.status = 10;
                return false;
            }
            if (sectionSize != (long)nrRead) {
                this.status = 11;
                return false;
            }
            long startAddr = ElfHeader.getLongValue(h.getValue(4));
            int j = 0;
            while ((long)j < memSize) {
                byte data = j < buffer.length ? buffer[j] : (byte)0;
                int addr = ElfHeader.getIntValue(ElfHeader.returnCorrectValue(startAddr + (long)j, true));
                SocBusTransaction trans = new SocBusTransaction(2, addr, data, 1, "elf");
                this.cpu.insertTransaction(trans, true, cState);
                if (trans.hasError()) {
                    this.start = startAddr;
                    this.end = startAddr + memSize - 1L;
                    this.status = 13;
                    return false;
                }
                ++j;
            }
        }
        this.cpu.setEntryPointandReset(cState, ElfHeader.getLongValue(this.elfHeader.getValue(20)), this.programHeader, this.sectionHeader);
        return true;
    }

    private boolean open() {
        try {
            this.elfFileStream = new FileInputStream(this.elfFile);
        }
        catch (FileNotFoundException e) {
            this.status = 1;
            return false;
        }
        return true;
    }

    private void close() {
        try {
            this.elfFileStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

