/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementWithPoker;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocUpStateInterface;
import com.cburch.logisim.soc.gui.CpuDrawSupport;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SocCpuShape
extends DynamicElementWithPoker {
    public SocCpuShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, CpuDrawSupport.simStateBounds.getWidth(), CpuDrawSupport.simStateBounds.getHeight()));
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        SocUpStateInterface data;
        SocUpStateInterface socUpStateInterface = data = state == null ? null : (SocUpStateInterface)this.getData(state);
        if (state == null || data == null || data.getSimState() == null) {
            g.drawRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            GraphicsUtil.drawCenteredText(g, Strings.S.get("RV32ShapeSimControl"), this.bounds.getCenterX(), this.bounds.getCenterY());
        } else {
            data.getSimState().paint(g, 0, 0, this.bounds);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public String getDisplayName() {
        return "SocCpu";
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-soc-cpu"));
    }

    @Override
    public void performClickAction(InstanceState state, MouseEvent e) {
        if (this.mouseInside(state, e).booleanValue()) {
            SocUpStateInterface data;
            CircuitState cstate = (CircuitState)state.getData();
            SocUpStateInterface socUpStateInterface = data = state == null ? null : (SocUpStateInterface)this.getData(cstate);
            if (data != null) {
                data.getSimState().buttonPressed();
            }
        }
    }
}

