/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocInstanceFactory;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.data.SocUpMenuProvider;
import com.cburch.logisim.soc.gui.CpuDrawSupport;
import com.cburch.logisim.soc.gui.SocCpuShape;
import com.cburch.logisim.soc.nios2.Nios2Attributes;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class Nios2
extends SocInstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "Nios2";
    public static final int CLOCK = 0;
    public static final int RESET = 1;
    public static final int DATAA = 2;
    public static final int DATAB = 3;
    public static final int START = 4;
    public static final int N = 5;
    public static final int A = 6;
    public static final int READRA = 7;
    public static final int B = 8;
    public static final int READRB = 9;
    public static final int C = 10;
    public static final int WRITERC = 11;
    public static final int RESULT = 12;
    public static final int DONE = 13;
    public static final int IRQSTART = 14;
    private static final String[] pinName = new String[]{"clock", "reset", "dataa", "datab", "start", "n", "a", "readra", "b", "readrb", "c", "writerc", "result", "done"};

    public Nios2() {
        super(_ID, Strings.S.getter("Nios2Component"), 1);
        this.setIcon(new ArithmeticIcon("uP", 2));
        this.setOffsetBounds(Bounds.create(0, 0, 640, 650));
        this.setInstancePoker(CpuDrawSupport.SimStatePoker.class);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new Nios2Attributes();
    }

    @Override
    public boolean providesSubCircuitMenu() {
        return true;
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return SocUpMenuProvider.SOCUPMENUPROVIDER.getMenu(instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    private void updatePorts(Instance instance) {
        int NrOfIrqs = instance.getAttributeValue(Nios2Attributes.NIOS2_STATE).getNrOfIrqs();
        Port[] ps = new Port[NrOfIrqs + 14];
        ps[1] = new Port(0, 620, "input", 1);
        ps[1].setToolTip(Strings.S.getter("Rv32imResetInput"));
        ps[0] = new Port(0, 640, "input", 1);
        ps[0].setToolTip(Strings.S.getter("Rv32imClockInput"));
        ps[2] = new Port(30, 0, "output", 32);
        ps[2].setToolTip(Strings.S.getter("Nios2Dataa"));
        ps[3] = new Port(80, 0, "output", 32);
        ps[3].setToolTip(Strings.S.getter("Nios2Datab"));
        ps[4] = new Port(130, 0, "output", 1);
        ps[4].setToolTip(Strings.S.getter("Nios2Start"));
        ps[5] = new Port(180, 0, "output", 8);
        ps[5].setToolTip(Strings.S.getter("Nios2N"));
        ps[6] = new Port(230, 0, "output", 5);
        ps[6].setToolTip(Strings.S.getter("Nios2A"));
        ps[7] = new Port(280, 0, "output", 1);
        ps[7].setToolTip(Strings.S.getter("Nios2ReadRa"));
        ps[8] = new Port(330, 0, "output", 5);
        ps[8].setToolTip(Strings.S.getter("Nios2B"));
        ps[9] = new Port(380, 0, "output", 1);
        ps[9].setToolTip(Strings.S.getter("Nios2ReadRb"));
        ps[10] = new Port(430, 0, "output", 5);
        ps[10].setToolTip(Strings.S.getter("Nios2C"));
        ps[11] = new Port(480, 0, "output", 1);
        ps[11].setToolTip(Strings.S.getter("Nios2WriteRc"));
        ps[13] = new Port(560, 0, "input", 1);
        ps[13].setToolTip(Strings.S.getter("Nios2Done"));
        ps[12] = new Port(610, 0, "input", 32);
        ps[12].setToolTip(Strings.S.getter("Nios2Result"));
        for (int i = 0; i < NrOfIrqs; ++i) {
            ps[i + 14] = new Port(0, 40 + i * 10, "input", 1);
            ps[i + 14].setToolTip(Strings.S.getter("Rv32imIrqInput", Integer.toString(i)));
        }
        instance.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() + 3, 0, -1);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == Nios2Attributes.NR_OF_IRQS) {
            this.updatePorts(instance);
            SocUpMenuProvider.SOCUPMENUPROVIDER.repaintStates(instance);
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            instance.fireInvalidated();
            SocUpMenuProvider.SOCUPMENUPROVIDER.repaintStates(instance);
        }
        super.instanceAttributeChanged(instance, attr);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int i;
        Location loc = painter.getLocation();
        Graphics2D g2 = (Graphics2D)painter.getGraphics();
        g2.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawLabel();
        painter.drawClock(0, Direction.EAST);
        painter.drawPort(1, "Reset", Direction.EAST);
        for (i = 2; i < 14; ++i) {
            painter.drawPort(i, pinName[i], Direction.NORTH);
        }
        for (i = 0; i < painter.getAttributeValue(Nios2Attributes.NIOS2_STATE).getNrOfIrqs(); ++i) {
            painter.drawPort(i + 14, "IRQ" + i, Direction.EAST);
        }
        Font f = g2.getFont();
        g2.setFont(StdAttr.DEFAULT_LABEL_FONT);
        GraphicsUtil.drawCenteredText(g2, "Nios2s simulator", loc.getX() + 320, loc.getY() + 640);
        g2.setFont(f);
        if (painter.isPrintView()) {
            return;
        }
        painter.getAttributeValue(SocSimulationManager.SOC_BUS_SELECT).paint(g2, Bounds.create(loc.getX() + CpuDrawSupport.busConBounds.getX(), loc.getY() + CpuDrawSupport.busConBounds.getY() + 10, CpuDrawSupport.busConBounds.getWidth(), CpuDrawSupport.busConBounds.getHeight()));
        Nios2State state = painter.getAttributeValue(Nios2Attributes.NIOS2_STATE);
        state.paint(loc.getX(), loc.getY() + 10, g2, painter.getInstance(), painter.getAttributeValue(Nios2Attributes.NIOS_STATE_VISIBLE), painter.getData());
    }

    @Override
    public void propagate(InstanceState state) {
        Nios2State.ProcessorState data = (Nios2State.ProcessorState)state.getData();
        if (data == null) {
            data = state.getAttributeValue(Nios2Attributes.NIOS2_STATE).getNewState(state.getInstance());
            state.setData(data);
        }
        if (state.getPortValue(1) == Value.TRUE) {
            data.reset();
        } else {
            data.setClock(state.getPortValue(0), ((InstanceStateImpl)state).getCircuitState());
        }
        int irqs = 0;
        for (int i = 0; i < state.getAttributeValue(Nios2Attributes.NR_OF_IRQS).getWidth(); ++i) {
            if (state.getPortValue(i + 14) != Value.TRUE) continue;
            irqs |= 1 << i;
        }
        data.setIpending(irqs);
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new SocCpuShape(x, y, path);
    }

    @Override
    public SocBusSlaveInterface getSlaveInterface(AttributeSet attrs) {
        return null;
    }

    @Override
    public SocBusSnifferInterface getSnifferInterface(AttributeSet attrs) {
        return null;
    }

    @Override
    public SocProcessorInterface getProcessorInterface(AttributeSet attrs) {
        return attrs.getValue(Nios2Attributes.NIOS2_STATE);
    }
}

