/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.Map;

public class ComparatorHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String TWOS_COMPLEMENT_STRING = "twosComplement";
    private static final int TWOS_COMPLEMENT_ID = -2;
    public static final Map<AttributeOption, Integer> SIGNED_MAP = new HashMap<AttributeOption, Integer>(){
        {
            this.put(Comparator.UNSIGNED_OPTION, 0);
            this.put(Comparator.SIGNED_OPTION, 1);
        }
    };

    public ComparatorHdlGeneratorFactory() {
        this.myParametersList.addBusOnly(NR_OF_BITS_STRING, -1).add(TWOS_COMPLEMENT_STRING, -2, 4, Comparator.MODE_ATTR, SIGNED_MAP);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        this.myPorts.add("input", "dataA", -1, 0, StdAttr.WIDTH).add("input", "dataB", -1, 1, StdAttr.WIDTH).add("output", "aGreaterThanB", 1, 2).add("output", "aEqualsB", 1, 3).add("output", "aLessThanB", 1, 4);
        if (attrs.getValue(StdAttr.WIDTH).getWidth() > 1) {
            this.myWires.addWire("s_signedLess", 1).addWire("s_unsignedLess", 1).addWire("s_signedGreater", 1).addWire("s_unsignedGreater", 1);
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair(TWOS_COMPLEMENT_STRING, TWOS_COMPLEMENT_STRING);
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        if (Hdl.isVhdl()) {
            if (nrOfBits == 1) {
                contents.empty().addVhdlKeywords().add("aEqualsB <= dataA {{xnor}} dataB;\naLessThanB <= dataA {{and}} {{not}}(dataB) {{when}} {{twosComplement}} = 1 {{else}} {{not}}(dataA) {{and}} dataB;\naGreaterThanB <= {{not}}(dataA) {{and}} dataB {{when}} {{twosComplement}} = 1 {{else}} dataA {{and}} {{not}}(dataB);\n");
            } else {
                contents.empty().addVhdlKeywords().add("s_signedLess      <= '1' {{when}} signed(dataA) < signed(dataB) {{else}} '0';\ns_unsignedLess    <= '1' {{when}} unsigned(dataA) < unsigned(dataB) {{else}} '0';\ns_signedGreater   <= '1' {{when}} signed(dataA) > signed(dataB) {{else}} '0';\ns_unsignedGreater <= '1' {{when}} unsigned(dataA) > unsigned(dataB) {{else}} '0';\n\naEqualsB      <= '1' {{when}} dataA = dataB ELSE '0';\naGreaterThanB <= s_signedGreater {{when}} {{twosComplement}} = 1 {{else}} s_unsignedGreater;\naLessThanB    <= s_signedLess {{when}} {{twosComplement}} = 1 {{else}} s_unsignedLess;\n");
            }
        } else if (nrOfBits == 1) {
            contents.add("assign aEqualsB      = (dataA == dataB);\nassign aLessThanB    = (dataA < dataB);\nassign aGreaterThanB = (dataA > dataB);\n");
        } else {
            contents.add("assign s_signedLess      = ($signed(dataA) < $signed(dataB));\nassign s_unsignedLess    = (dataA < dataB);\nassign s_signedGreater   = ($signed(dataA) > $signed(dataB));\nassign s_unsignedGreater = (dataA > dataB);\n\nassign aEqualsB      = (dataA == dataB);\nassign aGreaterThanB = ({{twosComplement}}==1) ? s_signedGreater : s_unsignedGreater;\nassign aLessThanB    = ({{twosComplement}}==1) ? s_signedLess : s_unsignedLess;\n");
        }
        return contents.empty();
    }
}

