/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.NegatorHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import java.awt.Color;

public class Negator
extends InstanceFactory {
    public static final String _ID = "Negator";
    public static final int IN = 0;
    public static final int OUT = 1;

    public Negator() {
        super(_ID, Strings.S.getter("negatorComponent"), new NegatorHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create(8)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("-x"));
        Port[] ps = new Port[]{new Port(-40, 0, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH)};
        ps[0].setToolTip(Strings.S.getter("negatorInputTip"));
        ps[1].setToolTip(Strings.S.getter("negatorOutputTip"));
        this.setPorts(ps);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder CompleteName = new StringBuilder();
        if (attrs.getValue(StdAttr.WIDTH).getWidth() == 1) {
            CompleteName.append("BitNegator");
        } else {
            CompleteName.append(CorrectLabel.getCorrectLabel(this.getName()));
        }
        return CompleteName.toString();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.getGraphics().setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawPort(0);
        painter.drawPort(1, "-x", Direction.WEST);
    }

    @Override
    public void propagate(InstanceState state) {
        Value out;
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        Value in = state.getPortValue(0);
        if (in.isFullyDefined()) {
            out = Value.createKnown(in.getBitWidth(), -in.toLongValue());
        } else {
            int pos;
            Value[] bits = in.getAll();
            Value fill = Value.FALSE;
            for (pos = 0; pos < bits.length; ++pos) {
                if (bits[pos] == Value.FALSE) {
                    bits[pos] = fill;
                    continue;
                }
                if (bits[pos] == Value.TRUE) {
                    if (fill != Value.FALSE) {
                        bits[pos] = fill;
                    }
                    ++pos;
                    break;
                }
                if (bits[pos] == Value.ERROR) {
                    fill = Value.ERROR;
                    continue;
                }
                if (fill == Value.FALSE) {
                    fill = bits[pos];
                    continue;
                }
                bits[pos] = fill;
            }
            while (pos < bits.length) {
                if (bits[pos] == Value.TRUE) {
                    bits[pos] = Value.FALSE;
                } else if (bits[pos] == Value.FALSE) {
                    bits[pos] = Value.TRUE;
                }
                ++pos;
            }
            out = Value.create(bits);
        }
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(1, out, delay);
    }
}

